/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.keymanagement.KmsCrypto;
import com.oracle.bmc.keymanagement.KmsCryptoClientBuilder;
import com.oracle.bmc.keymanagement.model.DecryptedData;
import com.oracle.bmc.keymanagement.model.EncryptedData;
import com.oracle.bmc.keymanagement.model.ExportedKeyData;
import com.oracle.bmc.keymanagement.model.GeneratedKey;
import com.oracle.bmc.keymanagement.model.SignedData;
import com.oracle.bmc.keymanagement.model.VerifiedData;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.EncryptRequest;
import com.oracle.bmc.keymanagement.requests.ExportKeyRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.requests.SignRequest;
import com.oracle.bmc.keymanagement.requests.VerifyRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.EncryptResponse;
import com.oracle.bmc.keymanagement.responses.ExportKeyResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.keymanagement.responses.SignResponse;
import com.oracle.bmc.keymanagement.responses.VerifyResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsCryptoClient
extends BaseSyncClient
implements KmsCrypto {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSCRYPTO").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsCryptoClient.class);

    KmsCryptoClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static KmsCryptoClientBuilder builder() {
        return new KmsCryptoClientBuilder(SERVICE);
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest request) {
        Objects.requireNonNull(request.getDecryptDataDetails(), "decryptDataDetails is required");
        return (DecryptResponse)this.clientCall(request, DecryptResponse::builder).logger(LOG, "decrypt").serviceDetails("KmsCrypto", "Decrypt", "https://docs.oracle.com/iaas/api/#/en/key/release/DecryptedData/Decrypt").method(Method.POST).requestBuilder(DecryptRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("decrypt").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DecryptedData.class, DecryptResponse.Builder::decryptedData).handleResponseHeaderString("opc-request-id", DecryptResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest request) {
        Objects.requireNonNull(request.getEncryptDataDetails(), "encryptDataDetails is required");
        return (EncryptResponse)this.clientCall(request, EncryptResponse::builder).logger(LOG, "encrypt").serviceDetails("KmsCrypto", "Encrypt", "https://docs.oracle.com/iaas/api/#/en/key/release/EncryptedData/Encrypt").method(Method.POST).requestBuilder(EncryptRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("encrypt").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EncryptedData.class, EncryptResponse.Builder::encryptedData).handleResponseHeaderString("opc-request-id", EncryptResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportKeyResponse exportKey(ExportKeyRequest request) {
        Objects.requireNonNull(request.getExportKeyDetails(), "exportKeyDetails is required");
        return (ExportKeyResponse)this.clientCall(request, ExportKeyResponse::builder).logger(LOG, "exportKey").serviceDetails("KmsCrypto", "ExportKey", "https://docs.oracle.com/iaas/api/#/en/key/release/ExportedKeyData/ExportKey").method(Method.POST).requestBuilder(ExportKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("exportKey").accept(new String[]{"application/json"}).hasBody().handleBody(ExportedKeyData.class, ExportKeyResponse.Builder::exportedKeyData).handleResponseHeaderString("opc-request-id", ExportKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateDataEncryptionKeyResponse generateDataEncryptionKey(GenerateDataEncryptionKeyRequest request) {
        Objects.requireNonNull(request.getGenerateKeyDetails(), "generateKeyDetails is required");
        return (GenerateDataEncryptionKeyResponse)this.clientCall(request, GenerateDataEncryptionKeyResponse::builder).logger(LOG, "generateDataEncryptionKey").serviceDetails("KmsCrypto", "GenerateDataEncryptionKey", "https://docs.oracle.com/iaas/api/#/en/key/release/GeneratedKey/GenerateDataEncryptionKey").method(Method.POST).requestBuilder(GenerateDataEncryptionKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("generateDataEncryptionKey").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GeneratedKey.class, GenerateDataEncryptionKeyResponse.Builder::generatedKey).handleResponseHeaderString("opc-request-id", GenerateDataEncryptionKeyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SignResponse sign(SignRequest request) {
        Objects.requireNonNull(request.getSignDataDetails(), "signDataDetails is required");
        return (SignResponse)this.clientCall(request, SignResponse::builder).logger(LOG, "sign").serviceDetails("KmsCrypto", "Sign", "https://docs.oracle.com/iaas/api/#/en/key/release/SignedData/Sign").method(Method.POST).requestBuilder(SignRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("sign").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SignedData.class, SignResponse.Builder::signedData).handleResponseHeaderString("opc-request-id", SignResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VerifyResponse verify(VerifyRequest request) {
        Objects.requireNonNull(request.getVerifyDataDetails(), "verifyDataDetails is required");
        return (VerifyResponse)this.clientCall(request, VerifyResponse::builder).logger(LOG, "verify").serviceDetails("KmsCrypto", "Verify", "https://docs.oracle.com/iaas/api/#/en/key/release/VerifiedData/Verify").method(Method.POST).requestBuilder(VerifyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("verify").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VerifiedData.class, VerifyResponse.Builder::verifiedData).handleResponseHeaderString("opc-request-id", VerifyResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public KmsCryptoClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(KmsCryptoClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsCryptoClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((KmsCryptoClientBuilder)KmsCryptoClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)KmsCryptoClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)KmsCryptoClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)KmsCryptoClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)((KmsCryptoClientBuilder)KmsCryptoClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }
}

