/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.base;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.behavior.ajax.AjaxBehaviorHandler;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.context.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorHandler<E extends AbstractBehavior>
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    protected static String MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY = "javax.faces.RetargetableHandlers";
    protected static String MOJARRA_22_ATTACHED_OBJECT_HANDLERS_KEY = "javax.faces.view.AttachedObjectHandlers";
    protected static Method MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE;
    protected static Method MYFACES_ADD_ATTACHED_OBJECT_HANDLER;

    public AbstractBehaviorHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        String eventName = this.getEventName();
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(faceletContext, parent);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList && !tagApplied) {
                throw new TagException(this.tag, "Composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (supportedEvent) {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context.getExternalContext().getApplicationMap().containsKey("com.sun.faces.ApplicationAssociate")) {
                    this.addAttachedObjectHandlerToMojarra(parent);
                } else {
                    this.addAttachedObjectHandlerToMyFaces(parent, faceletContext);
                }
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Composite component does not support event " + eventName);
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(faceletContext, parent);
        } else {
            throw new TagException(this.tag, "Unable to attach behavior to non-ClientBehaviorHolder parent");
        }
    }

    public String getEventName() {
        if (this.event == null) {
            return null;
        }
        if (this.event.isLiteral()) {
            return this.event.getValue();
        }
        FaceletContext faceletContext = this.getFaceletContext(FacesContext.getCurrentInstance());
        ValueExpression expression = this.event.getValueExpression(faceletContext, String.class);
        return (String)expression.getValue((ELContext)faceletContext);
    }

    protected abstract E createBehavior(FaceletContext var1, String var2);

    protected void setBehaviorAttribute(FaceletContext ctx, E behavior, TagAttribute attr, Class<?> type) {
        if (attr != null) {
            String attributeName = attr.getLocalName();
            if (attr.isLiteral()) {
                ((AbstractBehavior)((Object)behavior)).setLiteral(attributeName, attr.getObject(ctx, type));
            } else {
                ((AbstractBehavior)((Object)behavior)).setValueExpression(attributeName, attr.getValueExpression(ctx, type));
            }
        }
    }

    protected FaceletContext getFaceletContext(FacesContext context) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("javax.faces.FACELET_CONTEXT");
        if (faceletContext == null) {
            faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        }
        return faceletContext;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = this.getFaceletContext(context);
        this.applyAttachedObject(faceletContext, parent);
    }

    public void applyAttachedObject(FaceletContext faceletContext, UIComponent parent) {
        ClientBehaviorHolder holder = (ClientBehaviorHolder)parent;
        String eventName = this.getEventName();
        if (null == eventName) {
            eventName = holder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection eventNames = holder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, "Event:" + eventName + " is not supported.");
            }
        }
        E behavior = this.createBehavior(faceletContext, eventName);
        holder.addClientBehavior(eventName, behavior);
    }

    public String getFor() {
        return null;
    }

    protected void addAttachedObjectHandlerToMojarra(UIComponent component) {
        Map attrs;
        ArrayList<AbstractBehaviorHandler> result;
        String key = MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY;
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22()) {
            key = MOJARRA_22_ATTACHED_OBJECT_HANDLERS_KEY;
        }
        if ((result = (ArrayList<AbstractBehaviorHandler>)(attrs = component.getAttributes()).get(key)) == null) {
            result = new ArrayList<AbstractBehaviorHandler>();
            attrs.put(key, result);
        }
        result.add(this);
    }

    protected void addAttachedObjectHandlerToMyFaces(UIComponent component, FaceletContext ctx) {
        try {
            if (MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE == null || MYFACES_ADD_ATTACHED_OBJECT_HANDLER == null) {
                Class<?> clazz = Class.forName("org.apache.myfaces.view.facelets.FaceletCompositionContext");
                MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE = clazz.getDeclaredMethod("getCurrentInstance", FaceletContext.class);
                MYFACES_ADD_ATTACHED_OBJECT_HANDLER = clazz.getDeclaredMethod("addAttachedObjectHandler", UIComponent.class, AttachedObjectHandler.class);
            }
            Object faceletCompositionContextInstance = MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE.invoke(null, ctx);
            MYFACES_ADD_ATTACHED_OBJECT_HANDLER.invoke(faceletCompositionContextInstance, new Object[]{component, this});
        }
        catch (Exception ex) {
            Logger.getLogger(AjaxBehaviorHandler.class.getName()).log(Level.SEVERE, "Could not add AttachedObjectHandler to MyFaces!", ex);
        }
    }
}

