/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum LibCType implements Api
{
    GLIBC("glibc", "glibc"),
    MUSL("musl", "musl"),
    LIBC("libc", "libc"),
    C_STD_LIB("c std. lib", "c_std_lib"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private LibCType(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public LibCType getDefault() {
        return NONE;
    }

    @Override
    public LibCType getNotFound() {
        return NOT_FOUND;
    }

    public LibCType[] getAll() {
        return LibCType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static LibCType fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "musl": 
            case "MUSL": 
            case "linux_musl": 
            case "linux-musl": 
            case "alpine_linux": 
            case "alpine": 
            case "alpine-linux": {
                return MUSL;
            }
            case "glibc": 
            case "GLIBC": 
            case "linux": 
            case "Linux": 
            case "LINUX": {
                return GLIBC;
            }
            case "c_std_lib": 
            case "C_STD_LIB": 
            case "c-std-lib": 
            case "C-STD-LIB": 
            case "windows": 
            case "Windows": 
            case "win": 
            case "Win": {
                return C_STD_LIB;
            }
            case "libc": 
            case "LIBC": 
            case "macos": 
            case "MACOS": 
            case "macosx": 
            case "MACOSX": 
            case "aix": 
            case "AIX": 
            case "qnx": 
            case "QNX": 
            case "solaris": 
            case "SOLARIS": 
            case "darwin": 
            case "DARWIN": {
                return LIBC;
            }
        }
        return NOT_FOUND;
    }

    public static List<LibCType> getAsList() {
        return Arrays.asList(LibCType.values());
    }
}

