/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class TreePath
implements Iterable<Tree> {
    private CompilationUnitTree compilationUnit;
    private Tree leaf;
    private TreePath parent;

    public static TreePath getPath(CompilationUnitTree unit, Tree target) {
        return TreePath.getPath(new TreePath(unit), target);
    }

    public static TreePath getPath(TreePath path, Tree target) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(target);
        class PathFinder
        extends TreePathScanner<TreePath, Tree> {
            private TreePath result;

            PathFinder() {
            }

            @Override
            public TreePath scan(TreePath path, Tree target) {
                super.scan(path, target);
                return this.result;
            }

            @Override
            public TreePath scan(Tree tree, Tree target) {
                if (this.result == null) {
                    if (tree == target) {
                        this.result = new TreePath(this.getCurrentPath(), target);
                    } else {
                        super.scan(tree, target);
                    }
                }
                return this.result;
            }

            @Override
            public TreePath scan(Iterable<? extends Tree> nodes, Tree target) {
                if (nodes != null && this.result == null) {
                    for (Tree tree : nodes) {
                        this.scan(tree, target);
                        if (this.result == null) continue;
                        break;
                    }
                }
                return this.result;
            }
        }
        return path.getLeaf() == target ? path : new PathFinder().scan(path, target);
    }

    public TreePath(CompilationUnitTree node) {
        this(null, node);
    }

    public TreePath(TreePath path, Tree tree) {
        if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
            this.compilationUnit = (CompilationUnitTree)tree;
            this.parent = null;
        } else {
            this.compilationUnit = path.compilationUnit;
            this.parent = path;
        }
        this.leaf = tree;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this.compilationUnit;
    }

    public Tree getLeaf() {
        return this.leaf;
    }

    public TreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new Iterator<Tree>(){
            private TreePath next;
            {
                this.next = TreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Tree next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Tree t = this.next.leaf;
                this.next = this.next.parent;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

