/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAppCatalogListingRequest
extends BmcRequest<Void> {
    private String listingId;

    public String getListingId() {
        return this.listingId;
    }

    public Builder toBuilder() {
        return new Builder().listingId(this.listingId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAppCatalogListingRequest)) {
            return false;
        }
        GetAppCatalogListingRequest other = (GetAppCatalogListingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.listingId, other.listingId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAppCatalogListingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String listingId = null;

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAppCatalogListingRequest o) {
            this.listingId(o.getListingId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAppCatalogListingRequest build() {
            GetAppCatalogListingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAppCatalogListingRequest buildWithoutInvocationCallback() {
            GetAppCatalogListingRequest request = new GetAppCatalogListingRequest();
            request.listingId = this.listingId;
            return request;
        }
    }
}

