/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.openide.filesystems.FileObject;

public class CompoundModificationResult
implements ModificationResult {
    private final List<ModificationResult> results;

    public CompoundModificationResult(List<ModificationResult> results) {
        this.results = results;
    }

    public String getResultingSource(FileObject file) throws IOException, IllegalArgumentException {
        for (ModificationResult r : this.results) {
            if (!r.getModifiedFileObjects().contains(file)) continue;
            return r.getResultingSource(file);
        }
        throw new IllegalArgumentException();
    }

    public Collection<? extends FileObject> getModifiedFileObjects() {
        LinkedHashSet s = new LinkedHashSet();
        for (ModificationResult r : this.results) {
            s.addAll(r.getModifiedFileObjects());
        }
        return s;
    }

    public Collection<? extends File> getNewFiles() {
        LinkedHashSet files = new LinkedHashSet();
        for (ModificationResult r : this.results) {
            files.addAll(r.getNewFiles());
        }
        return files;
    }

    public void commit() throws IOException {
        for (ModificationResult r : this.results) {
            r.commit();
        }
    }
}

