/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.queries.Bundle;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.ProjectIconProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class Info
implements ProjectInformation,
PropertyChangeListener {
    private static final String GRADLE_BADGE = "org/netbeans/modules/gradle/resources/gradle-large-badge.png";
    private final Project project;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final PreferenceChangeListener preferenceChangeListener = evt -> {
        if ("displayDescription".equals(evt.getKey())) {
            this.pcs.firePropertyChange("displayName", null, null);
        }
    };
    private final AtomicBoolean prefChangeListenerSet = new AtomicBoolean(false);

    public Info(Project project) {
        this.project = project;
    }

    public String getName() {
        NbGradleProject nb = NbGradleProject.get(this.project);
        GradleBaseProject prj = GradleBaseProject.get(this.project);
        if (!nb.isGradleProjectLoaded() || prj == null || prj.getName() == null) {
            return this.project.getProjectDirectory().getNameExt();
        }
        String ret = prj.isRoot() ? prj.getName() : prj.getRootDir().getName() + prj.getPath();
        return ret;
    }

    public String getDisplayName() {
        String ret;
        NbGradleProject nb = NbGradleProject.get(this.project);
        if (SwingUtilities.isEventDispatchThread() && !nb.isGradleProjectLoaded()) {
            return this.project.getProjectDirectory().getNameExt();
        }
        GradleBaseProject prj = GradleBaseProject.get(this.project);
        if (GradleSettings.getDefault().isDisplayDesctiption() && prj.getDescription() != null && !prj.getDescription().isEmpty()) {
            ret = prj.getDescription();
        } else {
            GradleFiles gf;
            if (this.project instanceof NbGradleProjectImpl && (gf = ((NbGradleProjectImpl)this.project).getGradleFiles()).isBuildSrcProject()) {
                return Bundle.LBL_BuildSrcProject(gf.getRootDir().getName());
            }
            ret = this.getName();
        }
        return ret;
    }

    public Icon getIcon() {
        Collection providers = this.project.getLookup().lookupAll(ProjectIconProvider.class);
        Image icon = null;
        for (ProjectIconProvider provider : providers) {
            icon = provider.getIcon();
            if (icon == null) continue;
            if (!provider.isGradleBadgeRequested()) break;
            Image badge = ImageUtilities.loadImage((String)GRADLE_BADGE);
            icon = ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)0, (int)0);
            break;
        }
        return icon != null ? ImageUtilities.image2Icon(icon) : NbGradleProject.getIcon();
    }

    public Project getProject() {
        return this.project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.prefChangeListenerSet.compareAndSet(false, true)) {
            Preferences prefs = GradleSettings.getDefault().getPreferences();
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.preferenceChangeListener, (Object)prefs));
        }
        if (!this.pcs.hasListeners(null)) {
            ((NbGradleProject)this.project.getLookup().lookup(NbGradleProject.class)).addPropertyChangeListener(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        boolean had = this.pcs.hasListeners(null);
        this.pcs.removePropertyChangeListener(listener);
        if (had && !this.pcs.hasListeners(null)) {
            ((NbGradleProject)this.project.getLookup().lookup(NbGradleProject.class)).removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ProjectInfo".equals(evt.getPropertyName())) {
            this.pcs.firePropertyChange("name", null, null);
            this.pcs.firePropertyChange("displayName", null, null);
            this.pcs.firePropertyChange("icon", null, null);
        }
    }
}

