/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.util.Collections;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;

public final class RunConfig {
    final Project project;
    final Set<ExecFlag> execFlags;
    final GradleCommandLine commandLine;
    final String action;
    final String displayName;
    final GradleExecConfiguration execConfig;

    public RunConfig(Project project, String action, String displayName, Set<ExecFlag> execFlags, GradleCommandLine commandLine) {
        this(project, action, displayName, execFlags, commandLine, null);
    }

    public RunConfig(Project project, String action, String displayName, Set<ExecFlag> execFlags, GradleCommandLine commandLine, GradleExecConfiguration execConfig) {
        this.project = project;
        this.action = action;
        this.displayName = displayName;
        this.execFlags = Collections.unmodifiableSet(execFlags);
        this.commandLine = commandLine;
        this.execConfig = execConfig;
    }

    public Project getProject() {
        return this.project;
    }

    public GradleCommandLine getCommandLine() {
        return this.commandLine;
    }

    public RunConfig withCommandLine(GradleCommandLine cmd) {
        return new RunConfig(this.project, this.action, this.displayName, this.execFlags, cmd, this.execConfig);
    }

    public Set<ExecFlag> getExecFlags() {
        return this.execFlags;
    }

    public String getTaskDisplayName() {
        return this.displayName;
    }

    public String getActionName() {
        return this.action;
    }

    @CheckForNull
    public GradleExecConfiguration getExecConfig() {
        return this.execConfig;
    }

    public static enum ExecFlag {
        REPEATABLE;

    }
}

