/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.diff.DiffController;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.tree.Bundle;
import org.netbeans.modules.diff.tree.ExclusionPattern;
import org.netbeans.modules.diff.tree.FileStreamSource;
import org.netbeans.modules.diff.tree.FilterPanel;
import org.netbeans.modules.diff.tree.RecursiveDiffer;
import org.netbeans.modules.diff.tree.TreeEntry;
import org.netbeans.modules.diff.tree.TreeEntryNode;
import org.netbeans.modules.diff.tree.TreeEntryRenderDataProvider;
import org.netbeans.modules.diff.tree.TreeEntryRowModel;
import org.netbeans.modules.diff.tree.TreeEntryTreeModel;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

@TopComponent.Description(preferredID="TreeDiffViewerTopComponent", persistenceType=2)
public final class TreeDiffViewerTopComponent
extends TopComponent {
    private static final RequestProcessor IOHANDLER = new RequestProcessor("TreeDiffViewerTopComponentIOHandler");
    private static final TreeEntryRenderDataProvider FILENAME_DATA_PROVIDER = new TreeEntryRenderDataProvider(false);
    private static final TreeEntryRenderDataProvider PATH_DATA_PROVIDER = new TreeEntryRenderDataProvider(true);
    private final RecursiveDiffer recursiveDiffer;
    private final TreeEntryRowModel rowModel = new TreeEntryRowModel();
    private final TreeEntryTreeModel treeModel = new TreeEntryTreeModel(null);
    private final OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)this.treeModel, (RowModel)this.rowModel, (boolean)false, (String)"Files");
    private final JPopupMenu contextMenu;
    private List<ExclusionPattern> filterPatterns = new ArrayList<ExclusionPattern>();
    private List<TreeEntry> selectedTreeEntries = Collections.emptyList();
    private final PropertyChangeListener modifiedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            TreeEntry te = (TreeEntry)pce.getSource();
            ArrayList<TreeEntry> path = new ArrayList<TreeEntry>();
            for (TreeEntry nextElement = te; nextElement != null; nextElement = nextElement.getParent()) {
                path.add(0, nextElement);
            }
            TreePath tp = new TreePath(path.toArray(TreeEntry[]::new));
            ((OutlineModel)TreeDiffViewerTopComponent.this.fileTree.getModel()).valueForPathChanged(tp, (Object)te);
        }
    };
    private JCheckBox applyFilterButton;
    private JLabel basepathLabel;
    private JLabel basepathValue;
    private JButton cancelButton;
    private JPanel diffOutput;
    private JPanel diffPanelWrapper;
    private JButton editFilterButton;
    private Outline fileTree;
    private JScrollPane fileTreeScrollPane;
    private JCheckBox flattenResult;
    private JPanel infoPanel;
    private JToolBar jToolBar1;
    private JSplitPane outputPane;
    private JButton refreshButton;
    private JLabel scanningLabel;
    private JPanel scanningPanelWrapper;
    private JButton swapPathsButton;
    private JLabel targetpathLabel;
    private JLabel targetpathValue;

    public TreeDiffViewerTopComponent(RecursiveDiffer recursiveDiffer) {
        this.contextMenu = new JPopupMenu();
        final JMenuItem deleteSource = new JMenuItem("Delete Source");
        final JMenuItem deleteTarget = new JMenuItem("Delete Target");
        final JMenuItem copySourceTarget = new JMenuItem("Copy Source to Target");
        final JMenuItem copyTargetSource = new JMenuItem("Copy Target to Source");
        final JMenuItem openSource = new JMenuItem("Open Source");
        final JMenuItem openTarget = new JMenuItem("Open Target");
        openSource.addActionListener(ae -> {
            for (TreeEntry selectedTreeEntry : this.selectedTreeEntries) {
                try {
                    ((OpenCookie)DataObject.find((FileObject)selectedTreeEntry.getFile1()).getLookup().lookup(OpenCookie.class)).open();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        openTarget.addActionListener(ae -> {
            for (TreeEntry selectedTreeEntry : this.selectedTreeEntries) {
                try {
                    ((OpenCookie)DataObject.find((FileObject)selectedTreeEntry.getFile2()).getLookup().lookup(OpenCookie.class)).open();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        deleteSource.addActionListener(es -> {
            ArrayList<TreeEntry> targetEntries = new ArrayList<TreeEntry>(this.selectedTreeEntries);
            this.selectedTreeEntries.clear();
            this.diffOutput.removeAll();
            IOHANDLER.execute(() -> {
                for (TreeEntry selectedTreeEntry : targetEntries) {
                    try {
                        selectedTreeEntry.getFile1().delete();
                        recursiveDiffer.removeTreeEntry(selectedTreeEntry);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        });
        deleteTarget.addActionListener(es -> {
            ArrayList<TreeEntry> targetEntries = new ArrayList<TreeEntry>(this.selectedTreeEntries);
            this.selectedTreeEntries.clear();
            this.diffOutput.removeAll();
            IOHANDLER.execute(() -> {
                for (TreeEntry selectedTreeEntry : targetEntries) {
                    try {
                        selectedTreeEntry.getFile2().delete();
                        recursiveDiffer.removeTreeEntry(selectedTreeEntry);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        });
        copySourceTarget.addActionListener(es -> IOHANDLER.execute(() -> {
            for (TreeEntry selectedTreeEntry : this.selectedTreeEntries) {
                try {
                    FileObject targetFolder;
                    if (selectedTreeEntry.getFile2() != null) {
                        selectedTreeEntry.getFile2().delete();
                    }
                    if ((targetFolder = selectedTreeEntry.getBasePath2().getFileObject(selectedTreeEntry.getRelativeParent())) == null) {
                        targetFolder = FileUtil.createFolder((FileObject)selectedTreeEntry.getBasePath2(), (String)selectedTreeEntry.getRelativeParent());
                    }
                    selectedTreeEntry.getFile1().copy(targetFolder, selectedTreeEntry.getFile1().getName(), selectedTreeEntry.getFile1().getExt());
                    recursiveDiffer.removeTreeEntry(selectedTreeEntry);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }));
        copyTargetSource.addActionListener(es -> IOHANDLER.execute(() -> {
            for (TreeEntry selectedTreeEntry : this.selectedTreeEntries) {
                try {
                    FileObject targetFolder;
                    if (selectedTreeEntry.getFile1() != null) {
                        selectedTreeEntry.getFile1().delete();
                    }
                    if ((targetFolder = selectedTreeEntry.getBasePath1().getFileObject(selectedTreeEntry.getRelativeParent())) == null) {
                        targetFolder = FileUtil.createFolder((FileObject)selectedTreeEntry.getBasePath1(), (String)selectedTreeEntry.getRelativeParent());
                    }
                    selectedTreeEntry.getFile2().copy(targetFolder, selectedTreeEntry.getFile2().getName(), selectedTreeEntry.getFile2().getExt());
                    recursiveDiffer.removeTreeEntry(selectedTreeEntry);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }));
        this.contextMenu.add(openSource);
        this.contextMenu.add(openTarget);
        this.contextMenu.add(copySourceTarget);
        this.contextMenu.add(copyTargetSource);
        this.contextMenu.add(deleteSource);
        this.contextMenu.add(deleteTarget);
        this.contextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
                deleteSource.setVisible(!TreeDiffViewerTopComponent.this.selectedTreeEntries.isEmpty() && TreeDiffViewerTopComponent.this.selectedTreeEntries.stream().allMatch(ste -> ste.getFile1() != null && ste.getFile2() == null));
                deleteTarget.setVisible(!TreeDiffViewerTopComponent.this.selectedTreeEntries.isEmpty() && TreeDiffViewerTopComponent.this.selectedTreeEntries.stream().allMatch(ste -> ste.getFile1() == null && ste.getFile2() != null));
                copySourceTarget.setVisible(!TreeDiffViewerTopComponent.this.selectedTreeEntries.isEmpty() && TreeDiffViewerTopComponent.this.selectedTreeEntries.stream().allMatch(ste -> ste.getFile1() != null));
                copyTargetSource.setVisible(!TreeDiffViewerTopComponent.this.selectedTreeEntries.isEmpty() && TreeDiffViewerTopComponent.this.selectedTreeEntries.stream().allMatch(ste -> ste.getFile2() != null));
                openSource.setVisible(copySourceTarget.isVisible());
                openTarget.setVisible(copyTargetSource.isVisible());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent pme) {
            }
        });
        this.recursiveDiffer = recursiveDiffer;
        this.initComponents();
        this.filterPatterns = DiffModuleConfig.getDefault().getTreeExclusionList();
        this.setName(Bundle.CTL_TreeDiffViewerTopComponent());
        try {
            StringBuilder tooltipText = new StringBuilder();
            tooltipText.append("<html>Tree diff:<br>Source: ");
            tooltipText.append(XMLUtil.toElementContent((String)recursiveDiffer.getDir1().getPath()));
            tooltipText.append("<br>Target: ");
            tooltipText.append(XMLUtil.toElementContent((String)recursiveDiffer.getDir2().getPath()));
            tooltipText.append("</html>");
            this.setToolTipText(tooltipText.toString());
        }
        catch (CharConversionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.flattenResult.setSelected(recursiveDiffer.isFlatten());
        this.flattenResult.addActionListener(ae -> recursiveDiffer.setFlatten(this.flattenResult.isSelected()));
        this.fileTree.setComponentPopupMenu(this.contextMenu);
        this.fileTree.setModel((TableModel)this.outlineModel);
        this.fileTree.setRootVisible(false);
        this.fileTree.setRenderDataProvider((RenderDataProvider)FILENAME_DATA_PROVIDER);
        this.fileTree.getSelectionModel().addListSelectionListener(lse -> {
            if (!lse.getValueIsAdjusting()) {
                int selectedRowIdx = this.fileTree.getSelectedRow();
                if (selectedRowIdx >= 0) {
                    ArrayList<TreeEntry> selectedEntries = new ArrayList<TreeEntry>(this.fileTree.getSelectedRowCount());
                    int selectedModelRow = this.fileTree.convertRowIndexToModel(selectedRowIdx);
                    TreeEntry te = (TreeEntry)this.fileTree.getModel().getValueAt(selectedModelRow, 0);
                    selectedEntries.add(te);
                    for (int viewIdx : this.fileTree.getSelectedRows()) {
                        if (viewIdx == selectedRowIdx) continue;
                        selectedModelRow = this.fileTree.convertRowIndexToModel(selectedRowIdx);
                        te = (TreeEntry)this.fileTree.getModel().getValueAt(selectedModelRow, 0);
                        selectedEntries.add(te);
                    }
                    this.selectedTreeEntries = selectedEntries;
                    this.setActivatedNodes(new Node[]{TreeEntryNode.create((TreeEntry)selectedEntries.get(0))});
                    this.updateDiff();
                } else {
                    this.selectedTreeEntries = Collections.emptyList();
                    this.setActivatedNodes(null);
                    this.updateDiff();
                }
            }
        });
        this.fileTree.getSelectionModel().setSelectionMode(2);
        ETableColumnModel tcm = (ETableColumnModel)this.fileTree.getColumnModel();
        for (int i = tcm.getColumnCount() - 1; i > 0; --i) {
            tcm.removeColumn(tcm.getColumn(i));
        }
        tcm.setColumnSorted((ETableColumn)tcm.getColumn(0), true, 1);
        recursiveDiffer.addPropertyChangeListener("filteredResult", pce -> this.updateResultFromDiffer());
        this.updateResultFromDiffer();
        this.updateDiff();
        recursiveDiffer.addPropertyChangeListener("scanning", pce -> this.updateScanningPane());
        this.updateScanningPane();
        this.setActivatedNodes(null);
    }

    public boolean canClose() {
        return true;
    }

    private void updateScanningPane() {
        if (this.recursiveDiffer.isScanning()) {
            ((CardLayout)this.getLayout()).show((Container)((Object)this), "scanningPanelWrapper");
        } else {
            ((CardLayout)this.getLayout()).show((Container)((Object)this), "diffPanelWrapper");
        }
    }

    private void updateDiff() {
        this.diffOutput.removeAll();
        if (!this.selectedTreeEntries.isEmpty()) {
            try {
                DiffController diff = DiffController.createEnhanced(FileStreamSource.create(this.selectedTreeEntries.get(0).getFile1(), this.selectedTreeEntries.get(0).getBasePath1()), FileStreamSource.create(this.selectedTreeEntries.get(0).getFile2(), this.selectedTreeEntries.get(0).getBasePath2()));
                this.diffOutput.add(diff.getJComponent());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void updateResultFromDiffer() {
        TreeEntry te = this.recursiveDiffer.getFilteredResult();
        if (te != null) {
            TreeEntry oldRoot = (TreeEntry)this.treeModel.getRoot();
            if (oldRoot != null) {
                this.unregisterModifiedChangeLister(oldRoot);
            }
            this.treeModel.setRoot(te);
            this.fileTree.setRenderDataProvider((RenderDataProvider)(this.recursiveDiffer.isFlatten() ? PATH_DATA_PROVIDER : FILENAME_DATA_PROVIDER));
            this.basepathValue.setText(te.getFile1() != null ? te.getFile1().getPath() : "-");
            this.targetpathValue.setText(te.getFile2() != null ? te.getFile2().getPath() : "-");
            this.outputPane.setDividerLocation(0.25);
            ArrayList<TreePath> queue = new ArrayList<TreePath>();
            queue.add(new TreePath(te));
            while (!queue.isEmpty()) {
                TreePath tp = (TreePath)queue.remove(0);
                this.fileTree.expandPath(tp);
                if (tp.getPathCount() >= 4) continue;
                TreeEntry lte = (TreeEntry)tp.getLastPathComponent();
                for (TreeEntry cte : lte.getChildren()) {
                    queue.add(tp.pathByAddingChild(cte));
                }
            }
            this.registerModifiedChangeLister(te);
        }
    }

    private void unregisterModifiedChangeLister(TreeEntry te) {
        ArrayList<TreeEntry> queue2 = new ArrayList<TreeEntry>();
        queue2.add(te);
        while (!queue2.isEmpty()) {
            TreeEntry wte = (TreeEntry)queue2.remove(0);
            wte.removePropertyChangeListener("modified", this.modifiedListener);
            for (TreeEntry cte : wte.getChildren()) {
                queue2.add(cte);
            }
        }
    }

    private void registerModifiedChangeLister(TreeEntry te) {
        ArrayList<TreeEntry> queue2 = new ArrayList<TreeEntry>();
        queue2.add(te);
        while (!queue2.isEmpty()) {
            TreeEntry wte = (TreeEntry)queue2.remove(0);
            wte.addPropertyChangeListener("modified", this.modifiedListener);
            for (TreeEntry cte : wte.getChildren()) {
                queue2.add(cte);
            }
        }
    }

    private void initComponents() {
        this.diffPanelWrapper = new JPanel();
        this.infoPanel = new JPanel();
        this.basepathLabel = new JLabel();
        this.basepathValue = new JLabel();
        this.targetpathLabel = new JLabel();
        this.targetpathValue = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.flattenResult = new JCheckBox();
        this.swapPathsButton = new JButton();
        this.refreshButton = new JButton();
        this.applyFilterButton = new JCheckBox();
        this.editFilterButton = new JButton();
        this.outputPane = new JSplitPane();
        this.fileTreeScrollPane = new JScrollPane();
        this.fileTree = new Outline();
        this.diffOutput = new JPanel();
        this.scanningPanelWrapper = new JPanel();
        this.scanningLabel = new JLabel();
        this.cancelButton = new JButton();
        this.setLayout(new CardLayout());
        this.diffPanelWrapper.setLayout(new BorderLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.basepathLabel.setFont(this.basepathLabel.getFont().deriveFont(this.basepathLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.basepathLabel, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.basepathLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.infoPanel.add((Component)this.basepathLabel, gridBagConstraints);
        this.basepathValue.setFont(this.basepathValue.getFont().deriveFont(this.basepathValue.getFont().getStyle() & 0xFFFFFFFE));
        Mnemonics.setLocalizedText((JLabel)this.basepathValue, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.basepathValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.infoPanel.add((Component)this.basepathValue, gridBagConstraints);
        this.targetpathLabel.setFont(this.targetpathLabel.getFont().deriveFont(this.targetpathLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.targetpathLabel, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.targetpathLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.infoPanel.add((Component)this.targetpathLabel, gridBagConstraints);
        this.targetpathValue.setFont(this.targetpathValue.getFont().deriveFont(this.targetpathValue.getFont().getStyle() & 0xFFFFFFFE));
        Mnemonics.setLocalizedText((JLabel)this.targetpathValue, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.targetpathValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.infoPanel.add((Component)this.targetpathValue, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.flattenResult, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.flattenResult.text"));
        this.flattenResult.setFocusable(false);
        this.flattenResult.setVerticalTextPosition(3);
        this.jToolBar1.add(this.flattenResult);
        Mnemonics.setLocalizedText((AbstractButton)this.swapPathsButton, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.swapPathsButton.text"));
        this.swapPathsButton.setFocusable(false);
        this.swapPathsButton.setHorizontalTextPosition(0);
        this.swapPathsButton.setVerticalTextPosition(3);
        this.swapPathsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDiffViewerTopComponent.this.swapPathsButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.swapPathsButton);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.refreshButton.text"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDiffViewerTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.refreshButton);
        Mnemonics.setLocalizedText((AbstractButton)this.applyFilterButton, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.applyFilterButton.text"));
        this.applyFilterButton.setFocusable(false);
        this.applyFilterButton.setHideActionText(true);
        this.applyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDiffViewerTopComponent.this.applyFilterButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.applyFilterButton);
        Mnemonics.setLocalizedText((AbstractButton)this.editFilterButton, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.editFilterButton.text"));
        this.editFilterButton.setFocusable(false);
        this.editFilterButton.setHorizontalTextPosition(0);
        this.editFilterButton.setVerticalTextPosition(3);
        this.editFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDiffViewerTopComponent.this.editFilterButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.editFilterButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.infoPanel.add((Component)this.jToolBar1, gridBagConstraints);
        this.diffPanelWrapper.add((Component)this.infoPanel, "North");
        this.outputPane.setOrientation(0);
        this.outputPane.setResizeWeight(0.5);
        this.fileTreeScrollPane.setViewportView((Component)this.fileTree);
        this.outputPane.setLeftComponent(this.fileTreeScrollPane);
        this.diffOutput.setLayout(new BorderLayout());
        this.outputPane.setRightComponent(this.diffOutput);
        this.diffPanelWrapper.add((Component)this.outputPane, "Center");
        this.add(this.diffPanelWrapper, "diffPanelWrapper");
        this.scanningPanelWrapper.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.scanningLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 20;
        this.scanningPanelWrapper.add((Component)this.scanningLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(TreeDiffViewerTopComponent.class, (String)"TreeDiffViewerTopComponent.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDiffViewerTopComponent.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 19;
        this.scanningPanelWrapper.add((Component)this.cancelButton, gridBagConstraints);
        this.add(this.scanningPanelWrapper, "scanningPanelWrapper");
    }

    private void swapPathsButtonActionPerformed(ActionEvent evt) {
        FileObject fo1 = this.recursiveDiffer.getDir1();
        FileObject fo2 = this.recursiveDiffer.getDir2();
        this.recursiveDiffer.setDir1(fo2);
        this.recursiveDiffer.setDir2(fo1);
        this.recursiveDiffer.startScan();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.recursiveDiffer.cancelScan();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.recursiveDiffer.startScan();
    }

    private void editFilterButtonActionPerformed(ActionEvent evt) {
        FilterPanel fp = new FilterPanel();
        fp.setPatterns(this.filterPatterns);
        JDialog dialog = new JDialog(WindowManager.getDefault().getMainWindow(), "Filter settings");
        dialog.setContentPane(fp);
        fp.addActionListener(ae -> {
            switch (ae.getActionCommand()) {
                case "ACCEPT": {
                    this.filterPatterns = fp.getPatterns();
                    if (fp.isUpdateGlobalList()) {
                        DiffModuleConfig.getDefault().setTreeExclusionList(this.filterPatterns);
                    }
                    this.updateDiffer();
                    break;
                }
            }
            dialog.setVisible(false);
        });
        dialog.setSize(800, 600);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    private void applyFilterButtonActionPerformed(ActionEvent evt) {
        this.updateDiffer();
    }

    private void updateDiffer() {
        List<Pattern> patterns;
        List<Pattern> existingList = this.recursiveDiffer.getExclusionPatterns();
        if (!Objects.equals(existingList, patterns = this.applyFilterButton.isSelected() && this.filterPatterns != null ? this.filterPatterns.stream().map(ep -> ep.asPattern()).toList() : Collections.emptyList())) {
            this.recursiveDiffer.setExclusionPatterns(patterns);
            this.recursiveDiffer.startScan();
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        TreeEntry oldRoot = (TreeEntry)this.treeModel.getRoot();
        if (oldRoot != null) {
            this.unregisterModifiedChangeLister(oldRoot);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

