/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cordova.project.ConfigUtils;
import org.netbeans.modules.cordova.project.MobileConfigurationImpl;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class MobileConfigurationsProvider
implements ProjectConfigurationProvider<MobileConfigurationImpl> {
    private Project p;
    private Map<String, MobileConfigurationImpl> configs;
    private FileObject configDir;
    private FileObject nbProjectDir;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final Logger LOGGER = Logger.getLogger(MobileConfigurationsProvider.class.getName());
    private FileChangeListener fclWeakNB;
    private FileChangeListener fclWeakConfig;
    private static final String PROP_CONFIG = "config";
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fe) {
            MobileConfigurationsProvider.this.update(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            MobileConfigurationsProvider.this.update(fe);
        }

        public void fileDeleted(FileEvent fe) {
            MobileConfigurationsProvider.this.update(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            MobileConfigurationsProvider.this.update((FileEvent)fe);
        }
    };

    private void update(FileEvent ev) {
        LOGGER.log(Level.FINEST, "Received {0}", ev);
        Set oldConfigs = this.configs != null ? this.configs.keySet() : Collections.emptySet();
        this.configDir = this.p.getProjectDirectory().getFileObject("nbproject/configs");
        if (this.configDir != null) {
            if (this.fclWeakConfig != null) {
                this.configDir.removeFileChangeListener(this.fclWeakConfig);
            }
            this.fclWeakConfig = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)this.configDir);
            this.configDir.addFileChangeListener(this.fclWeakConfig);
            LOGGER.log(Level.FINEST, "(Re-)added listener to {0}", this.configDir);
        } else {
            LOGGER.log(Level.FINEST, "No nbproject/configs exists");
        }
        this.calculateConfigs();
        Set<String> newConfigs = this.configs.keySet();
        if (!oldConfigs.equals(newConfigs)) {
            LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{oldConfigs, newConfigs});
            this.support.firePropertyChange("configurations", null, null);
        }
    }

    public MobileConfigurationsProvider(Project p) {
        this.p = p;
        this.nbProjectDir = p.getProjectDirectory().getFileObject("nbproject");
        if (this.nbProjectDir != null) {
            this.fclWeakNB = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)this.nbProjectDir);
            this.nbProjectDir.addFileChangeListener(this.fclWeakNB);
            LOGGER.log(Level.FINEST, "Added listener to {0}", this.nbProjectDir);
            this.configDir = this.nbProjectDir.getFileObject("configs");
            if (this.configDir != null) {
                this.fclWeakConfig = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)this.configDir);
                this.configDir.addFileChangeListener(this.fclWeakConfig);
                LOGGER.log(Level.FINEST, "Added listener to {0}", this.configDir);
            }
        }
    }

    private void calculateConfigs() {
        this.configs = new HashMap<String, MobileConfigurationImpl>();
        if (this.configDir != null) {
            for (FileObject kid : this.configDir.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                MobileConfigurationImpl conf = MobileConfigurationImpl.create(this.p, kid);
                this.configs.put(conf.getId(), conf);
            }
        }
        LOGGER.log(Level.FINEST, "Calculated configurations: {0}", this.configs);
    }

    public Collection<MobileConfigurationImpl> getConfigurations() {
        if (this.configs == null) {
            this.calculateConfigs();
        }
        ArrayList<MobileConfigurationImpl> l = new ArrayList<MobileConfigurationImpl>(this.configs.values());
        return l;
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.support.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.support.removePropertyChangeListener(lst);
    }

    public List<String> getNewConfigurationTypes() {
        return Arrays.asList("android", "ios");
    }

    public String createConfiguration(String configurationType, String configurationName) {
        EditableProperties props = new EditableProperties(true);
        props.put("type", configurationType);
        props.put("display.name", configurationName);
        try {
            FileObject conf = ConfigUtils.createConfigFile(this.p.getProjectDirectory(), configurationType, props);
            MobileConfigurationImpl cfg = MobileConfigurationImpl.create(this.p, conf);
            return cfg.getId();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public MobileConfigurationImpl getActiveConfiguration() {
        Preferences c;
        String config;
        if (this.configs == null) {
            this.calculateConfigs();
        }
        if ((config = (c = ProjectUtils.getPreferences((Project)this.p, MobileConfigurationsProvider.class, (boolean)false)).get(PROP_CONFIG, null)) != null && this.configs.containsKey(config)) {
            return this.configs.get(config);
        }
        return this.getDefaultConfiguration();
    }

    public void setActiveConfiguration(MobileConfigurationImpl c) throws IllegalArgumentException, IOException {
        if (this.configs == null) {
            this.calculateConfigs();
        }
        Preferences prefs = ProjectUtils.getPreferences((Project)this.p, MobileConfigurationsProvider.class, (boolean)false);
        prefs.put(PROP_CONFIG, c.getId());
    }

    private MobileConfigurationImpl getDefaultConfiguration() {
        if (this.configs.size() > 0) {
            return this.configs.values().iterator().next();
        }
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public void customize() {
    }

    public boolean configurationsAffectAction(String command) {
        return false;
    }
}

