/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.List;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class PHPDocTypeTag
extends PHPDocTag {
    private final List<PHPDocTypeNode> types;
    protected String documentation;

    public PHPDocTypeTag(int start, int end, AnnotationParsedLine kind, String value, List<PHPDocTypeNode> types) {
        super(start, end, kind, value);
        this.types = types;
        this.documentation = null;
    }

    public List<PHPDocTypeNode> getTypes() {
        return this.types;
    }

    @Override
    public String getDocumentation() {
        if (this.documentation == null && !this.types.isEmpty()) {
            int indexAfterType;
            String value;
            PHPDocTypeNode lastType = this.types.get(0);
            for (PHPDocTypeNode node : this.types) {
                if (lastType.getEndOffset() >= node.getEndOffset()) continue;
                lastType = node;
            }
            String[] split = CodeUtils.WHITE_SPACES_PATTERN.split(this.getValue().trim(), 2);
            if (split[0].contains(value = lastType.getValue())) {
                value = split[0];
            }
            this.documentation = (indexAfterType = this.getValue().indexOf(value) + value.length()) < 0 ? "" : this.getValue().substring(indexAfterType).trim();
        }
        return this.documentation;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

