/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ClassDeclaration
extends TypeDeclaration {
    private final Map<Modifier, Set<OffsetRange>> modifiers = new EnumMap<Modifier, Set<OffsetRange>>(Modifier.class);
    private Modifier modifier;
    private Expression superClass;

    private ClassDeclaration(int start, int end, Map<Modifier, Set<OffsetRange>> modifiers, Identifier className, Expression superClass, Expression[] interfaces, Block body, List<Attribute> attributes) {
        super(start, end, className, interfaces, body, attributes);
        this.modifiers.putAll(modifiers);
        this.superClass = superClass;
    }

    private ClassDeclaration(int start, int end, Map<Modifier, Set<OffsetRange>> modifiers, Identifier className, Expression superClass, List<Expression> interfaces, Block body, List<Attribute> attributes) {
        this(start, end, modifiers, className, superClass, interfaces == null ? null : interfaces.toArray(new Expression[0]), body, attributes);
    }

    public ClassDeclaration(int start, int end, Map<Modifier, Set<OffsetRange>> modifiers, Identifier className, Expression superClass, List<Expression> interfaces, Block body) {
        this(start, end, modifiers, className, superClass, interfaces, body, Collections.emptyList());
    }

    private ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, Expression[] interfaces, Block body, List<Attribute> attributes) {
        super(start, end, className, interfaces, body, attributes);
        this.modifier = modifier;
        this.superClass = superClass;
    }

    private ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, List<Expression> interfaces, Block body, List<Attribute> attributes) {
        this(start, end, modifier, className, superClass, interfaces == null ? null : interfaces.toArray(new Expression[0]), body, attributes);
    }

    public ClassDeclaration(int start, int end, Modifier modifier, Identifier className, Expression superClass, List<Expression> interfaces, Block body) {
        this(start, end, modifier, className, superClass, interfaces, body, Collections.emptyList());
    }

    public static ClassDeclaration create(ClassDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new ClassDeclaration(start, declaration.getEndOffset(), declaration.getModifiers(), declaration.getName(), declaration.getSuperClass(), declaration.getInterfaces(), declaration.getBody(), attributes);
    }

    public Modifier getModifier() {
        if (this.modifier != null) {
            return this.modifier;
        }
        assert (!this.modifiers.keySet().isEmpty());
        assert (false) : "Use getModifiers() instead";
        return this.modifiers.keySet().iterator().next();
    }

    public Map<Modifier, Set<OffsetRange>> getModifiers() {
        return Collections.unmodifiableMap(this.modifiers);
    }

    public Expression getSuperClass() {
        return this.superClass;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sbModifiers = new StringBuilder();
        for (Modifier mod : this.getModifiers().keySet()) {
            if (mod == Modifier.NONE) break;
            sbModifiers.append((Object)mod).append(" ");
        }
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getInterfaces()) {
            sb.append(expression).append(",");
        }
        return sbAttributes.toString() + sbModifiers + "class " + this.getName() + " extends " + this.getSuperClass() + " implements " + sb + this.getBody();
    }

    public static enum Modifier {
        NONE,
        ABSTRACT,
        FINAL,
        READONLY;


        public String toString() {
            if (this == NONE) {
                return "";
            }
            return this.name().toLowerCase();
        }
    }
}

