/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.Bundle;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.UnpackableArrayElement;

public class ClassConstantDeclarationInfo
extends ASTNodeInfo<Identifier> {
    private static final int ARRAY_CUT_LENGTH = 50;
    private static final String UNKNOWN_VALUE = "?";
    private final String value;
    private final ConstantDeclaration constantDeclaration;

    ClassConstantDeclarationInfo(Identifier node, String value, ConstantDeclaration constantDeclaration) {
        super(node);
        this.value = value;
        this.constantDeclaration = constantDeclaration;
    }

    public static List<? extends ClassConstantDeclarationInfo> create(ConstantDeclaration constantDeclaration) {
        ArrayList<ClassConstantDeclarationInfo> retval = new ArrayList<ClassConstantDeclarationInfo>();
        Iterator<Identifier> iteratorNames = constantDeclaration.getNames().iterator();
        Iterator<Expression> iteratorInitializers = constantDeclaration.getInitializers().iterator();
        while (iteratorNames.hasNext()) {
            Identifier name = iteratorNames.next();
            Expression initializer = iteratorInitializers.next();
            String value = ClassConstantDeclarationInfo.getConstantValue(initializer);
            retval.add(new ClassConstantDeclarationInfo(name, value, constantDeclaration));
        }
        return retval;
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.CLASS_CONSTANT;
    }

    @Override
    public String getName() {
        return ((Identifier)this.getOriginalNode()).getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        Identifier name = (Identifier)this.getOriginalNode();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public String getValue() {
        return this.value;
    }

    @CheckForNull
    public String getDeclaredType() {
        return VariousUtils.getDeclaredType(this.constantDeclaration.getConstType());
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(this.constantDeclaration.getModifier());
    }

    public ConstantDeclaration getConstantDeclaration() {
        return this.constantDeclaration;
    }

    @CheckForNull
    protected static String getConstantValue(Expression expr) {
        UnaryOperation up;
        if (expr instanceof Scalar) {
            return ((Scalar)expr).getStringValue();
        }
        if (expr instanceof UnaryOperation && (up = (UnaryOperation)expr).getOperator() == UnaryOperation.Operator.MINUS && up.getExpression() instanceof Scalar) {
            return "-" + ((Scalar)up.getExpression()).getStringValue();
        }
        if (expr instanceof ArrayCreation) {
            return ClassConstantDeclarationInfo.getConstantValue((ArrayCreation)expr);
        }
        return null;
    }

    private static String getConstantValue(ArrayCreation expr) {
        StringBuilder sb = new StringBuilder("[");
        Integer displayedElements = 0;
        List<ArrayElement> elements = expr.getElements();
        for (ArrayElement element : elements) {
            if (displayedElements > 0) {
                sb.append(", ");
            }
            sb.append(ClassConstantDeclarationInfo.getConstantValue(element));
            Integer n = displayedElements;
            displayedElements = displayedElements + 1;
            if (sb.length() <= 50) continue;
            break;
        }
        if (displayedElements < elements.size()) {
            sb.append(", ... (").append(Bundle.MoreElementsDesc(elements.size() - displayedElements)).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getConstantValue(ArrayElement element) {
        String convertedValue;
        if (element instanceof UnpackableArrayElement) {
            String innerContent = ClassConstantDeclarationInfo.getConstantValue(element.getValue());
            return innerContent != null ? "..." + innerContent : UNKNOWN_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        Expression key = element.getKey();
        if (key != null) {
            String convertedKey = ClassConstantDeclarationInfo.getConstantValue(key);
            sb.append(convertedKey != null ? convertedKey : UNKNOWN_VALUE);
            sb.append(" => ");
        }
        sb.append((convertedValue = ClassConstantDeclarationInfo.getConstantValue(element.getValue())) != null ? convertedValue : UNKNOWN_VALUE);
        return sb.toString();
    }
}

