/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;

public class Property {
    private final String name;
    private final int modifier;
    private boolean selected;
    private final String type;

    public Property(String name, int modifier, String type) {
        this.name = name;
        this.modifier = modifier;
        this.type = type;
        this.selected = false;
    }

    public Property(String name, int modifier) {
        this(name, modifier, "");
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getAccessor() {
        return this.isStatic() ? "self::" : "$$this->";
    }

    public String getFluentReturnAccessor() {
        return this.isStatic() ? "self" : "$$this";
    }

    private boolean isStatic() {
        return BodyDeclaration.Modifier.isStatic(this.getModifier());
    }

    public String getFunctionModifier() {
        return this.isStatic() ? "static" : "";
    }

    public String getName() {
        return this.name;
    }

    public String getAccessedName() {
        return this.isStatic() ? "$$" + this.name : this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeForTemplate() {
        return this.getType() + " ";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public PhpElementKind getKind() {
        return PhpElementKind.FIELD;
    }

    public String toString() {
        return "Property{name=" + this.name + ", modifier=" + this.modifier + ", selected=" + this.selected + ", type=" + this.type + "}";
    }
}

