/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.ejbcore.action.AbstractMethodGenerator;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;

public class FinderMethodGenerator
extends AbstractMethodGenerator {
    private FinderMethodGenerator(String ejbClass, FileObject ejbClassFileObject) {
        super(ejbClass, ejbClassFileObject);
    }

    public static FinderMethodGenerator create(String ejbClass, FileObject ejbClassFileObject) {
        return new FinderMethodGenerator(ejbClass, ejbClassFileObject);
    }

    public void generate(MethodModel methodModel, boolean generateLocal, boolean generateRemote, boolean isOneReturn, String ejbql) throws IOException {
        String persistenceType = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                Entity entity = (Entity)metadata.findByEjbClass(FinderMethodGenerator.this.ejbClass);
                return entity != null ? entity.getPersistenceType() : null;
            }
        });
        if ("Container".equals(persistenceType)) {
            this.generateCmp(methodModel, generateLocal, generateRemote, isOneReturn, ejbql);
        } else if ("Bean".equals(persistenceType)) {
            this.generateBmp(methodModel, generateLocal, generateRemote, isOneReturn, ejbql);
        }
    }

    private void generateCmp(MethodModel methodModel, boolean generateLocal, boolean generateRemote, boolean isOneReturn, String ejbql) throws IOException {
        FileObject fileObject;
        MethodModel methodModelCopy;
        ArrayList<String> exceptions;
        if (!methodModel.getName().startsWith("find")) {
            throw new IllegalArgumentException("The finder method name must have find as its prefix.");
        }
        Map<String, String> interfaces = this.getInterfaces();
        String local = interfaces.get("Local");
        String localHome = interfaces.get("LocalHome");
        String remote = interfaces.get("Remote");
        String remoteHome = interfaces.get("Home");
        if (generateLocal && local != null && localHome != null) {
            exceptions = new ArrayList<String>(methodModel.getExceptions());
            if (!methodModel.getExceptions().contains("javax.ejb.FinderException")) {
                exceptions.add("javax.ejb.FinderException");
            }
            methodModelCopy = MethodModel.create((String)methodModel.getName(), (String)(isOneReturn ? local : "java.util.Collection"), null, (List)methodModel.getParameters(), exceptions, Collections.emptySet());
            fileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, localHome);
            FinderMethodGenerator.addMethod(methodModelCopy, fileObject, localHome);
        }
        if (generateRemote && remote != null && remoteHome != null) {
            exceptions = new ArrayList(methodModel.getExceptions());
            if (!methodModel.getExceptions().contains("javax.ejb.FinderException")) {
                exceptions.add("javax.ejb.FinderException");
            }
            if (!methodModel.getExceptions().contains("java.rmi.RemoteException")) {
                exceptions.add("java.rmi.RemoteException");
            }
            methodModelCopy = MethodModel.create((String)methodModel.getName(), (String)(isOneReturn ? remote : "java.util.Collection"), null, (List)methodModel.getParameters(), exceptions, Collections.emptySet());
            fileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, remoteHome);
            FinderMethodGenerator.addMethod(methodModelCopy, fileObject, remoteHome);
        }
        this.addQueryToXml(methodModel, ejbql);
    }

    private void generateBmp(MethodModel methodModel, boolean generateLocal, boolean generateRemote, boolean isOneReturn, String ejbql) throws IOException {
        MethodModel methodModelCopy;
        ArrayList<String> exceptions;
        if (!methodModel.getName().startsWith("find")) {
            throw new IllegalArgumentException("The finder method name must have find as its prefix.");
        }
        Map<String, String> interfaces = this.getInterfaces();
        String local = interfaces.get("Local");
        String localHome = interfaces.get("LocalHome");
        String remote = interfaces.get("Remote");
        String remoteHome = interfaces.get("Home");
        if (generateLocal && local != null && localHome != null) {
            ArrayList<String> exceptions2 = new ArrayList<String>(methodModel.getExceptions());
            if (!methodModel.getExceptions().contains("javax.ejb.FinderException")) {
                exceptions2.add("javax.ejb.FinderException");
            }
            MethodModel methodModelCopy2 = MethodModel.create((String)methodModel.getName(), (String)(isOneReturn ? local : "java.util.Collection"), null, (List)methodModel.getParameters(), exceptions2, Collections.emptySet());
            FileObject fileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, localHome);
            FinderMethodGenerator.addMethod(methodModelCopy2, fileObject, localHome);
        }
        String primKeyClass = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                Entity entity = (Entity)metadata.findByEjbClass(FinderMethodGenerator.this.ejbClass);
                return entity != null ? entity.getPrimKeyClass() : null;
            }
        });
        if (generateRemote && remote != null && remoteHome != null) {
            exceptions = new ArrayList(methodModel.getExceptions());
            if (!methodModel.getExceptions().contains("javax.ejb.FinderException")) {
                exceptions.add("javax.ejb.FinderException");
            }
            if (!methodModel.getExceptions().contains("java.rmi.RemoteException")) {
                exceptions.add("java.rmi.RemoteException");
            }
            methodModelCopy = MethodModel.create((String)('c' + methodModel.getName().substring(4)), (String)(isOneReturn ? remote : "java.util.Collection"), null, (List)methodModel.getParameters(), exceptions, Collections.emptySet());
            FileObject fileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, remoteHome);
            FinderMethodGenerator.addMethod(methodModelCopy, fileObject, remoteHome);
            methodModelCopy = MethodModel.create((String)("ejbF" + methodModelCopy.getName().substring(1)), (String)(isOneReturn ? primKeyClass : "java.util.Collection"), (String)methodModelCopy.getBody(), (List)methodModelCopy.getParameters(), (List)methodModelCopy.getExceptions(), Collections.singleton(Modifier.PUBLIC));
            FinderMethodGenerator.addMethod(methodModelCopy, this.ejbClassFileObject, this.ejbClass);
        }
        exceptions = new ArrayList<String>(methodModel.getExceptions());
        if (!methodModel.getExceptions().contains("javax.ejb.FinderException")) {
            exceptions.add("javax.ejb.FinderException");
        }
        methodModelCopy = MethodModel.create((String)("ejbF" + methodModel.getName().substring(1)), (String)(isOneReturn ? primKeyClass : "java.util.Collection"), (String)"return null;", (List)methodModel.getParameters(), exceptions, Collections.singleton(Modifier.PUBLIC));
        FinderMethodGenerator.addMethod(methodModelCopy, this.ejbClassFileObject, this.ejbClass);
    }

    private void addQueryToXml(MethodModel methodModel, String ejbql) throws IOException {
        EjbJar ejbJar = DDProvider.getDefault().getDDRoot(this.ejbModule.getDeploymentDescriptor());
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        Entity entity = (Entity)enterpriseBeans.findBeanByName("Entity", "EjbClass", this.ejbClass);
        Query query = entity.newQuery();
        QueryMethod queryMethod = query.newQueryMethod();
        queryMethod.setMethodName(methodModel.getName());
        MethodParams methodParams = queryMethod.newMethodParams();
        for (MethodModel.Variable parameter : methodModel.getParameters()) {
            methodParams.addMethodParam(parameter.getType());
        }
        queryMethod.setMethodParams(methodParams);
        query.setQueryMethod(queryMethod);
        query.setEjbQl(ejbql);
        entity.addQuery(query);
        this.saveXml();
    }
}

