/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.twig.editor.TwigSyntax;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;

public class TwigIndenter
extends AbstractIndenter<TwigTopTokenId> {
    private static final Logger LOGGER = Logger.getLogger(TwigIndenter.class.getName());
    private Stack<TwigStackItem> stack = null;
    private int preservedLineIndentation = -1;
    private static final String SET_TAG = "set";
    private static final String TRANS_TAG = "trans";

    public TwigIndenter(Context context) {
        super(TwigTopTokenId.language(), context);
    }

    protected int getFormatStableStart(JoinedTokenSequence<TwigTopTokenId> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) throws BadLocationException {
        return 0;
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<TwigTopTokenId> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        Stack<TwigStackItem> blockStack = this.getStack();
        ArrayList<IndentCommand> iis = new ArrayList<IndentCommand>();
        this.getIndentFromState(iis, true, context.getLineStartOffset());
        JoinedTokenSequence ts = context.getJoinedTokenSequences();
        ts.move(context.getLineStartOffset());
        boolean isBlockMacro = false;
        boolean isElseMacro = false;
        boolean afterDelimiter = false;
        boolean nonControlMacro = false;
        int embeddingLevel = 0;
        String lastMacro = "";
        Token lastToken = null;
        while (!context.isBlankLine() && ts.moveNext() && (ts.isCurrentTokenSequenceVirtual() && ts.offset() < context.getLineEndOffset() || ts.offset() <= context.getLineEndOffset())) {
            Token token = ts.token();
            if (token == null) {
                lastToken = null;
                continue;
            }
            if (ts.embedded() != null) {
                if (embeddingLevel == 1 && afterDelimiter) {
                    if (token.id() == TwigTopTokenId.T_TWIG_BLOCK && context.isIndentThisLine()) {
                        String markupToken = this.getMarkupTokenName((Token<TwigTopTokenId>)token);
                        boolean bl = isBlockMacro = TwigSyntax.isBlockMacro(markupToken) && !TwigIndenter.isShortedBlockMacro((Token<TwigTopTokenId>)token);
                        if (isBlockMacro) {
                            lastMacro = markupToken;
                            isElseMacro = TwigSyntax.isElseMacro(markupToken);
                        }
                    } else {
                        isBlockMacro = false;
                        isElseMacro = false;
                    }
                } else if (token.text().toString().indexOf("\n") == -1) {
                    nonControlMacro = true;
                }
                lastToken = token;
                continue;
            }
            if (token.id() == TwigTopTokenId.T_TWIG_BLOCK_START) {
                if (lastToken != null && lastToken.id() == TwigTopTokenId.T_TWIG_BLOCK_END) {
                    nonControlMacro = true;
                }
                afterDelimiter = true;
                ++embeddingLevel;
                TwigStackItem state = new TwigStackItem(StackItemState.IN_RULE);
                blockStack.push(state);
            } else if (token.id() == TwigTopTokenId.T_TWIG_BLOCK_END) {
                afterDelimiter = false;
                if (this.isInState(blockStack, StackItemState.IN_RULE)) {
                    TwigStackItem item = blockStack.pop();
                    if (--embeddingLevel == 0) {
                        assert (item.state == StackItemState.IN_RULE);
                        if (isBlockMacro) {
                            if (!blockStack.isEmpty() && blockStack.peek().getMacro() != null && TwigSyntax.isRelatedMacro(lastMacro, blockStack.peek().getMacro())) {
                                if (isElseMacro) {
                                    String macro = blockStack.pop().getMacro();
                                    blockStack.push(new TwigStackItem(StackItemState.IN_BODY, macro));
                                } else {
                                    blockStack.pop();
                                }
                                if (!nonControlMacro) {
                                    iis.add(new IndentCommand(IndentCommand.Type.RETURN, this.preservedLineIndentation));
                                }
                                nonControlMacro = false;
                            } else {
                                blockStack.push(new TwigStackItem(StackItemState.IN_BODY, lastMacro));
                            }
                        }
                    }
                }
            } else if (this.isCommentToken((Token<TwigTopTokenId>)token)) {
                int start = context.getLineStartOffset();
                if (start < ts.offset()) {
                    start = ts.offset();
                }
                int commentEndOffset = ts.offset() + ts.token().text().toString().trim().length() - 1;
                int end = context.getLineEndOffset();
                if (end > commentEndOffset) {
                    end = commentEndOffset;
                }
                if (start <= end) {
                    if (start == ts.offset()) {
                        if (end < commentEndOffset) {
                            int lineStart = LineDocumentUtils.getLineStart((LineDocument)this.getDocument(), (int)ts.offset());
                            this.preservedLineIndentation = start - lineStart;
                        }
                    } else if (end == commentEndOffset) {
                        String text = this.getDocument().getText(start, end - start + 1).trim();
                        if (!text.startsWith("*/")) {
                            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                            ic.setFixedIndentSize(this.preservedLineIndentation);
                            iis.add(ic);
                        }
                        this.preservedLineIndentation = -1;
                    } else {
                        IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                        ic.setFixedIndentSize(this.preservedLineIndentation);
                        iis.add(ic);
                    }
                }
            }
            lastToken = token;
        }
        if (context.isBlankLine() && iis.isEmpty()) {
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (iis.isEmpty()) {
            iis.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset()));
        }
        if (context.getNextLineStartOffset() != -1) {
            this.getIndentFromState(preliminaryNextLineIndent, false, context.getNextLineStartOffset());
            if (preliminaryNextLineIndent.isEmpty()) {
                preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset()));
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            for (IndentCommand command : iis) {
                LOGGER.log(Level.FINE, command.toString());
            }
        }
        return iis;
    }

    private static boolean isShortedBlockMacro(Token<TwigTopTokenId> token) {
        String tokenText = token.text().toString();
        return tokenText.endsWith("/") || TwigIndenter.isSetBlock(tokenText) || TwigIndenter.isShortedTransBlock(tokenText);
    }

    private static boolean isSetBlock(String tokenText) {
        return tokenText.contains(SET_TAG) && tokenText.contains("=");
    }

    private static boolean isShortedTransBlock(String tokenText) {
        int indexOfTrans = tokenText.indexOf(TRANS_TAG);
        if (indexOfTrans != -1) {
            String prefix = tokenText.substring(0, indexOfTrans).trim();
            if (!prefix.isEmpty()) {
                return false;
            }
            String substring = tokenText.substring(indexOfTrans + TRANS_TAG.length()).trim();
            if (!substring.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private String getMarkupTokenName(Token<TwigTopTokenId> token) {
        TokenHierarchy th;
        String result = "";
        TokenSequence sequence = null;
        if (token.id() == TwigTopTokenId.T_TWIG_BLOCK) {
            th = TokenHierarchy.create((CharSequence)token.text(), TwigBlockTokenId.language());
            sequence = th.tokenSequence(TwigBlockTokenId.language());
        } else if (token.id() == TwigTopTokenId.T_TWIG_VAR) {
            th = TokenHierarchy.create((CharSequence)token.text(), TwigVariableTokenId.language());
            sequence = th.tokenSequence(TwigVariableTokenId.language());
        }
        if (sequence != null) {
            while (sequence.moveNext()) {
                if (sequence.token().id() == TwigBlockTokenId.T_TWIG_WHITESPACE || sequence.token().id() == TwigVariableTokenId.T_TWIG_WHITESPACE || this.isWhitespaceControlModifier((Token<? extends TokenId>)sequence.token())) continue;
                result = sequence.token().text().toString();
                break;
            }
        }
        return result;
    }

    private boolean isWhitespaceControlModifier(Token<? extends TokenId> token) {
        TokenId id = token.id();
        if (id == TwigBlockTokenId.T_TWIG_OPERATOR || id == TwigVariableTokenId.T_TWIG_OPERATOR) {
            return TwigLexerUtils.textEquals(token.text(), '-');
        }
        return false;
    }

    private boolean isCommentToken(Token<TwigTopTokenId> token) {
        return token.id() == TwigTopTokenId.T_TWIG_COMMENT;
    }

    private void getIndentFromState(List<IndentCommand> iis, boolean updateState, int lineStartOffset) {
        Stack<TwigStackItem> blockStack = this.getStack();
        int lastUnprocessedItem = blockStack.size();
        int i = blockStack.size() - 1;
        while (i >= 0 && !((TwigStackItem)blockStack.get(i)).processed.booleanValue()) {
            lastUnprocessedItem = i--;
        }
        for (i = lastUnprocessedItem; i < blockStack.size(); ++i) {
            IndentCommand ii;
            TwigStackItem item = (TwigStackItem)blockStack.get(i);
            assert (!item.processed.booleanValue()) : item;
            if (item.state == StackItemState.IN_BODY) {
                ii = new IndentCommand(IndentCommand.Type.INDENT, lineStartOffset);
                if (item.indent != -1) {
                    ii.setFixedIndentSize(item.indent);
                }
                iis.add(ii);
                if (!updateState) continue;
                item.processed = Boolean.TRUE;
                continue;
            }
            if (item.state != StackItemState.BODY_FINISHED) continue;
            ii = new IndentCommand(IndentCommand.Type.RETURN, lineStartOffset);
            iis.add(ii);
            if (!updateState) continue;
            item.processed = Boolean.TRUE;
            blockStack.remove(i);
            --i;
        }
    }

    private Stack<TwigStackItem> getStack() {
        return this.stack;
    }

    protected boolean isWhiteSpaceToken(Token<TwigTopTokenId> token) {
        return false;
    }

    protected void reset() {
        this.stack = new Stack();
        this.preservedLineIndentation = -1;
    }

    private boolean isInState(Stack<TwigStackItem> stack, StackItemState state) {
        for (TwigStackItem item : stack) {
            if (item.state != state) continue;
            return true;
        }
        return false;
    }

    private static final class TwigStackItem {
        private StackItemState state;
        private Boolean processed = false;
        private String macro;
        private int indent;

        private TwigStackItem(StackItemState state, String macro) {
            assert (state != StackItemState.IN_BODY || state == StackItemState.IN_BODY && !macro.isEmpty());
            this.macro = macro;
            this.state = state;
            this.indent = -1;
        }

        private TwigStackItem(StackItemState state) {
            this.state = state;
            this.indent = -1;
        }

        public String getMacro() {
            return this.macro;
        }

        public String toString() {
            return "TwigStackItem[state=" + (Object)((Object)this.state) + ",indent=" + this.indent + ",processed=" + this.processed + ",command=" + this.macro + "]";
        }
    }

    private static enum StackItemState {
        IN_BODY,
        IN_RULE,
        IN_VALUE,
        RULE_FINISHED,
        BODY_FINISHED;

    }
}

