/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ProjectParser {
    ProjectParser() {
    }

    public static String parse(File dotProject, Set<String> natures, List<Link> links, Set<Workspace.Variable> variables) throws IOException {
        List linkEls;
        Element linksEl;
        List natureEls;
        Document dotProjectXml;
        try {
            dotProjectXml = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)dotProject).toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(dotProject + ": " + e.toString()).initCause(e);
            throw ioe;
        }
        Element projectDescriptionEl = dotProjectXml.getDocumentElement();
        if (!"projectDescription".equals(projectDescriptionEl.getLocalName())) {
            throw new IllegalStateException("given file is not eclipse .project file");
        }
        Element naturesEl = XMLUtil.findElement((Element)projectDescriptionEl, (String)"natures", null);
        if (naturesEl != null && (natureEls = XMLUtil.findSubElements((Element)naturesEl)) != null) {
            for (Element nature : natureEls) {
                natures.add(nature.getTextContent());
            }
        }
        if ((linksEl = XMLUtil.findElement((Element)projectDescriptionEl, (String)"linkedResources", null)) != null && (linkEls = XMLUtil.findSubElements((Element)linksEl)) != null) {
            for (Element link : linkEls) {
                String loc;
                Element locationElement = XMLUtil.findElement((Element)link, (String)"location", null);
                if (locationElement == null) {
                    assert (XMLUtil.findElement((Element)link, (String)"locationURI", null) != null) : XMLUtil.findSubElements((Element)link);
                    loc = ProjectParser.resolveLink(XMLUtil.findElement((Element)link, (String)"locationURI", null).getTextContent(), variables);
                } else {
                    loc = locationElement.getTextContent();
                }
                links.add(new Link(XMLUtil.findElement((Element)link, (String)"name", null).getTextContent(), "1".equals(XMLUtil.findElement((Element)link, (String)"type", null).getTextContent()), loc));
            }
        }
        return XMLUtil.findElement((Element)projectDescriptionEl, (String)"name", null).getTextContent();
    }

    public static Facets readProjectFacets(File projectDir, Set<String> natures) throws IOException {
        Document doc;
        if (!natures.contains("org.eclipse.wst.common.project.facet.core.nature")) {
            return null;
        }
        File f = new File(projectDir, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        if (!f.exists()) {
            return null;
        }
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)f).toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(f + ": " + e.toString()).initCause(e);
            throw ioe;
        }
        Element root = doc.getDocumentElement();
        if (!"faceted-project".equals(root.getLocalName())) {
            return null;
        }
        ArrayList<Facets.Facet> facets = new ArrayList<Facets.Facet>();
        List elements = XMLUtil.findSubElements((Element)root);
        for (Element element : elements) {
            if (!"installed".equals(element.getNodeName())) continue;
            String facet = element.getAttribute("facet");
            String version = element.getAttribute("version");
            if (facet == null || version == null) continue;
            facets.add(new Facets.Facet(facet, version));
        }
        return new Facets(facets);
    }

    private static String resolveLink(String location, Set<Workspace.Variable> vars) {
        for (Workspace.Variable v : vars) {
            if (!location.startsWith(v.getName())) continue;
            return v.getLocation() + location.substring(v.getName().length());
        }
        return location;
    }
}

