/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hyperlink;

import java.awt.Toolkit;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageParser;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageUtilities;
import org.netbeans.modules.micronaut.hyperlink.Bundle;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautExpressionHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        AtomicReference ret = new AtomicReference();
        if (EditorDocumentUtils.getFileObject((Document)doc) != null) {
            doc.render(() -> {
                TokenSequence javaTS = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)offset);
                if (javaTS != null && javaTS.moveNext() && javaTS.token().id() == JavaTokenId.STRING_LITERAL) {
                    int off = offset - javaTS.offset();
                    Matcher matcher = MicronautExpressionLanguageParser.MEXP_PATTERN.matcher(javaTS.token().text());
                    while (matcher.find() && matcher.groupCount() == 1) {
                        String category;
                        List categories;
                        int d;
                        TokenHierarchy th;
                        TokenSequence ts;
                        if (off < matcher.start(1) || off > matcher.end(1) || (ts = (th = TokenHierarchy.create((CharSequence)matcher.group(1), (Language)Language.find((String)"text/x-micronaut-el"))) != null ? th.tokenSequence() : null) == null || !((d = ts.move(off - matcher.start(1))) == 0 ? ts.movePrevious() : ts.moveNext()) || (categories = (List)ts.token().getProperty((Object)"categories")) == null || categories.size() <= 1) continue;
                        switch (category = (String)categories.get(categories.size() - 1)) {
                            case "string.quoted.single.mexp": {
                                if (categories.size() <= 2 || !"meta.environment-access.argument.mexp".equals(categories.get(categories.size() - 2))) break;
                            }
                            case "entity.name.function.mexp": 
                            case "variable.other.object.property.mexp": 
                            case "storage.type.java": {
                                ret.set(new int[]{ts.offset() + matcher.start(1) + javaTS.offset(), ts.offset() + ts.token().length() + matcher.start(1) + javaTS.offset()});
                            }
                        }
                    }
                }
            });
        }
        return (int[])ret.get();
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> MicronautExpressionLanguageUtilities.resolve(doc, offset, (info, element) -> ElementOpen.open((ClasspathInfo)info.getClasspathInfo(), (Element)element), (property, source) -> {
            ElementHandle handle;
            ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
            ElementHandle elementHandle = handle = source != null ? MicronautConfigUtilities.getElementHandle(cpInfo, source.getType(), property.getName(), cancel) : null;
            if (handle == null || !ElementOpen.open((ClasspathInfo)cpInfo, (ElementHandle)handle)) {
                Toolkit.getDefaultToolkit().beep();
            }
            return null;
        }), (String)Bundle.LBL_GoToDeclaration(), (AtomicBoolean)cancel, (boolean)false);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return MicronautExpressionLanguageUtilities.resolve(doc, offset, (info, element) -> "<html><body>" + MicronautExpressionLanguageUtilities.getJavadocText(info, element, true, 1), (property, source) -> "<html><body>" + new MicronautConfigDocumentation((ConfigurationMetadataProperty)property).getText());
    }

    public static class LocationProvider
    implements HyperlinkLocationProvider {
        public CompletableFuture<HyperlinkLocation> getHyperlinkLocation(Document doc, int offset) {
            CompletableFuture future = MicronautExpressionLanguageUtilities.resolve(doc, offset, (info, element) -> {
                TypeElement typeElement = info.getElementUtilities().outermostTypeElement(element);
                if (typeElement != null) {
                    return ElementOpen.getLocation((ClasspathInfo)info.getClasspathInfo(), (ElementHandle)ElementHandle.create((Element)element), (String)(typeElement.getQualifiedName().toString().replace('.', '/') + ".class"));
                }
                return null;
            }, (property, source) -> {
                String typeName;
                ClasspathInfo cpInfo;
                ElementHandle handle;
                if (source != null && (handle = MicronautConfigUtilities.getElementHandle(cpInfo = ClasspathInfo.create((Document)doc), typeName = source.getType(), property.getName(), null)) != null) {
                    return ElementOpen.getLocation((ClasspathInfo)cpInfo, (ElementHandle)handle, (String)(typeName.replace('.', '/') + ".class"));
                }
                return null;
            });
            return future != null ? future.thenApply(location -> HyperlinkLocationProvider.createHyperlinkLocation((FileObject)location.getFileObject(), (int)location.getStartOffset(), (int)location.getEndOffset())) : CompletableFuture.completedFuture(null);
        }
    }
}

