/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.spi;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public interface CommentHandler {
    @NonNull
    public int[] getCommentBlocks(@NonNull Document var1, int var2, int var3);

    @NonNull
    public int[] getAdjustedBlocks(@NonNull Document var1, int var2, int var3);

    @NonNull
    public String getCommentStartDelimiter();

    @NonNull
    public String getCommentEndDelimiter();

    public static abstract class DefaultCommentHandler
    implements CommentHandler {
        @Override
        public int[] getAdjustedBlocks(@NonNull Document doc, int from, int to) {
            return new int[]{from, to};
        }

        @Override
        public int[] getCommentBlocks(final Document doc, final int from, final int to) {
            final ArrayList comments = new ArrayList();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    int nextCommentEnd;
                    int nextCommentStart;
                    int commentEndOffset;
                    CharSequence text = DocumentUtilities.getText((Document)doc);
                    int lastCommentStartIndex = CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)this.getCommentStartDelimiter(), (int)from);
                    int lastCommentEndIndex = from > 0 ? CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)this.getCommentEndDelimiter(), (int)(from - 1)) : -1;
                    int searchFrom = from;
                    if (lastCommentStartIndex > -1 && (lastCommentStartIndex > lastCommentEndIndex || lastCommentEndIndex == -1) && (commentEndOffset = this.getCommentEnd(text, lastCommentStartIndex)) > 0) {
                        comments.add(lastCommentStartIndex);
                        comments.add(commentEndOffset);
                        searchFrom = commentEndOffset;
                    }
                    while ((nextCommentStart = CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)this.getCommentStartDelimiter(), (int)searchFrom)) != -1 && nextCommentStart < to && (nextCommentEnd = this.getCommentEnd(text, nextCommentStart)) > 0) {
                        comments.add(nextCommentStart);
                        comments.add(nextCommentEnd);
                        searchFrom = nextCommentEnd;
                    }
                }
            };
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.as((Document)doc, AtomicLockDocument.class);
            if (ald != null) {
                ald.runAtomic(task);
            } else {
                task.run();
            }
            int[] arr = new int[comments.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Integer)comments.get(i);
            }
            return arr;
        }

        private int getCommentEnd(CharSequence text, int commentStartOffset) {
            int offset = CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)this.getCommentEndDelimiter(), (int)commentStartOffset);
            return offset == -1 ? -1 : offset + this.getCommentEndDelimiter().length();
        }
    }
}

