/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.StopPooledThreadException;

public class TaskThread
extends Thread {
    private static final Log log = LogFactory.getLog(TaskThread.class);
    private static final StringManager sm = StringManager.getManager(TaskThread.class);
    private final long creationTime = System.currentTimeMillis();

    public TaskThread(ThreadGroup group, Runnable target, String name) {
        super(group, new WrappingRunnable(target), name);
    }

    public TaskThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, new WrappingRunnable(target), name, stackSize);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private record WrappingRunnable(Runnable wrappedRunnable) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.wrappedRunnable.run();
            }
            catch (StopPooledThreadException exc) {
                log.debug((Object)sm.getString("taskThread.exiting"), (Throwable)exc);
            }
        }
    }
}

