# NOTE: Derived from blib/lib/NetAddr/IP.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package NetAddr::IP;

#line 667 "blib/lib/NetAddr/IP.pm (autosplit into blib/lib/auto/NetAddr/IP/splitref.al)"
sub splitref($;$) {
  my $net = $_[0]->network;
  my $mask = $_[1] || '';
  if ($mask) {
    return undef unless ($mask = NetAddr::IP->new($net->addr,$mask)->{mask});
  } else {
    $mask = Ones();
  }
  my $scidr = (notcontiguous($mask))[1];
  my $nnets = $scidr - (notcontiguous($net->{mask}))[1];
  return undef if $nnets < 0 || $nnets > 32;
  return [$net] if $nnets == 0;
  $nnets = 2 ** $nnets;			# number of nets
  my $nsize = (sub128(Zero,$mask))[1];
  my @ret = unpack('L3N',$nsize);
  return undef if $ret[0] || $ret[1] || $ret[2];
  $nsize = $ret[3];
  @ret = ();
  
  while ($nnets-- > 0) {
    push @ret, $net->_new($net->{addr},$mask);
    $net->{addr} = (addconst($net->{addr},$nsize))[1];
  }
  return \@ret;
}

# end of NetAddr::IP::splitref
1;
