require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_TYPES_H)) {
    eval 'sub __LINUX_SPINLOCK_TYPES_H () {1;}' unless defined(&__LINUX_SPINLOCK_TYPES_H);
    require 'linux/lockdep.ph';
    if(defined( &CONFIG_SMP)) {
	require 'asm/spinlock_types.ph';
    } else {
	require 'linux/spinlock_types_up.ph';
    }
    if(defined( &CONFIG_PREEMPT)  && defined( &CONFIG_SMP)) {
    }
    if(defined(&CONFIG_DEBUG_SPINLOCK)) {
    }
    if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
    }
    eval 'sub SPINLOCK_MAGIC () {0xdead4ead;}' unless defined(&SPINLOCK_MAGIC);
    if(defined( &CONFIG_PREEMPT)  && defined( &CONFIG_SMP)) {
    }
    if(defined(&CONFIG_DEBUG_SPINLOCK)) {
    }
    if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
    }
    eval 'sub RWLOCK_MAGIC () {0xdeaf1eed;}' unless defined(&RWLOCK_MAGIC);
    eval 'sub SPINLOCK_OWNER_INIT () {(( &void *)-1);}' unless defined(&SPINLOCK_OWNER_INIT);
    if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	eval 'sub SPIN_DEP_MAP_INIT {
	    my($lockname) = @_;
    	    eval q(. &dep_map = { . &name = $lockname });
	}' unless defined(&SPIN_DEP_MAP_INIT);
    } else {
	eval 'sub SPIN_DEP_MAP_INIT {
	    my($lockname) = @_;
    	    eval q();
	}' unless defined(&SPIN_DEP_MAP_INIT);
    }
    if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	eval 'sub RW_DEP_MAP_INIT {
	    my($lockname) = @_;
    	    eval q(. &dep_map = { . &name = $lockname });
	}' unless defined(&RW_DEP_MAP_INIT);
    } else {
	eval 'sub RW_DEP_MAP_INIT {
	    my($lockname) = @_;
    	    eval q();
	}' unless defined(&RW_DEP_MAP_INIT);
    }
    if(defined(&CONFIG_DEBUG_SPINLOCK)) {
	eval 'sub __SPIN_LOCK_UNLOCKED {
	    my($lockname) = @_;
    	    eval q(( &spinlock_t) { . &raw_lock =  &__RAW_SPIN_LOCK_UNLOCKED, . &magic =  &SPINLOCK_MAGIC, . &owner =  &SPINLOCK_OWNER_INIT, . &owner_cpu = -1,  &SPIN_DEP_MAP_INIT($lockname) });
	}' unless defined(&__SPIN_LOCK_UNLOCKED);
	eval 'sub __RW_LOCK_UNLOCKED {
	    my($lockname) = @_;
    	    eval q(( &rwlock_t) { . &raw_lock =  &__RAW_RW_LOCK_UNLOCKED, . &magic =  &RWLOCK_MAGIC, . &owner =  &SPINLOCK_OWNER_INIT, . &owner_cpu = -1,  &RW_DEP_MAP_INIT($lockname) });
	}' unless defined(&__RW_LOCK_UNLOCKED);
    } else {
	eval 'sub __SPIN_LOCK_UNLOCKED {
	    my($lockname) = @_;
    	    eval q(( &spinlock_t) { . &raw_lock =  &__RAW_SPIN_LOCK_UNLOCKED,  &SPIN_DEP_MAP_INIT($lockname) });
	}' unless defined(&__SPIN_LOCK_UNLOCKED);
	eval 'sub __RW_LOCK_UNLOCKED {
	    my($lockname) = @_;
    	    eval q(( &rwlock_t) { . &raw_lock =  &__RAW_RW_LOCK_UNLOCKED,  &RW_DEP_MAP_INIT($lockname) });
	}' unless defined(&__RW_LOCK_UNLOCKED);
    }
    eval 'sub SPIN_LOCK_UNLOCKED () { &__SPIN_LOCK_UNLOCKED( &old_style_spin_init);}' unless defined(&SPIN_LOCK_UNLOCKED);
    eval 'sub RW_LOCK_UNLOCKED () { &__RW_LOCK_UNLOCKED( &old_style_rw_init);}' unless defined(&RW_LOCK_UNLOCKED);
    eval 'sub DEFINE_SPINLOCK {
        my($x) = @_;
	    eval q( &spinlock_t $x =  &__SPIN_LOCK_UNLOCKED($x));
    }' unless defined(&DEFINE_SPINLOCK);
    eval 'sub DEFINE_RWLOCK {
        my($x) = @_;
	    eval q( &rwlock_t $x =  &__RW_LOCK_UNLOCKED($x));
    }' unless defined(&DEFINE_RWLOCK);
}
1;
