require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_RBTREE_H)) {
    eval 'sub _LINUX_RBTREE_H () {1;}' unless defined(&_LINUX_RBTREE_H);
    require 'linux/kernel.ph';
    require 'linux/stddef.ph';
    eval 'sub RB_RED () {0;}' unless defined(&RB_RED);
    eval 'sub RB_BLACK () {1;}' unless defined(&RB_BLACK);
    eval 'sub rb_parent {
        my($r) = @_;
	    eval q(((($r)-> &rb_parent_color & ~3)));
    }' unless defined(&rb_parent);
    eval 'sub rb_color {
        my($r) = @_;
	    eval q((($r)-> &rb_parent_color & 1));
    }' unless defined(&rb_color);
    eval 'sub rb_is_red {
        my($r) = @_;
	    eval q((! &rb_color($r)));
    }' unless defined(&rb_is_red);
    eval 'sub rb_is_black {
        my($r) = @_;
	    eval q( &rb_color($r));
    }' unless defined(&rb_is_black);
    eval 'sub rb_set_red {
        my($r) = @_;
	    eval q( &do { ($r)-> &rb_parent_color &= ~1; }  &while (0));
    }' unless defined(&rb_set_red);
    eval 'sub rb_set_black {
        my($r) = @_;
	    eval q( &do { ($r)-> &rb_parent_color |= 1; }  &while (0));
    }' unless defined(&rb_set_black);
    eval 'sub rb_set_parent {
        my($rb,$p) = @_;
	    eval q({  ($rb->{rb_parent_color}) = ( ($rb->{rb_parent_color}) & 3) | $p; });
    }' unless defined(&rb_set_parent);
    eval 'sub rb_set_color {
        my($rb,$color) = @_;
	    eval q({  ($rb->{rb_parent_color}) = ( ($rb->{rb_parent_color}) & ~1) | $color; });
    }' unless defined(&rb_set_color);
    eval 'sub RB_ROOT () { {  &NULL, };}' unless defined(&RB_ROOT);
    eval 'sub rb_entry {
        my($ptr, $type, $member) = @_;
	    eval q( &container_of($ptr, $type, $member));
    }' unless defined(&rb_entry);
    eval 'sub RB_EMPTY_ROOT {
        my($root) = @_;
	    eval q((($root)-> &rb_node ==  &NULL));
    }' unless defined(&RB_EMPTY_ROOT);
    eval 'sub RB_EMPTY_NODE {
        my($node) = @_;
	    eval q(( &rb_parent($node) != $node));
    }' unless defined(&RB_EMPTY_NODE);
    eval 'sub RB_CLEAR_NODE {
        my($node) = @_;
	    eval q(( &rb_set_parent($node, $node)));
    }' unless defined(&RB_CLEAR_NODE);
    eval 'sub rb_link_node {
        my($node,$parent,$rb_link) = @_;
	    eval q({  ($node->{rb_parent_color}) = $parent;  ($node->{rb_left}) =  ($node->{rb_right}) =  &NULL; *$rb_link = $node; });
    }' unless defined(&rb_link_node);
}
1;
