require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_THREAD_INFO_H)) {
    eval 'sub _ASM_THREAD_INFO_H () {1;}' unless defined(&_ASM_THREAD_INFO_H);
    if(defined(&__KERNEL__)) {
	require 'asm/page.ph';
	require 'asm/types.ph';
	require 'asm/pda.ph';
	unless(defined(&__ASSEMBLY__)) {
	    require 'asm/mmsegment.ph';
	}
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub INIT_THREAD_INFO {
	        my($tsk) = @_;
    		eval q({ . &task = $tsk, . &exec_domain =  &default_exec_domain, . &flags = 0, . &cpu = 0, . &preempt_count = 1, . &addr_limit =  &KERNEL_DS, . &restart_block = { . &fn =  &do_no_restart_syscall, }, });
	    }' unless defined(&INIT_THREAD_INFO);
	    eval 'sub init_thread_info () {( ($init_thread_union->{thread_info}));}' unless defined(&init_thread_info);
	    eval 'sub init_stack () {( ($init_thread_union->{stack}));}' unless defined(&init_stack);
	    eval 'sub thread_info {
	        eval q(* &current_thread_info( &void) { 1;  &ti = ( &void *)( &read_pda( &kernelstack) +  &PDA_STACKOFFSET -  &THREAD_SIZE);  &ti; });
	    }' unless defined(&thread_info);
	    if(defined(&CONFIG_DEBUG_STACK_USAGE)) {
		eval 'sub alloc_thread_info {
		    my($tsk) = @_;
    		    eval q(({ 1;  &ret = (  &__get_free_pages( &GFP_KERNEL, &THREAD_ORDER));  &if ( &ret)  &memset( &ret, 0,  &THREAD_SIZE);  &ret; }));
		}' unless defined(&alloc_thread_info);
	    } else {
		eval 'sub alloc_thread_info {
		    my($tsk) = @_;
    		    eval q((  &__get_free_pages( &GFP_KERNEL, &THREAD_ORDER)));
		}' unless defined(&alloc_thread_info);
	    }
	    eval 'sub free_thread_info {
	        my($ti) = @_;
    		eval q( &free_pages( ($ti),  &THREAD_ORDER));
	    }' unless defined(&free_thread_info);
	} else {
	    eval 'sub GET_THREAD_INFO {
	        my($reg) = @_;
    		eval q( &movq % &gs: &pda_kernelstack,$reg ;  &subq $( &THREAD_SIZE- &PDA_STACKOFFSET),$reg);
	    }' unless defined(&GET_THREAD_INFO);
	}
	eval 'sub TIF_SYSCALL_TRACE () {0;}' unless defined(&TIF_SYSCALL_TRACE);
	eval 'sub TIF_NOTIFY_RESUME () {1;}' unless defined(&TIF_NOTIFY_RESUME);
	eval 'sub TIF_SIGPENDING () {2;}' unless defined(&TIF_SIGPENDING);
	eval 'sub TIF_NEED_RESCHED () {3;}' unless defined(&TIF_NEED_RESCHED);
	eval 'sub TIF_SINGLESTEP () {4;}' unless defined(&TIF_SINGLESTEP);
	eval 'sub TIF_IRET () {5;}' unless defined(&TIF_IRET);
	eval 'sub TIF_SYSCALL_AUDIT () {7;}' unless defined(&TIF_SYSCALL_AUDIT);
	eval 'sub TIF_SECCOMP () {8;}' unless defined(&TIF_SECCOMP);
	eval 'sub TIF_IA32 () {17;}' unless defined(&TIF_IA32);
	eval 'sub TIF_FORK () {18;}' unless defined(&TIF_FORK);
	eval 'sub TIF_ABI_PENDING () {19;}' unless defined(&TIF_ABI_PENDING);
	eval 'sub TIF_MEMDIE () {20;}' unless defined(&TIF_MEMDIE);
	eval 'sub _TIF_SYSCALL_TRACE () {(1<< &TIF_SYSCALL_TRACE);}' unless defined(&_TIF_SYSCALL_TRACE);
	eval 'sub _TIF_NOTIFY_RESUME () {(1<< &TIF_NOTIFY_RESUME);}' unless defined(&_TIF_NOTIFY_RESUME);
	eval 'sub _TIF_SIGPENDING () {(1<< &TIF_SIGPENDING);}' unless defined(&_TIF_SIGPENDING);
	eval 'sub _TIF_SINGLESTEP () {(1<< &TIF_SINGLESTEP);}' unless defined(&_TIF_SINGLESTEP);
	eval 'sub _TIF_NEED_RESCHED () {(1<< &TIF_NEED_RESCHED);}' unless defined(&_TIF_NEED_RESCHED);
	eval 'sub _TIF_IRET () {(1<< &TIF_IRET);}' unless defined(&_TIF_IRET);
	eval 'sub _TIF_SYSCALL_AUDIT () {(1<< &TIF_SYSCALL_AUDIT);}' unless defined(&_TIF_SYSCALL_AUDIT);
	eval 'sub _TIF_SECCOMP () {(1<< &TIF_SECCOMP);}' unless defined(&_TIF_SECCOMP);
	eval 'sub _TIF_IA32 () {(1<< &TIF_IA32);}' unless defined(&_TIF_IA32);
	eval 'sub _TIF_FORK () {(1<< &TIF_FORK);}' unless defined(&_TIF_FORK);
	eval 'sub _TIF_ABI_PENDING () {(1<< &TIF_ABI_PENDING);}' unless defined(&_TIF_ABI_PENDING);
	eval 'sub _TIF_WORK_MASK () {(0xffff & ~( &_TIF_SYSCALL_TRACE| &_TIF_SYSCALL_AUDIT| &_TIF_SINGLESTEP| &_TIF_SECCOMP));}' unless defined(&_TIF_WORK_MASK);
	eval 'sub _TIF_ALLWORK_MASK () {(0xffff & ~ &_TIF_SECCOMP);}' unless defined(&_TIF_ALLWORK_MASK);
	eval 'sub PREEMPT_ACTIVE () {0x10000000;}' unless defined(&PREEMPT_ACTIVE);
	eval 'sub TS_USEDFPU () {0x1;}' unless defined(&TS_USEDFPU);
	eval 'sub TS_COMPAT () {0x2;}' unless defined(&TS_COMPAT);
	eval 'sub TS_POLLING () {0x4;}' unless defined(&TS_POLLING);
	eval 'sub tsk_is_polling {
	    my($t) = @_;
    	    eval q((($t)-> ($thread_info->{s$tatus}) &  &TS_POLLING));
	}' unless defined(&tsk_is_polling);
    }
}
1;
