require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_PGTABLE_H)) {
    eval 'sub _I386_PGTABLE_H () {1;}' unless defined(&_I386_PGTABLE_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'asm/processor.ph';
	require 'asm/fixmap.ph';
	require 'linux/threads.ph';
	unless(defined(&_I386_BITOPS_H)) {
	    require 'asm/bitops.ph';
	}
	require 'linux/slab.ph';
	require 'linux/list.ph';
	require 'linux/spinlock.ph';
	eval 'sub ZERO_PAGE {
	    my($vaddr) = @_;
    	    eval q(( &virt_to_page( &empty_zero_page)));
	}' unless defined(&ZERO_PAGE);
	if(defined(&CONFIG_X86_PAE)) {
	    require 'asm/pgtable-3level-defs.ph';
	    eval 'sub PMD_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&PMD_SIZE);
	    eval 'sub PMD_MASK () {(~( &PMD_SIZE-1));}' unless defined(&PMD_MASK);
	} else {
	    require 'asm/pgtable-2level-defs.ph';
	}
	eval 'sub PGDIR_SIZE () {(1 <<  &PGDIR_SHIFT);}' unless defined(&PGDIR_SIZE);
	eval 'sub PGDIR_MASK () {(~( &PGDIR_SIZE-1));}' unless defined(&PGDIR_MASK);
	eval 'sub USER_PTRS_PER_PGD () {( &TASK_SIZE/ &PGDIR_SIZE);}' unless defined(&USER_PTRS_PER_PGD);
	eval 'sub FIRST_USER_ADDRESS () {0;}' unless defined(&FIRST_USER_ADDRESS);
	eval 'sub USER_PGD_PTRS () {( &PAGE_OFFSET >>  &PGDIR_SHIFT);}' unless defined(&USER_PGD_PTRS);
	eval 'sub KERNEL_PGD_PTRS () {( &PTRS_PER_PGD- &USER_PGD_PTRS);}' unless defined(&KERNEL_PGD_PTRS);
	eval 'sub TWOLEVEL_PGDIR_SHIFT () {22;}' unless defined(&TWOLEVEL_PGDIR_SHIFT);
	eval 'sub BOOT_USER_PGD_PTRS () {( &__PAGE_OFFSET >>  &TWOLEVEL_PGDIR_SHIFT);}' unless defined(&BOOT_USER_PGD_PTRS);
	eval 'sub BOOT_KERNEL_PGD_PTRS () {(1024- &BOOT_USER_PGD_PTRS);}' unless defined(&BOOT_KERNEL_PGD_PTRS);
	eval 'sub VMALLOC_OFFSET () {(8*1024*1024);}' unless defined(&VMALLOC_OFFSET);
	eval 'sub VMALLOC_START () {((  &high_memory +  &vmalloc_earlyreserve + 2* &VMALLOC_OFFSET-1) & ~( &VMALLOC_OFFSET-1));}' unless defined(&VMALLOC_START);
	if(defined(&CONFIG_HIGHMEM)) {
	    eval 'sub VMALLOC_END () {( &PKMAP_BASE-2* &PAGE_SIZE);}' unless defined(&VMALLOC_END);
	} else {
	    eval 'sub VMALLOC_END () {( &FIXADDR_START-2* &PAGE_SIZE);}' unless defined(&VMALLOC_END);
	}
	eval 'sub _PAGE_BIT_PRESENT () {0;}' unless defined(&_PAGE_BIT_PRESENT);
	eval 'sub _PAGE_BIT_RW () {1;}' unless defined(&_PAGE_BIT_RW);
	eval 'sub _PAGE_BIT_USER () {2;}' unless defined(&_PAGE_BIT_USER);
	eval 'sub _PAGE_BIT_PWT () {3;}' unless defined(&_PAGE_BIT_PWT);
	eval 'sub _PAGE_BIT_PCD () {4;}' unless defined(&_PAGE_BIT_PCD);
	eval 'sub _PAGE_BIT_ACCESSED () {5;}' unless defined(&_PAGE_BIT_ACCESSED);
	eval 'sub _PAGE_BIT_DIRTY () {6;}' unless defined(&_PAGE_BIT_DIRTY);
	eval 'sub _PAGE_BIT_PSE () {7;}' unless defined(&_PAGE_BIT_PSE);
	eval 'sub _PAGE_BIT_GLOBAL () {8;}' unless defined(&_PAGE_BIT_GLOBAL);
	eval 'sub _PAGE_BIT_UNUSED1 () {9;}' unless defined(&_PAGE_BIT_UNUSED1);
	eval 'sub _PAGE_BIT_UNUSED2 () {10;}' unless defined(&_PAGE_BIT_UNUSED2);
	eval 'sub _PAGE_BIT_UNUSED3 () {11;}' unless defined(&_PAGE_BIT_UNUSED3);
	eval 'sub _PAGE_BIT_NX () {63;}' unless defined(&_PAGE_BIT_NX);
	eval 'sub _PAGE_PRESENT () {0x1;}' unless defined(&_PAGE_PRESENT);
	eval 'sub _PAGE_RW () {0x2;}' unless defined(&_PAGE_RW);
	eval 'sub _PAGE_USER () {0x4;}' unless defined(&_PAGE_USER);
	eval 'sub _PAGE_PWT () {0x8;}' unless defined(&_PAGE_PWT);
	eval 'sub _PAGE_PCD () {0x10;}' unless defined(&_PAGE_PCD);
	eval 'sub _PAGE_ACCESSED () {0x20;}' unless defined(&_PAGE_ACCESSED);
	eval 'sub _PAGE_DIRTY () {0x40;}' unless defined(&_PAGE_DIRTY);
	eval 'sub _PAGE_PSE () {0x80;}' unless defined(&_PAGE_PSE);
	eval 'sub _PAGE_GLOBAL () {0x100;}' unless defined(&_PAGE_GLOBAL);
	eval 'sub _PAGE_UNUSED1 () {0x200;}' unless defined(&_PAGE_UNUSED1);
	eval 'sub _PAGE_UNUSED2 () {0x400;}' unless defined(&_PAGE_UNUSED2);
	eval 'sub _PAGE_UNUSED3 () {0x800;}' unless defined(&_PAGE_UNUSED3);
	eval 'sub _PAGE_FILE () {0x40;}' unless defined(&_PAGE_FILE);
	eval 'sub _PAGE_PROTNONE () {0x80;}' unless defined(&_PAGE_PROTNONE);
	if(defined(&CONFIG_X86_PAE)) {
	    eval 'sub _PAGE_NX () {(1<< &_PAGE_BIT_NX);}' unless defined(&_PAGE_NX);
	} else {
	    eval 'sub _PAGE_NX () {0;}' unless defined(&_PAGE_NX);
	}
	eval 'sub _PAGE_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_TABLE);
	eval 'sub _KERNPG_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_KERNPG_TABLE);
	eval 'sub _PAGE_CHG_MASK () {( &PTE_MASK |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_CHG_MASK);
	eval 'sub PAGE_NONE () { &__pgprot( &_PAGE_PROTNONE |  &_PAGE_ACCESSED);}' unless defined(&PAGE_NONE);
	eval 'sub PAGE_SHARED () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_SHARED);
	eval 'sub PAGE_SHARED_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_SHARED_EXEC);
	eval 'sub PAGE_COPY_NOEXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&PAGE_COPY_NOEXEC);
	eval 'sub PAGE_COPY_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_COPY_EXEC);
	eval 'sub PAGE_COPY () { &PAGE_COPY_NOEXEC;}' unless defined(&PAGE_COPY);
	eval 'sub PAGE_READONLY () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&PAGE_READONLY);
	eval 'sub PAGE_READONLY_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_READONLY_EXEC);
	eval 'sub _PAGE_KERNEL () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&_PAGE_KERNEL);
	eval 'sub _PAGE_KERNEL_EXEC () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_ACCESSED);}' unless defined(&_PAGE_KERNEL_EXEC);
	eval 'sub __PAGE_KERNEL_RO () {( &__PAGE_KERNEL & ~ &_PAGE_RW);}' unless defined(&__PAGE_KERNEL_RO);
	eval 'sub __PAGE_KERNEL_NOCACHE () {( &__PAGE_KERNEL |  &_PAGE_PCD);}' unless defined(&__PAGE_KERNEL_NOCACHE);
	eval 'sub __PAGE_KERNEL_LARGE () {( &__PAGE_KERNEL |  &_PAGE_PSE);}' unless defined(&__PAGE_KERNEL_LARGE);
	eval 'sub __PAGE_KERNEL_LARGE_EXEC () {( &__PAGE_KERNEL_EXEC |  &_PAGE_PSE);}' unless defined(&__PAGE_KERNEL_LARGE_EXEC);
	eval 'sub PAGE_KERNEL () { &__pgprot( &__PAGE_KERNEL);}' unless defined(&PAGE_KERNEL);
	eval 'sub PAGE_KERNEL_RO () { &__pgprot( &__PAGE_KERNEL_RO);}' unless defined(&PAGE_KERNEL_RO);
	eval 'sub PAGE_KERNEL_EXEC () { &__pgprot( &__PAGE_KERNEL_EXEC);}' unless defined(&PAGE_KERNEL_EXEC);
	eval 'sub PAGE_KERNEL_NOCACHE () { &__pgprot( &__PAGE_KERNEL_NOCACHE);}' unless defined(&PAGE_KERNEL_NOCACHE);
	eval 'sub PAGE_KERNEL_LARGE () { &__pgprot( &__PAGE_KERNEL_LARGE);}' unless defined(&PAGE_KERNEL_LARGE);
	eval 'sub PAGE_KERNEL_LARGE_EXEC () { &__pgprot( &__PAGE_KERNEL_LARGE_EXEC);}' unless defined(&PAGE_KERNEL_LARGE_EXEC);
	eval 'sub __P000 () { &PAGE_NONE;}' unless defined(&__P000);
	eval 'sub __P001 () { &PAGE_READONLY;}' unless defined(&__P001);
	eval 'sub __P010 () { &PAGE_COPY;}' unless defined(&__P010);
	eval 'sub __P011 () { &PAGE_COPY;}' unless defined(&__P011);
	eval 'sub __P100 () { &PAGE_READONLY_EXEC;}' unless defined(&__P100);
	eval 'sub __P101 () { &PAGE_READONLY_EXEC;}' unless defined(&__P101);
	eval 'sub __P110 () { &PAGE_COPY_EXEC;}' unless defined(&__P110);
	eval 'sub __P111 () { &PAGE_COPY_EXEC;}' unless defined(&__P111);
	eval 'sub __S000 () { &PAGE_NONE;}' unless defined(&__S000);
	eval 'sub __S001 () { &PAGE_READONLY;}' unless defined(&__S001);
	eval 'sub __S010 () { &PAGE_SHARED;}' unless defined(&__S010);
	eval 'sub __S011 () { &PAGE_SHARED;}' unless defined(&__S011);
	eval 'sub __S100 () { &PAGE_READONLY_EXEC;}' unless defined(&__S100);
	eval 'sub __S101 () { &PAGE_READONLY_EXEC;}' unless defined(&__S101);
	eval 'sub __S110 () { &PAGE_SHARED_EXEC;}' unless defined(&__S110);
	eval 'sub __S111 () { &PAGE_SHARED_EXEC;}' unless defined(&__S111);
	undef(&TEST_ACCESS_OK) if defined(&TEST_ACCESS_OK);
	eval 'sub pte_present {
	    my($x) = @_;
    	    eval q((($x). &pte_low & ( &_PAGE_PRESENT |  &_PAGE_PROTNONE)));
	}' unless defined(&pte_present);
	eval 'sub pmd_none {
	    my($x) = @_;
    	    eval q((! &pmd_val($x)));
	}' unless defined(&pmd_none);
	eval 'sub pmd_present {
	    my($x) = @_;
    	    eval q(( &pmd_val($x) &  &_PAGE_PRESENT));
	}' unless defined(&pmd_present);
	eval 'sub pmd_bad {
	    my($x) = @_;
    	    eval q((( &pmd_val($x) & (~ &PAGE_MASK & ~ &_PAGE_USER)) !=  &_KERNPG_TABLE));
	}' unless defined(&pmd_bad);
	eval 'sub pages_to_mb {
	    my($x) = @_;
    	    eval q((($x) >> (20- &PAGE_SHIFT)));
	}' unless defined(&pages_to_mb);
	if(defined(&CONFIG_X86_PAE)) {
	    require 'asm/pgtable-3level.ph';
	} else {
	    require 'asm/pgtable-2level.ph';
	}
	eval 'sub ptep_test_and_clear_dirty {
	    my($vma,$addr,$ptep) = @_;
    	    eval q({  &if (! &pte_dirty(*$ptep)) 0;  &test_and_clear_bit( &_PAGE_BIT_DIRTY,  ($ptep->{pte_low})); });
	}' unless defined(&ptep_test_and_clear_dirty);
	eval 'sub ptep_test_and_clear_young {
	    my($vma,$addr,$ptep) = @_;
    	    eval q({  &if (! &pte_young(*$ptep)) 0;  &test_and_clear_bit( &_PAGE_BIT_ACCESSED,  ($ptep->{pte_low})); });
	}' unless defined(&ptep_test_and_clear_young);
	eval 'sub ptep_get_and_clear_full {
	    my($mm,$addr,$ptep,$full) = @_;
    	    eval q({  &pte_t  &pte;  &if ($full) {  &pte = *$ptep;  &pte_clear($mm, $addr, $ptep); }  &else {  &pte =  &ptep_get_and_clear($mm, $addr, $ptep); }  &pte; });
	}' unless defined(&ptep_get_and_clear_full);
	eval 'sub ptep_set_wrprotect {
	    my($mm,$addr,$ptep) = @_;
    	    eval q({  &clear_bit( &_PAGE_BIT_RW,  ($ptep->{pte_low})); });
	}' unless defined(&ptep_set_wrprotect);
	eval 'sub pgprot_noncached {
	    my($prot) = @_;
    	    eval q((( ($boot_cpu_data->{x86}) > 3) ? ( &__pgprot( &pgprot_val($prot) |  &_PAGE_PCD |  &_PAGE_PWT)) : ($prot)));
	}' unless defined(&pgprot_noncached);
	eval 'sub mk_pte {
	    my($page, $pgprot) = @_;
    	    eval q( &pfn_pte( &page_to_pfn($page), ($pgprot)));
	}' unless defined(&mk_pte);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub pte_modify {
	    my($pte,$newprot) = @_;
    	    eval q({  ($pte->{pte_low}) &=  &_PAGE_CHG_MASK;  ($pte->{pte_low}) |=  &pgprot_val($newprot); $pte; });
	}' unless defined(&pte_modify);
	eval 'sub pmd_large {
	    my($pmd) = @_;
    	    eval q((( &pmd_val($pmd) & ( &_PAGE_PSE| &_PAGE_PRESENT)) == ( &_PAGE_PSE| &_PAGE_PRESENT)));
	}' unless defined(&pmd_large);
	eval 'sub pgd_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PGDIR_SHIFT) & ( &PTRS_PER_PGD-1)));
	}' unless defined(&pgd_index);
	eval 'sub pgd_index_k {
	    my($addr) = @_;
    	    eval q( &pgd_index($addr));
	}' unless defined(&pgd_index_k);
	eval 'sub pgd_offset {
	    my($mm, $address) = @_;
    	    eval q((($mm)-> &pgd+ &pgd_index($address)));
	}' unless defined(&pgd_offset);
	eval 'sub pgd_offset_k {
	    my($address) = @_;
    	    eval q( &pgd_offset( &init_mm, $address));
	}' unless defined(&pgd_offset_k);
	eval 'sub pmd_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PMD_SHIFT) & ( &PTRS_PER_PMD-1)));
	}' unless defined(&pmd_index);
	eval 'sub pte_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PAGE_SHIFT) & ( &PTRS_PER_PTE - 1)));
	}' unless defined(&pte_index);
	eval 'sub pte_offset_kernel {
	    my($dir, $address) = @_;
    	    eval q((( &pte_t *)  &pmd_page_kernel(*($dir)) +  &pte_index($address)));
	}' unless defined(&pte_offset_kernel);
	eval 'sub pmd_page {
	    my($pmd) = @_;
    	    eval q(( &pfn_to_page( &pmd_val($pmd) >>  &PAGE_SHIFT)));
	}' unless defined(&pmd_page);
	eval 'sub pmd_page_kernel {
	    my($pmd) = @_;
    	    eval q((  &__va( &pmd_val($pmd) &  &PAGE_MASK)));
	}' unless defined(&pmd_page_kernel);
	if(defined(&CONFIG_X86_PAE)) {
	} else {
	}
	if(defined( &CONFIG_HIGHPTE)) {
	    eval 'sub pte_offset_map {
	        my($dir, $address) = @_;
    		eval q((( &pte_t *) &kmap_atomic( &pmd_page(*($dir)), &KM_PTE0) +  &pte_index($address)));
	    }' unless defined(&pte_offset_map);
	    eval 'sub pte_offset_map_nested {
	        my($dir, $address) = @_;
    		eval q((( &pte_t *) &kmap_atomic( &pmd_page(*($dir)), &KM_PTE1) +  &pte_index($address)));
	    }' unless defined(&pte_offset_map_nested);
	    eval 'sub pte_unmap {
	        my($pte) = @_;
    		eval q( &kunmap_atomic($pte,  &KM_PTE0));
	    }' unless defined(&pte_unmap);
	    eval 'sub pte_unmap_nested {
	        my($pte) = @_;
    		eval q( &kunmap_atomic($pte,  &KM_PTE1));
	    }' unless defined(&pte_unmap_nested);
	} else {
	    eval 'sub pte_offset_map {
	        my($dir, $address) = @_;
    		eval q((( &pte_t *) &page_address( &pmd_page(*($dir))) +  &pte_index($address)));
	    }' unless defined(&pte_offset_map);
	    eval 'sub pte_offset_map_nested {
	        my($dir, $address) = @_;
    		eval q( &pte_offset_map($dir, $address));
	    }' unless defined(&pte_offset_map_nested);
	    eval 'sub pte_unmap {
	        my($pte) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pte_unmap);
	    eval 'sub pte_unmap_nested {
	        my($pte) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pte_unmap_nested);
	}
	eval 'sub update_mmu_cache {
	    my($vma,$address,$pte) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&update_mmu_cache);
	eval 'sub __HAVE_ARCH_PTEP_SET_ACCESS_FLAGS () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_ACCESS_FLAGS);
	eval 'sub ptep_set_access_flags {
	    my($__vma, $__address, $__ptep, $__entry, $__dirty) = @_;
    	    eval q( &do {  &if ($__dirty) { ($__ptep)-> &pte_low = ($__entry). &pte_low;  &flush_tlb_page($__vma, $__address); } }  &while (0));
	}' unless defined(&ptep_set_access_flags);
    }
    if(defined(&CONFIG_FLATMEM)) {
	eval 'sub kern_addr_valid {
	    my($addr) = @_;
    	    eval q((1));
	}' unless defined(&kern_addr_valid);
    }
    eval 'sub io_remap_pfn_range {
        my($vma, $vaddr, $pfn, $size, $prot) = @_;
	    eval q( &remap_pfn_range($vma, $vaddr, $pfn, $size, $prot));
    }' unless defined(&io_remap_pfn_range);
    eval 'sub MK_IOSPACE_PFN {
        my($space, $pfn) = @_;
	    eval q(($pfn));
    }' unless defined(&MK_IOSPACE_PFN);
    eval 'sub GET_IOSPACE {
        my($pfn) = @_;
	    eval q(0);
    }' unless defined(&GET_IOSPACE);
    eval 'sub GET_PFN {
        my($pfn) = @_;
	    eval q(($pfn));
    }' unless defined(&GET_PFN);
    eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG);
    eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY);
    eval 'sub __HAVE_ARCH_PTEP_GET_AND_CLEAR () {1;}' unless defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR);
    eval 'sub __HAVE_ARCH_PTEP_GET_AND_CLEAR_FULL () {1;}' unless defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR_FULL);
    eval 'sub __HAVE_ARCH_PTEP_SET_WRPROTECT () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_WRPROTECT);
    eval 'sub __HAVE_ARCH_PTE_SAME () {1;}' unless defined(&__HAVE_ARCH_PTE_SAME);
    require 'asm-generic/pgtable.ph';
}
1;
