/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math;

import java.io.Serializable;
import java.util.Arrays;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.FieldElement;

public class GroupElement
implements Serializable {
    private static final long serialVersionUID = 2395879087349587L;
    final Curve curve;
    final Representation repr;
    final FieldElement X;
    final FieldElement Y;
    final FieldElement Z;
    final FieldElement T;
    GroupElement[][] precmp;
    GroupElement[] dblPrecmp;

    public static GroupElement p2(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, Representation.P2, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement p3(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.P3, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public static GroupElement p1p1(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.P1P1, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public static GroupElement precomp(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, Representation.PRECOMP, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement cached(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.CACHED, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public GroupElement(Curve curve, Representation representation, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        this.curve = curve;
        this.repr = representation;
        this.X = fieldElement;
        this.Y = fieldElement2;
        this.Z = fieldElement3;
        this.T = fieldElement4;
    }

    public GroupElement(Curve curve, byte[] byArray) {
        FieldElement fieldElement = curve.getField().fromByteArray(byArray);
        FieldElement fieldElement2 = fieldElement.square();
        FieldElement fieldElement3 = fieldElement2.subtractOne();
        FieldElement fieldElement4 = fieldElement2.multiply(curve.getD()).addOne();
        FieldElement fieldElement5 = fieldElement4.square().multiply(fieldElement4);
        FieldElement fieldElement6 = fieldElement5.square().multiply(fieldElement4).multiply(fieldElement3);
        fieldElement6 = fieldElement6.pow22523();
        fieldElement6 = fieldElement5.multiply(fieldElement3).multiply(fieldElement6);
        FieldElement fieldElement7 = fieldElement6.square().multiply(fieldElement4);
        FieldElement fieldElement8 = fieldElement7.subtract(fieldElement3);
        if (fieldElement8.isNonZero()) {
            fieldElement8 = fieldElement7.add(fieldElement3);
            if (fieldElement8.isNonZero()) {
                throw new IllegalArgumentException("not a valid GroupElement");
            }
            fieldElement6 = fieldElement6.multiply(curve.getI());
        }
        if ((fieldElement6.isNegative() ? 1 : 0) != Utils.bit(byArray, curve.getField().getb() - 1)) {
            fieldElement6 = fieldElement6.negate();
        }
        this.curve = curve;
        this.repr = Representation.P3;
        this.X = fieldElement6;
        this.Y = fieldElement;
        this.Z = curve.getField().ONE;
        this.T = this.X.multiply(this.Y);
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Representation getRepresentation() {
        return this.repr;
    }

    public FieldElement getX() {
        return this.X;
    }

    public FieldElement getY() {
        return this.Y;
    }

    public FieldElement getZ() {
        return this.Z;
    }

    public FieldElement getT() {
        return this.T;
    }

    public byte[] toByteArray() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.Z.invert();
                FieldElement fieldElement2 = this.X.multiply(fieldElement);
                FieldElement fieldElement3 = this.Y.multiply(fieldElement);
                byte[] byArray = fieldElement3.toByteArray();
                int n = byArray.length - 1;
                byArray[n] = (byte)(byArray[n] | (fieldElement2.isNegative() ? -128 : 0));
                return byArray;
            }
        }
        return this.toP2().toByteArray();
    }

    public GroupElement toP2() {
        return this.toRep(Representation.P2);
    }

    public GroupElement toP3() {
        return this.toRep(Representation.P3);
    }

    public GroupElement toCached() {
        return this.toRep(Representation.CACHED);
    }

    private GroupElement toRep(Representation representation) {
        switch (this.repr) {
            case P2: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(this.curve.get2D()));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1P1: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y));
                    }
                    case P1P1: {
                        return GroupElement.p1p1(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMP: {
                switch (representation) {
                    case PRECOMP: {
                        return GroupElement.precomp(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                switch (representation) {
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void precompute(boolean bl) {
        FieldElement fieldElement;
        Serializable serializable;
        int n;
        GroupElement groupElement;
        if (bl && this.precmp == null) {
            this.precmp = new GroupElement[32][8];
            groupElement = this;
            for (n = 0; n < 32; ++n) {
                int n2;
                serializable = groupElement;
                for (n2 = 0; n2 < 8; ++n2) {
                    fieldElement = ((GroupElement)serializable).Z.invert();
                    FieldElement fieldElement2 = ((GroupElement)serializable).X.multiply(fieldElement);
                    FieldElement fieldElement3 = ((GroupElement)serializable).Y.multiply(fieldElement);
                    this.precmp[n][n2] = GroupElement.precomp(this.curve, fieldElement3.add(fieldElement2), fieldElement3.subtract(fieldElement2), fieldElement2.multiply(fieldElement3).multiply(this.curve.get2D()));
                    serializable = ((GroupElement)serializable).add(groupElement.toCached()).toP3();
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    groupElement = groupElement.add(groupElement.toCached()).toP3();
                }
            }
        }
        if (this.dblPrecmp != null) {
            return;
        }
        this.dblPrecmp = new GroupElement[8];
        groupElement = this;
        for (n = 0; n < 8; ++n) {
            serializable = groupElement.Z.invert();
            FieldElement fieldElement4 = groupElement.X.multiply((FieldElement)serializable);
            fieldElement = groupElement.Y.multiply((FieldElement)serializable);
            this.dblPrecmp[n] = GroupElement.precomp(this.curve, fieldElement.add(fieldElement4), fieldElement.subtract(fieldElement4), fieldElement4.multiply(fieldElement).multiply(this.curve.get2D()));
            groupElement = this.add(this.add(groupElement.toCached()).toP3().toCached()).toP3();
        }
    }

    public GroupElement dbl() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.X.square();
                FieldElement fieldElement2 = this.Y.square();
                FieldElement fieldElement3 = this.Z.squareAndDouble();
                FieldElement fieldElement4 = this.X.add(this.Y);
                FieldElement fieldElement5 = fieldElement4.square();
                FieldElement fieldElement6 = fieldElement2.add(fieldElement);
                FieldElement fieldElement7 = fieldElement2.subtract(fieldElement);
                return GroupElement.p1p1(this.curve, fieldElement5.subtract(fieldElement6), fieldElement6, fieldElement7, fieldElement3.subtract(fieldElement7));
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement madd(GroupElement groupElement) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.X);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.Y);
        FieldElement fieldElement5 = groupElement.Z.multiply(this.T);
        FieldElement fieldElement6 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement6.add(fieldElement5), fieldElement6.subtract(fieldElement5));
    }

    private GroupElement msub(GroupElement groupElement) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.Y);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.X);
        FieldElement fieldElement5 = groupElement.Z.multiply(this.T);
        FieldElement fieldElement6 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement6.subtract(fieldElement5), fieldElement6.add(fieldElement5));
    }

    public GroupElement add(GroupElement groupElement) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.X);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.Y);
        FieldElement fieldElement5 = groupElement.T.multiply(this.T);
        FieldElement fieldElement6 = this.Z.multiply(groupElement.Z);
        FieldElement fieldElement7 = fieldElement6.add(fieldElement6);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement7.add(fieldElement5), fieldElement7.subtract(fieldElement5));
    }

    public GroupElement sub(GroupElement groupElement) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.Y);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.X);
        FieldElement fieldElement5 = groupElement.T.multiply(this.T);
        FieldElement fieldElement6 = this.Z.multiply(groupElement.Z);
        FieldElement fieldElement7 = fieldElement6.add(fieldElement6);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement7.subtract(fieldElement5), fieldElement7.add(fieldElement5));
    }

    public GroupElement negate() {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        return this.curve.getZero(Representation.P3).sub(this.toCached()).toP3();
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GroupElement)) {
            return false;
        }
        GroupElement groupElement = (GroupElement)object;
        if (!this.repr.equals((Object)groupElement.repr)) {
            try {
                groupElement = groupElement.toRep(this.repr);
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        switch (this.repr) {
            case P2: 
            case P3: {
                if (this.Z.equals(groupElement.Z)) {
                    return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y);
                }
                FieldElement fieldElement = this.X.multiply(groupElement.Z);
                FieldElement fieldElement2 = this.Y.multiply(groupElement.Z);
                FieldElement fieldElement3 = groupElement.X.multiply(this.Z);
                FieldElement fieldElement4 = groupElement.Y.multiply(this.Z);
                return fieldElement.equals(fieldElement3) && fieldElement2.equals(fieldElement4);
            }
            case P1P1: {
                return this.toP2().equals(groupElement);
            }
            case PRECOMP: {
                return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y) && this.Z.equals(groupElement.Z);
            }
            case CACHED: {
                if (this.Z.equals(groupElement.Z)) {
                    return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y) && this.T.equals(groupElement.T);
                }
                FieldElement fieldElement = this.X.multiply(groupElement.Z);
                FieldElement fieldElement5 = this.Y.multiply(groupElement.Z);
                FieldElement fieldElement6 = this.T.multiply(groupElement.Z);
                FieldElement fieldElement7 = groupElement.X.multiply(this.Z);
                FieldElement fieldElement8 = groupElement.Y.multiply(this.Z);
                FieldElement fieldElement9 = groupElement.T.multiply(this.Z);
                return fieldElement.equals(fieldElement7) && fieldElement5.equals(fieldElement8) && fieldElement6.equals(fieldElement9);
            }
        }
        return false;
    }

    static byte[] toRadix16(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[64];
        for (n = 0; n < 32; ++n) {
            byArray2[2 * n + 0] = (byte)(byArray[n] & 0xF);
            byArray2[2 * n + 1] = (byte)(byArray[n] >> 4 & 0xF);
        }
        int n2 = 0;
        n = 0;
        while (n < 63) {
            int n3 = n;
            byArray2[n3] = (byte)(byArray2[n3] + n2);
            n2 = byArray2[n] + 8;
            int n4 = n++;
            byArray2[n4] = (byte)(byArray2[n4] - ((n2 >>= 4) << 4));
        }
        byArray2[63] = (byte)(byArray2[63] + n2);
        return byArray2;
    }

    GroupElement cmov(GroupElement groupElement, int n) {
        return GroupElement.precomp(this.curve, this.X.cmov(groupElement.X, n), this.Y.cmov(groupElement.Y, n), this.Z.cmov(groupElement.Z, n));
    }

    GroupElement select(int n, int n2) {
        int n3 = Utils.negative(n2);
        int n4 = n2 - ((-n3 & n2) << 1);
        GroupElement groupElement = this.curve.getZero(Representation.PRECOMP).cmov(this.precmp[n][0], Utils.equal(n4, 1)).cmov(this.precmp[n][1], Utils.equal(n4, 2)).cmov(this.precmp[n][2], Utils.equal(n4, 3)).cmov(this.precmp[n][3], Utils.equal(n4, 4)).cmov(this.precmp[n][4], Utils.equal(n4, 5)).cmov(this.precmp[n][5], Utils.equal(n4, 6)).cmov(this.precmp[n][6], Utils.equal(n4, 7)).cmov(this.precmp[n][7], Utils.equal(n4, 8));
        GroupElement groupElement2 = GroupElement.precomp(this.curve, groupElement.Y, groupElement.X, groupElement.Z.negate());
        return groupElement.cmov(groupElement2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupElement scalarMultiply(byte[] byArray) {
        byte[] byArray2 = GroupElement.toRadix16(byArray);
        GroupElement groupElement = this.curve.getZero(Representation.P3);
        GroupElement groupElement2 = this;
        synchronized (groupElement2) {
            GroupElement groupElement3;
            int n;
            for (n = 1; n < 64; n += 2) {
                groupElement3 = this.select(n / 2, byArray2[n]);
                groupElement = groupElement.madd(groupElement3).toP3();
            }
            groupElement = groupElement.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
            for (n = 0; n < 64; n += 2) {
                groupElement3 = this.select(n / 2, byArray2[n]);
                groupElement = groupElement.madd(groupElement3).toP3();
            }
        }
        return groupElement;
    }

    static byte[] slide(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray2[n] = (byte)(1 & byArray[n >> 3] >> (n & 7));
        }
        block1: for (n = 0; n < 256; ++n) {
            if (byArray2[n] == 0) continue;
            block2: for (int i = 1; i <= 6 && n + i < 256; ++i) {
                if (byArray2[n + i] == 0) continue;
                if (byArray2[n] + (byArray2[n + i] << i) <= 15) {
                    int n2 = n;
                    byArray2[n2] = (byte)(byArray2[n2] + (byArray2[n + i] << i));
                    byArray2[n + i] = 0;
                    continue;
                }
                if (byArray2[n] - (byArray2[n + i] << i) < -15) continue block1;
                int n3 = n;
                byArray2[n3] = (byte)(byArray2[n3] - (byArray2[n + i] << i));
                for (int j = n + i; j < 256; ++j) {
                    if (byArray2[j] == 0) {
                        byArray2[j] = 1;
                        continue block2;
                    }
                    byArray2[j] = 0;
                }
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupElement doubleScalarMultiplyVariableTime(GroupElement groupElement, byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = GroupElement.slide(byArray);
        byte[] byArray4 = GroupElement.slide(byArray2);
        GroupElement groupElement2 = this.curve.getZero(Representation.P2);
        for (n = 255; n >= 0 && byArray3[n] == 0 && byArray4[n] == 0; --n) {
        }
        GroupElement groupElement3 = this;
        synchronized (groupElement3) {
            while (n >= 0) {
                GroupElement groupElement4 = groupElement2.dbl();
                if (byArray3[n] > 0) {
                    groupElement4 = groupElement4.toP3().madd(groupElement.dblPrecmp[byArray3[n] / 2]);
                } else if (byArray3[n] < 0) {
                    groupElement4 = groupElement4.toP3().msub(groupElement.dblPrecmp[-byArray3[n] / 2]);
                }
                if (byArray4[n] > 0) {
                    groupElement4 = groupElement4.toP3().madd(this.dblPrecmp[byArray4[n] / 2]);
                } else if (byArray4[n] < 0) {
                    groupElement4 = groupElement4.toP3().msub(this.dblPrecmp[-byArray4[n] / 2]);
                }
                groupElement2 = groupElement4.toP2();
                --n;
            }
        }
        return groupElement2;
    }

    public boolean isOnCurve() {
        return this.isOnCurve(this.curve);
    }

    public boolean isOnCurve(Curve curve) {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.Z.invert();
                FieldElement fieldElement2 = this.X.multiply(fieldElement);
                FieldElement fieldElement3 = this.Y.multiply(fieldElement);
                FieldElement fieldElement4 = fieldElement2.square();
                FieldElement fieldElement5 = fieldElement3.square();
                FieldElement fieldElement6 = curve.getD().multiply(fieldElement4).multiply(fieldElement5);
                return curve.getField().ONE.add(fieldElement6).add(fieldElement4).equals(fieldElement5);
            }
        }
        return this.toP2().isOnCurve(curve);
    }

    public String toString() {
        return "[GroupElement\nX=" + this.X + "\nY=" + this.Y + "\nZ=" + this.Z + "\nT=" + this.T + "\n]";
    }

    public static enum Representation {
        P2,
        P3,
        P1P1,
        PRECOMP,
        CACHED;

    }
}

