"""Generated message classes for biglake version delta_v1.

The BigLake API provides access to BigLake Metastore, a serverless, fully
managed, and highly available metastore for open-source data that can be used
for querying Delta Sharing catalogs in BigQuery.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'biglake'


class BiglakeDeltasharingV1ProjectsCatalogsCreateRequest(_messages.Message):
  r"""A BiglakeDeltasharingV1ProjectsCatalogsCreateRequest object.

  Fields:
    deltaSharingCatalog: A DeltaSharingCatalog resource to be passed as the
      request body.
    deltaSharingCatalogId: Required. The ID to use for the catalog, which will
      become the final component of the catalog's resource name.
    parent: Required. The parent resource where this catalog will be created.
      Format: projects/{project_id_or_number}
  """

  deltaSharingCatalog = _messages.MessageField('DeltaSharingCatalog', 1)
  deltaSharingCatalogId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeDeltasharingV1ProjectsCatalogsDeleteRequest(_messages.Message):
  r"""A BiglakeDeltasharingV1ProjectsCatalogsDeleteRequest object.

  Fields:
    name: Required. The name of the catalog to delete. Format:
      projects/{project}/catalogs/{catalog}
  """

  name = _messages.StringField(1, required=True)


class BiglakeDeltasharingV1ProjectsCatalogsGetRequest(_messages.Message):
  r"""A BiglakeDeltasharingV1ProjectsCatalogsGetRequest object.

  Fields:
    name: Required. The name of the catalog to retrieve. Format:
      projects/{project}/catalogs/{catalog}
  """

  name = _messages.StringField(1, required=True)


class BiglakeDeltasharingV1ProjectsCatalogsListRequest(_messages.Message):
  r"""A BiglakeDeltasharingV1ProjectsCatalogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of catalogs to return. The service
      may return fewer than this value. If unspecified, at most 50 catalogs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListDeltaSharingCatalogs` call. When paginating, all other parameters
      provided to `ListDeltaSharingCatalogs` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of catalogs.
      Format: projects/{project_id_or_number}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeDeltasharingV1ProjectsCatalogsPatchRequest(_messages.Message):
  r"""A BiglakeDeltasharingV1ProjectsCatalogsPatchRequest object.

  Fields:
    deltaSharingCatalog: A DeltaSharingCatalog resource to be passed as the
      request body.
    name: Identifier. The resource name. Format:
      projects/{project}/catalogs/{catalog}
    updateMask: Optional. The list of fields to update.
  """

  deltaSharingCatalog = _messages.MessageField('DeltaSharingCatalog', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DeltaSharingCatalog(_messages.Message):
  r"""Represents a DeltaSharing catalog.

  Fields:
    createTime: Output only. The creation time of the catalog.
    location: Required. The user-provided GCP location of the catalog.
    name: Identifier. The resource name. Format:
      projects/{project}/catalogs/{catalog}
    sapConfig: Config for a catalog that connects to SAP Business Data Cloud
      (BDC).
    serviceAccount: Output only. The service account used for SAP enrollment
      and is created as a side effect of creating the Delta Sharing catalog
      resource.
    updateTime: Output only. The last modification time of the catalog.
  """

  createTime = _messages.StringField(1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  sapConfig = _messages.MessageField('SapConfig', 4)
  serviceAccount = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ListDeltaSharingCatalogsResponse(_messages.Message):
  r"""Response message for the ListDeltaSharingCatalogs method.

  Fields:
    catalogs: The DeltaSharing catalogs from the specified project.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  catalogs = _messages.MessageField('DeltaSharingCatalog', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SapBdcEnrollmentConfig(_messages.Message):
  r"""Contains the enrollment configuration received from SAP.

  Fields:
    connectorEndpoint: Optional. The unique SAP BDC Connector Endpoint.
    invitationCode: Optional. An invitation code from SAP.
  """

  connectorEndpoint = _messages.StringField(1)
  invitationCode = _messages.StringField(2)


class SapConfig(_messages.Message):
  r"""Configuration for SAP Business Data Cloud (BDC).

  Fields:
    sapBdcEnrollmentConfig: Optional. To create a catalog resource that
      connects to SAP BDC, follow this 3 step process: 1. Set `SapConfig` to
      empty. This creates a catalog resource with a GCP Service Account:
      `service_account`. 2. On your SAP BDC instance, using this
      `service_account`, follow the enrollment process and create a BDC
      Connector. You will receive `connector_endpoint` and `invitation_code`
      from SAP. 3. With these additional fields provided by SAP, update the
      BigLake catalog resource created earlier with the
      `SapBdcEnrollmentConfig`. Once the `SapBdcEnrollmentConfig` is set, it
      is immutable.
  """

  sapBdcEnrollmentConfig = _messages.MessageField('SapBdcEnrollmentConfig', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
