/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;

public class TrustedTypesDirective
extends Directive {
    private static final Pattern TT_POLICY_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9\\-#=_/@.%]+$");
    private boolean none_ = false;
    private boolean allowDuplicates_ = false;
    private boolean star_ = false;
    private final List<String> policyNames_ = new ArrayList<String>();

    public TrustedTypesDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            String lowcaseToken;
            switch (lowcaseToken = token.toLowerCase(Locale.ROOT)) {
                case "'none'": {
                    if (!this.none_) {
                        this.none_ = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate keyword 'none'", index);
                    break;
                }
                case "'allow-duplicates'": {
                    if (!this.allowDuplicates_) {
                        this.allowDuplicates_ = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate keyword 'allow-duplicates'", index);
                    break;
                }
                case "*": {
                    if (!this.star_) {
                        this.star_ = true;
                        errors.add(Policy.Severity.Warning, "Wildcard policy names (*) permit any policy name, which may reduce security", index);
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate wildcard *", index);
                    break;
                }
                default: {
                    if (token.startsWith("'") && token.endsWith("'")) {
                        errors.add(Policy.Severity.Error, "Unrecognized trusted-types keyword " + token, index);
                        break;
                    }
                    if (TT_POLICY_NAME_PATTERN.matcher(token).matches()) {
                        if (this.policyNames_.contains(token)) {
                            errors.add(Policy.Severity.Warning, "Duplicate policy name " + token, index);
                            break;
                        }
                        this.policyNames_.add(token);
                        break;
                    }
                    errors.add(Policy.Severity.Error, "Invalid trusted-types policy name " + token, index);
                }
            }
            ++index;
        }
        if (values.isEmpty()) {
            errors.add(Policy.Severity.Warning, "Empty trusted-types directive allows all policy names (use '*' or 'none' to be explicit)", -1);
        }
        if (this.none_ && (this.star_ || this.allowDuplicates_ || !this.policyNames_.isEmpty())) {
            errors.add(Policy.Severity.Error, "'none' must not be combined with any other trusted-types expression", -1);
        }
        if (this.star_ && !this.policyNames_.isEmpty()) {
            errors.add(Policy.Severity.Warning, "Wildcard (*) permits any policy name, making specific policy names redundant", -1);
        }
        if (this.star_ && this.allowDuplicates_) {
            errors.add(Policy.Severity.Warning, "'allow-duplicates' is redundant when wildcard (*) is present", -1);
        }
        if (this.allowDuplicates_ && !this.star_ && this.policyNames_.isEmpty()) {
            errors.add(Policy.Severity.Warning, "'allow-duplicates' has no effect without policy names or wildcard", -1);
        }
    }

    public boolean none() {
        return this.none_;
    }

    public void setNone(boolean none) {
        if (this.none_ == none) {
            return;
        }
        if (none) {
            this.addValue("'none'");
        } else {
            this.removeValueIgnoreCase("'none'");
        }
        this.none_ = none;
    }

    public boolean allowDuplicates() {
        return this.allowDuplicates_;
    }

    public void setAllowDuplicates_(boolean allowDuplicates) {
        if (this.allowDuplicates_ == allowDuplicates) {
            return;
        }
        if (allowDuplicates) {
            this.addValue("'allow-duplicates'");
        } else {
            this.removeValueIgnoreCase("'allow-duplicates'");
        }
        this.allowDuplicates_ = allowDuplicates;
    }

    public boolean star() {
        return this.star_;
    }

    public boolean allowsWildcardPolicyNames() {
        return this.star_;
    }

    public void setStar_(boolean star) {
        if (this.star_ == star) {
            return;
        }
        if (star) {
            this.addValue("*");
        } else {
            this.removeValueIgnoreCase("*");
        }
        this.star_ = star;
    }

    public List<String> getPolicyNames_() {
        return Collections.unmodifiableList(this.policyNames_);
    }
}

