/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.roleattributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nu.validator.checker.InfoAwareErrorHandler;
import nu.validator.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RoleAttributeFilteringContentHandlerWrapper
implements ContentHandler {
    private final ContentHandler delegate;
    private final ErrorHandler errorHandler;
    private Locator locator = null;
    private static final Set<String> NON_ABSTRACT_ARIA_ROLES = new HashSet<String>(Arrays.asList("alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "doc-abstract", "doc-acknowledgments", "doc-afterword", "doc-appendix", "doc-backlink", "doc-biblioentry", "doc-bibliography", "doc-biblioref", "doc-chapter", "doc-colophon", "doc-conclusion", "doc-cover", "doc-credit", "doc-credits", "doc-dedication", "doc-endnote", "doc-endnotes", "doc-epigraph", "doc-epilogue", "doc-errata", "doc-example", "doc-footnote", "doc-foreword", "doc-glossary", "doc-glossref", "doc-index", "doc-introduction", "doc-noteref", "doc-notice", "doc-pagebreak", "doc-pagelist", "doc-part", "doc-preface", "doc-prologue", "doc-pullquote", "doc-qna", "doc-subtitle", "doc-tip", "doc-toc", "document", "feed", "figure", "form", "graphics-document", "graphics-object", "graphics-symbol", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"));

    public RoleAttributeFilteringContentHandlerWrapper(ContentHandler delegate, ErrorHandler errorHandler) {
        this.delegate = delegate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.delegate.characters(chars, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.delegate.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.delegate.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.delegate.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.delegate.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.delegate.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.delegate.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void startElement(String ns, String localName, String qName, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/1999/xhtml".equals(ns) || "http://www.w3.org/2000/svg".equals(ns)) {
            this.delegate.startElement(ns, localName, qName, this.filterAttributes(attributes));
        } else {
            this.delegate.startElement(ns, localName, qName, attributes);
        }
    }

    private Attributes filterAttributes(Attributes attributes) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if ("role".equals(attributes.getLocalName(i)) && "".equals(attributes.getURI(i))) {
                attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), this.getFirstMatchingAriaRoleFromTokenList(attributes.getValue(i).trim()));
                continue;
            }
            attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        return attributesImpl;
    }

    private String getFirstMatchingAriaRoleFromTokenList(String tokenList) throws SAXException {
        if ("".equals(tokenList)) {
            return "";
        }
        int len = tokenList.length();
        ArrayList<String> tokens = new ArrayList<String>();
        boolean collectingSpace = true;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            char c = tokenList.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                if (collectingSpace) continue;
                tokens.add(tokenList.substring(start, i));
                collectingSpace = true;
                continue;
            }
            if (!collectingSpace) continue;
            start = i;
            collectingSpace = false;
        }
        if (start < len) {
            tokens.add(tokenList.substring(start, len));
        }
        String roleValue = null;
        ArrayList<String> unrecognizedTokens = new ArrayList<String>();
        ArrayList<String> superfluousTokens = new ArrayList<String>();
        for (String token : tokens) {
            if (!NON_ABSTRACT_ARIA_ROLES.contains(token)) {
                unrecognizedTokens.add(token);
                continue;
            }
            if (roleValue == null) {
                roleValue = token;
                continue;
            }
            if ("presentation".equals(token)) continue;
            superfluousTokens.add(token);
        }
        if (this.errorHandler != null && roleValue != null && unrecognizedTokens.size() > 0) {
            this.errorHandler.error(new SAXParseException("Discarding unrecognized" + String.valueOf(this.renderTokenList(unrecognizedTokens)) + " from value of attribute \u201crole\u201d. Browsers ignore any token that is not a defined ARIA non-abstract role.", this.locator));
        }
        if (this.errorHandler instanceof InfoAwareErrorHandler && roleValue != null && superfluousTokens.size() > 0) {
            ((InfoAwareErrorHandler)this.errorHandler).info(new SAXParseException("Discarding superfluous" + String.valueOf(this.renderTokenList(superfluousTokens)) + " from value of attribute \u201crole\u201d. Browsers only process the first token found that is a defined ARIA non-abstract role.", this.locator));
        }
        return roleValue != null ? roleValue : tokenList;
    }

    private CharSequence renderTokenList(List<String> tokens) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        if (tokens.size() > 1) {
            sb.append(" tokens ");
        } else {
            sb.append(" token ");
        }
        for (String token : tokens) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("\u201c");
            sb.append(token);
            sb.append('\u201d');
        }
        return sb;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.delegate.startPrefixMapping(prefix, uri);
    }
}

