/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.nrl;

import java.util.Enumeration;
import java.util.Hashtable;
import nu.validator.vendor.thaiopensource.validate.nrl.ActionSet;
import nu.validator.vendor.thaiopensource.validate.nrl.AttributeActionSet;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

class Mode {
    static final String ANY_NAMESPACE = "##any";
    static final int ATTRIBUTE_PROCESSING_NONE = 0;
    static final int ATTRIBUTE_PROCESSING_QUALIFIED = 1;
    static final int ATTRIBUTE_PROCESSING_FULL = 2;
    static final Mode CURRENT = new Mode("#current", null);
    private final String name;
    private Mode baseMode;
    private boolean defined;
    private Locator whereDefined;
    private Locator whereUsed;
    private final Hashtable elementMap = new Hashtable();
    private final Hashtable attributeMap = new Hashtable();
    private int attributeProcessing = -1;

    Mode(String string, Mode mode) {
        this.name = string;
        this.baseMode = mode;
    }

    String getName() {
        return this.name;
    }

    Mode getBaseMode() {
        return this.baseMode;
    }

    void setBaseMode(Mode mode) {
        this.baseMode = mode;
    }

    ActionSet getElementActions(String string) {
        ActionSet actionSet = this.getElementActionsExplicit(string);
        if (actionSet == null) {
            actionSet = this.getElementActionsExplicit(ANY_NAMESPACE);
        }
        return actionSet;
    }

    private ActionSet getElementActionsExplicit(String string) {
        ActionSet actionSet = (ActionSet)this.elementMap.get(string);
        if (actionSet == null && this.baseMode != null && (actionSet = this.baseMode.getElementActionsExplicit(string)) != null) {
            actionSet = actionSet.changeCurrentMode(this);
            this.elementMap.put(string, actionSet);
        }
        return actionSet;
    }

    AttributeActionSet getAttributeActions(String string) {
        AttributeActionSet attributeActionSet = this.getAttributeActionsExplicit(string);
        if (attributeActionSet == null) {
            attributeActionSet = this.getAttributeActionsExplicit(ANY_NAMESPACE);
        }
        return attributeActionSet;
    }

    private AttributeActionSet getAttributeActionsExplicit(String string) {
        AttributeActionSet attributeActionSet = (AttributeActionSet)this.attributeMap.get(string);
        if (attributeActionSet == null && this.baseMode != null && (attributeActionSet = this.baseMode.getAttributeActionsExplicit(string)) != null) {
            this.attributeMap.put(string, attributeActionSet);
        }
        return attributeActionSet;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.baseMode != null ? this.baseMode.getAttributeProcessing() : 0;
            Enumeration enumeration = this.attributeMap.keys();
            while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                String string = (String)enumeration.nextElement();
                AttributeActionSet attributeActionSet = (AttributeActionSet)this.attributeMap.get(string);
                if (attributeActionSet.getAttach() && !attributeActionSet.getReject() && attributeActionSet.getSchemas().length <= 0) continue;
                this.attributeProcessing = string.equals("") || string.equals(ANY_NAMESPACE) ? 2 : 1;
            }
        }
        return this.attributeProcessing;
    }

    Locator getWhereDefined() {
        return this.whereDefined;
    }

    boolean isDefined() {
        return this.defined;
    }

    Locator getWhereUsed() {
        return this.whereUsed;
    }

    void noteUsed(Locator locator) {
        if (this.whereUsed == null && locator != null) {
            this.whereUsed = new LocatorImpl(locator);
        }
    }

    void noteDefined(Locator locator) {
        this.defined = true;
        if (this.whereDefined == null && locator != null) {
            this.whereDefined = new LocatorImpl(locator);
        }
    }

    boolean bindElement(String string, ActionSet actionSet) {
        if (this.elementMap.get(string) != null) {
            return false;
        }
        this.elementMap.put(string, actionSet);
        return true;
    }

    boolean bindAttribute(String string, AttributeActionSet attributeActionSet) {
        if (this.attributeMap.get(string) != null) {
            return false;
        }
        this.attributeMap.put(string, attributeActionSet);
        return true;
    }
}

