/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.mns;

import java.io.IOException;
import java.net.URL;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.SchemaReader;
import nu.validator.vendor.thaiopensource.validate.auto.AutoSchemaReader;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiver;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiverFactory;
import nu.validator.vendor.thaiopensource.validate.mns.SchemaImpl;
import nu.validator.vendor.thaiopensource.validate.mns.ValidatorImpl;
import nu.validator.vendor.thaiopensource.validate.prop.wrap.WrapProperty;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import nu.validator.vendor.thaiopensource.validate.rng.SAXSchemaReader;
import nu.validator.vendor.thaiopensource.xml.util.Name;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String MNS_SCHEMA = "mns.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final PropertyMap attributeSchemaProperties;
    private final boolean attributesSchema;
    private final SchemaReader autoSchemaLanguage;
    private Schema mnsSchema = null;

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        Name name = WrapProperty.ATTRIBUTE_OWNER.get(propertyMap);
        this.attributesSchema = name != null;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
        if (ValidatorImpl.OWNER_NAME.equals(name)) {
            this.attributeSchemaProperties = propertyMap;
            propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, null);
            this.properties = propertyMapBuilder.toPropertyMap();
        } else {
            if (name == null) {
                this.properties = propertyMap;
            } else {
                propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, null);
                this.properties = propertyMapBuilder.toPropertyMap();
            }
            WrapProperty.ATTRIBUTE_OWNER.put(propertyMapBuilder, ValidatorImpl.OWNER_NAME);
            this.attributeSchemaProperties = propertyMapBuilder.toPropertyMap();
        }
        this.autoSchemaLanguage = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(propertyMap));
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) {
        return new SchemaImpl(this.attributesSchema).installHandlers(xMLReader, this);
    }

    Schema getMnsSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.mnsSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + MNS_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string2);
            this.mnsSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(uRL.toString()), this.properties);
        }
        return this.mnsSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(InputSource inputSource, String string, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string) ? CompactSchemaReader.getInstance() : this.autoSchemaLanguage;
        return schemaReader.createSchema(inputSource, bl ? this.attributeSchemaProperties : this.properties);
    }

    private static boolean isRnc(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        return string.equals(RNC_MEDIA_TYPE);
    }
}

