/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.jarv;

import nu.validator.vendor.iso_relax.verifier.Verifier;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.Validator;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VerifierValidator
implements Validator {
    private final Verifier verifier;
    private ContentHandler handler;

    public VerifierValidator(Verifier verifier, PropertyMap propertyMap) {
        this.verifier = verifier;
        verifier.setErrorHandler(ValidateProperty.ERROR_HANDLER.get(propertyMap));
        EntityResolver entityResolver = ValidateProperty.ENTITY_RESOLVER.get(propertyMap);
        if (entityResolver != null) {
            verifier.setEntityResolver(entityResolver);
        }
        try {
            this.handler = verifier.getVerifierHandler();
        }
        catch (SAXException sAXException) {
            this.handler = new ExceptionReportHandler(sAXException);
        }
    }

    @Override
    public void reset() {
        try {
            this.handler = this.verifier.getVerifierHandler();
        }
        catch (SAXException sAXException) {
            this.handler = new ExceptionReportHandler(sAXException);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    private static class ExceptionReportHandler
    extends DefaultHandler {
        private final SAXException storedException;

        ExceptionReportHandler(SAXException sAXException) {
            this.storedException = sAXException;
        }

        @Override
        public void startDocument() throws SAXException {
            throw this.storedException;
        }
    }
}

