/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.jarv;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import nu.validator.vendor.iso_relax.verifier.VerifierConfigurationException;
import nu.validator.vendor.iso_relax.verifier.VerifierFactory;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.AbstractSchema;
import nu.validator.vendor.thaiopensource.validate.AbstractSchemaReader;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Option;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.validate.jarv.JarvConfigurationException;
import nu.validator.vendor.thaiopensource.validate.jarv.VerifierValidator;
import org.xml.sax.SAXException;

public class VerifierFactorySchemaReader
extends AbstractSchemaReader {
    private final VerifierFactory vf;

    public VerifierFactorySchemaReader(VerifierFactory verifierFactory) {
        this.vf = verifierFactory;
    }

    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        try {
            return new SchemaImpl(this.vf.compileSchema(sAXSource.getInputSource()));
        }
        catch (SAXException sAXException) {
            System.err.println("compileSchema threw a SAXException class " + sAXException.getClass().toString());
            if (sAXException.getException() != null) {
                System.err.println("cause has class " + sAXException.getException().getClass().toString());
            }
            throw sAXException;
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            String string;
            Exception exception;
            while (true) {
                VerifierConfigurationException verifierConfigurationException2;
                exception = verifierConfigurationException2.getCauseException();
                string = verifierConfigurationException2.getMessage();
                if (exception != null && string != null && string.equals(exception.getMessage())) {
                    string = null;
                }
                if (string != null) break;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof SAXException) {
                    throw (SAXException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof VerifierConfigurationException)) break;
                verifierConfigurationException2 = (VerifierConfigurationException)exception;
            }
            throw new SAXException(string, exception);
        }
    }

    @Override
    public Option getOption(String string) {
        return null;
    }

    private static class SchemaImpl
    extends AbstractSchema {
        final nu.validator.vendor.iso_relax.verifier.Schema schema;

        private SchemaImpl(nu.validator.vendor.iso_relax.verifier.Schema schema) {
            this.schema = schema;
        }

        @Override
        public Validator createValidator(PropertyMap propertyMap) {
            try {
                return new VerifierValidator(this.schema.newVerifier(), propertyMap);
            }
            catch (VerifierConfigurationException verifierConfigurationException) {
                Exception exception = verifierConfigurationException.getCauseException();
                if (exception instanceof RuntimeException && (verifierConfigurationException.getMessage() == null || verifierConfigurationException.getMessage().equals(exception.getMessage()))) {
                    throw (RuntimeException)exception;
                }
                throw new JarvConfigurationException(verifierConfigurationException);
            }
        }
    }
}

