/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.io.IOException;
import nu.validator.vendor.relaxng.datatype.DatatypeLibraryFactory;
import nu.validator.vendor.thaiopensource.datatype.DatatypeLibraryLoader;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternFuture;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaReaderImpl;
import nu.validator.vendor.thaiopensource.relaxng.parse.BuildException;
import nu.validator.vendor.thaiopensource.relaxng.parse.IllegalSchemaException;
import nu.validator.vendor.thaiopensource.relaxng.parse.ParseReceiver;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiver;
import nu.validator.vendor.thaiopensource.validate.prop.rng.RngProperty;
import nu.validator.vendor.thaiopensource.validate.prop.wrap.WrapProperty;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SchemaReceiverImpl
implements SchemaReceiver {
    private final ParseReceiver parser;
    private final PropertyMap properties;

    public SchemaReceiverImpl(ParseReceiver parseReceiver, PropertyMap propertyMap) {
        this.parser = parseReceiver;
        this.properties = propertyMap;
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) throws SAXException {
        final SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(this.properties);
        DatatypeLibraryFactory datatypeLibraryFactory = RngProperty.DATATYPE_LIBRARY_FACTORY.get(this.properties);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        final PatternFuture patternFuture = SchemaBuilderImpl.installHandlers(this.parser, xMLReader, errorHandler, datatypeLibraryFactory, schemaPatternBuilder);
        return new SchemaFuture(){
            final /* synthetic */ SchemaReceiverImpl this$0;
            {
                this.this$0 = schemaReceiverImpl;
            }

            @Override
            public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
                try {
                    return SchemaReaderImpl.wrapPattern(patternFuture.getPattern(this.this$0.properties.contains(WrapProperty.ATTRIBUTE_OWNER)), schemaPatternBuilder, this.this$0.properties);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    throw new IncorrectSchemaException();
                }
            }

            @Override
            public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
                if (runtimeException instanceof BuildException) {
                    try {
                        return SchemaBuilderImpl.unwrapBuildException((BuildException)runtimeException);
                    }
                    catch (IllegalSchemaException illegalSchemaException) {
                        throw new IncorrectSchemaException();
                    }
                }
                return runtimeException;
            }
        };
    }
}

