/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import nu.validator.vendor.relaxng.datatype.DatatypeLibraryFactory;
import nu.validator.vendor.thaiopensource.datatype.DatatypeLibraryLoader;
import nu.validator.vendor.thaiopensource.relaxng.impl.CombineSchema;
import nu.validator.vendor.thaiopensource.relaxng.impl.FeasibleIdTypeMapSchema;
import nu.validator.vendor.thaiopensource.relaxng.impl.FeasibleTransform;
import nu.validator.vendor.thaiopensource.relaxng.impl.IdTypeMap;
import nu.validator.vendor.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import nu.validator.vendor.thaiopensource.relaxng.impl.IdTypeMapSchema;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternSchema;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import nu.validator.vendor.thaiopensource.relaxng.parse.IllegalSchemaException;
import nu.validator.vendor.thaiopensource.relaxng.parse.Parseable;
import nu.validator.vendor.thaiopensource.util.PropertyId;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.AbstractSchema;
import nu.validator.vendor.thaiopensource.validate.AbstractSchemaReader;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Option;
import nu.validator.vendor.thaiopensource.validate.ResolverFactory;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.prop.rng.RngProperty;
import nu.validator.vendor.thaiopensource.validate.prop.wrap.WrapProperty;
import nu.validator.vendor.thaiopensource.xml.sax.Resolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class SchemaReaderImpl
extends AbstractSchemaReader {
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER};

    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        Resolver resolver = ResolverFactory.createResolver(propertyMap);
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        DatatypeLibraryFactory datatypeLibraryFactory = RngProperty.DATATYPE_LIBRARY_FACTORY.get(propertyMap);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(this.createParseable(sAXSource, resolver, errorHandler), errorHandler, datatypeLibraryFactory, schemaPatternBuilder, propertyMap.contains(WrapProperty.ATTRIBUTE_OWNER));
            return SchemaReaderImpl.wrapPattern(pattern, schemaPatternBuilder, propertyMap);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }

    @Override
    public Option getOption(String string) {
        return RngProperty.getOption(string);
    }

    static Schema wrapPattern(Pattern pattern, SchemaPatternBuilder schemaPatternBuilder, PropertyMap propertyMap) throws SAXException, IncorrectSchemaException {
        if ((propertyMap = AbstractSchema.filterProperties(propertyMap, supportedPropertyIds)).contains(RngProperty.FEASIBLE)) {
            pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
        }
        AbstractSchema abstractSchema = new PatternSchema(schemaPatternBuilder, pattern, propertyMap);
        if (schemaPatternBuilder.hasIdTypes() && propertyMap.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(errorHandler, pattern).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema abstractSchema2 = propertyMap.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, propertyMap) : new IdTypeMapSchema(idTypeMap, propertyMap);
            abstractSchema = new CombineSchema(abstractSchema, abstractSchema2, propertyMap);
        }
        return abstractSchema;
    }

    protected abstract Parseable createParseable(SAXSource var1, Resolver var2, ErrorHandler var3) throws SAXException;
}

