/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.thaiopensource.relaxng.impl.Alphabet;
import nu.validator.vendor.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternVisitor;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern pattern, Locator locator) {
        super(false, 3, ListPattern.combineHashCode(37, pattern.hashCode()));
        this.p = pattern;
        this.locator = locator;
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeList(pattern, this.locator);
        }
        return this;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    @Override
    boolean samePattern(Pattern pattern) {
        return pattern instanceof ListPattern && this.p == ((ListPattern)pattern).p;
    }

    @Override
    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitList(this.p);
    }

    @Override
    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseList(this);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, duplicateAttributeDetector, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.locator);
            throw restrictionViolationException;
        }
    }

    Pattern getOperand() {
        return this.p;
    }
}

