/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.util.HashMap;
import java.util.Map;
import nu.validator.vendor.relaxng.datatype.DatatypeLibrary;
import nu.validator.vendor.relaxng.datatype.DatatypeLibraryFactory;
import nu.validator.vendor.thaiopensource.relaxng.impl.BuiltinDatatypeLibrary;
import nu.validator.vendor.thaiopensource.relaxng.impl.CompatibilityDatatypeLibrary;

class BuiltinDatatypeLibraryFactory
implements DatatypeLibraryFactory {
    private final Map cache = new HashMap();
    private final DatatypeLibraryFactory factory;
    private final DatatypeLibrary builtinDatatypeLibrary = new BuiltinDatatypeLibrary();
    private DatatypeLibrary lastDatatypeLibrary = null;
    private String lastDatatypeLibraryUri = null;

    BuiltinDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.factory = datatypeLibraryFactory;
        this.cache.put("http://relaxng.org/ns/compatibility/datatypes/1.0", new CompatibilityDatatypeLibrary(this));
    }

    @Override
    public DatatypeLibrary createDatatypeLibrary(String string) {
        if (string.equals("")) {
            return this.builtinDatatypeLibrary;
        }
        if (string.equals(this.lastDatatypeLibraryUri)) {
            return this.lastDatatypeLibrary;
        }
        DatatypeLibrary datatypeLibrary = (DatatypeLibrary)this.cache.get(string);
        if (datatypeLibrary == null) {
            if (this.factory == null) {
                return null;
            }
            datatypeLibrary = this.factory.createDatatypeLibrary(string);
            if (datatypeLibrary == null) {
                return null;
            }
            this.cache.put(string, datatypeLibrary);
        }
        this.lastDatatypeLibraryUri = string;
        this.lastDatatypeLibrary = datatypeLibrary;
        return this.lastDatatypeLibrary;
    }
}

