/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.jp.gr.xml.relax.sax;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SimpleEntityResolver
implements EntityResolver {
    private Map publicIds_ = new HashMap();
    private Map systemIds_ = new HashMap();
    private List relativeSystemIds_ = new ArrayList();

    public SimpleEntityResolver() {
    }

    public SimpleEntityResolver(String name, String uri) {
        this._init(new String[][]{{name, uri}}, null);
    }

    public SimpleEntityResolver(String[][] systemIds) {
        this._init(systemIds, null);
    }

    public SimpleEntityResolver(String[][] systemIds, String[][] publicIds) {
        this._init(systemIds, publicIds);
    }

    private void _init(String[][] systemIds, String[][] publicIds) {
        int i;
        if (systemIds != null) {
            for (i = 0; i < systemIds.length; ++i) {
                String systemId = systemIds[i][0];
                this.addSystemId(systemId, systemIds[i][1]);
            }
        }
        if (publicIds != null) {
            for (i = 0; i < publicIds.length; ++i) {
                this.addPublicId(publicIds[i][0], publicIds[i][1]);
            }
        }
    }

    public void addSystemId(String systemId, String uri) {
        this.systemIds_.put(systemId, uri);
        this.relativeSystemIds_.add(systemId);
    }

    public void addPublicId(String publicId, String uri) {
        this.publicIds_.put(publicId, uri);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && this._isExist(systemId)) {
            return new InputSource(systemId);
        }
        if (publicId != null) {
            String uri = (String)this.publicIds_.get(publicId);
            if (uri != null) {
                return new InputSource(uri);
            }
            return null;
        }
        if (systemId != null) {
            String uri = this._getURIBySystemId(systemId);
            if (uri != null) {
                return new InputSource(uri);
            }
            return new InputSource(systemId);
        }
        return null;
    }

    private boolean _isExist(String uri) {
        try {
            URL url = new URL(uri);
            if ("file".equals(url.getProtocol())) {
                InputStream in = url.openStream();
                in.close();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String _getURIBySystemId(String systemId) {
        String uri = (String)this.systemIds_.get(systemId);
        if (uri != null) {
            return uri;
        }
        int size = this.relativeSystemIds_.size();
        for (int i = 0; i < size; ++i) {
            String relativeId = (String)this.relativeSystemIds_.get(i);
            if (!systemId.endsWith(relativeId)) continue;
            return (String)this.systemIds_.get(relativeId);
        }
        return null;
    }
}

