/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.source.test;

import java.io.StringReader;
import java.util.SortedSet;
import nu.validator.source.SourceCode;
import nu.validator.source.SourceHandler;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.SAXException;

public class SourceCodeTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) throws SAXException {
        SourceCodeTest.testIsWithinKnownSourceValidLocations();
        SourceCodeTest.testIsWithinKnownSourceOutOfBounds();
        SourceCodeTest.testEmitSourceDoesNotThrow();
        SourceCodeTest.testEmitSourceWithErrors();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static SourceCode createSourceCode(String content) throws SAXException {
        SourceCode sourceCode = new SourceCode();
        TypedInputSource inputSource = new TypedInputSource(new StringReader(content));
        inputSource.setSystemId("test://test.html");
        inputSource.setType("text/html");
        sourceCode.initialize(inputSource);
        sourceCode.start();
        char[] chars = content.toCharArray();
        sourceCode.characters(chars, 0, chars.length);
        sourceCode.end();
        return sourceCode;
    }

    private static void testIsWithinKnownSourceValidLocations() throws SAXException {
        SourceCode sourceCode = SourceCodeTest.createSourceCode("Line 1\nLine 2\nLine 3");
        SourceCodeTest.assertTrue("isWithinKnownSource for line 1 (one-based)", sourceCode.isWithinKnownSource(1));
        SourceCodeTest.assertTrue("isWithinKnownSource for line 2 (one-based)", sourceCode.isWithinKnownSource(2));
        SourceCodeTest.assertTrue("isWithinKnownSource for line 3 (one-based)", sourceCode.isWithinKnownSource(3));
    }

    private static void testIsWithinKnownSourceOutOfBounds() throws SAXException {
        SourceCode sourceCode = SourceCodeTest.createSourceCode("Line 1\nLine 2\nLine 3");
        SourceCodeTest.assertFalse("isWithinKnownSource returns false for line 4", sourceCode.isWithinKnownSource(4));
        SourceCodeTest.assertFalse("isWithinKnownSource returns false for line 100", sourceCode.isWithinKnownSource(100));
        SourceCodeTest.assertFalse("isWithinKnownSource(Location) returns false for out-of-bounds", sourceCode.isWithinKnownSource(sourceCode.newLocatorLocation(100, 1)));
    }

    private static void testEmitSourceDoesNotThrow() throws SAXException {
        SourceCode sourceCode = SourceCodeTest.createSourceCode("Short");
        try {
            sourceCode.emitSource(SourceCodeTest.createNoOpHandler());
            SourceCodeTest.pass("emitSource completes without throwing");
        }
        catch (IndexOutOfBoundsException e) {
            SourceCodeTest.fail("emitSource threw IndexOutOfBoundsException: " + e.getMessage());
        }
    }

    private static void testEmitSourceWithErrors() throws SAXException {
        SourceCode sourceCode = SourceCodeTest.createSourceCode("Line 1\nLine 2");
        sourceCode.addLocatorLocation(2, 7);
        sourceCode.rememberExactError(sourceCode.newLocatorLocation(2, 6));
        try {
            sourceCode.emitSource(SourceCodeTest.createNoOpHandler());
            SourceCodeTest.pass("emitSource with errors completes without throwing");
        }
        catch (IndexOutOfBoundsException e) {
            SourceCodeTest.fail("emitSource with errors threw IndexOutOfBoundsException: " + e.getMessage());
        }
    }

    private static SourceHandler createNoOpHandler() {
        return new SourceHandler(){

            @Override
            public void startSource(String type, String encoding) throws SAXException {
            }

            @Override
            public void endSource() throws SAXException {
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
            }

            @Override
            public void newLine() throws SAXException {
            }

            @Override
            public void startCharHilite(int line, int col) throws SAXException {
            }

            @Override
            public void endCharHilite() throws SAXException {
            }

            @Override
            public void startRange(int line, int col) throws SAXException {
            }

            @Override
            public void endRange() throws SAXException {
            }

            @Override
            public void setLineErrors(SortedSet<Integer> errors) {
            }
        };
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            SourceCodeTest.pass(testName);
        } else {
            SourceCodeTest.fail(testName);
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        SourceCodeTest.assertTrue(testName, !condition);
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }
}

