/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class OutlineBuildingXMLReaderWrapper
implements XMLReader,
ContentHandler {
    private final XMLReader wrappedReader;
    private final HttpServletRequest request;
    private ContentHandler contentHandler;
    private final ArrayList<String> SECTIONING_ROOT_ELEMENTS = new ArrayList();
    private boolean isHeadingOutline = false;
    private static final int MAX_EXCERPT = 500;
    private static final String[] SECTIONING_CONTENT_ELEMENTS = new String[]{"article", "aside", "nav", "section"};
    private static final String[] H1_TO_H6_ELEMENTS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    private Deque<Section> outline;
    private int currentWalkDepth;
    private Element currentOutlinee;
    private Deque<Element> elementStack = new LinkedList<Element>();
    private Deque<Element> outlineStack = new LinkedList<Element>();
    private boolean inHeadingContentOrHiddenElement;
    private Section currentSection;
    private Section currentHgroupSection;
    private boolean inHgroup;
    private boolean skipHeading = false;
    private boolean isWalkOver;
    private static final Pattern excerptPattern = Pattern.compile("\\W*\\S*$");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");

    public OutlineBuildingXMLReaderWrapper(XMLReader wrappedReader, HttpServletRequest request, boolean isHeadingOutline) {
        this.request = request;
        this.isHeadingOutline = isHeadingOutline;
        this.wrappedReader = wrappedReader;
        this.contentHandler = wrappedReader.getContentHandler();
        this.inHgroup = false;
        if (isHeadingOutline) {
            this.SECTIONING_ROOT_ELEMENTS.add("body");
        } else {
            this.SECTIONING_ROOT_ELEMENTS.add("blockquote");
            this.SECTIONING_ROOT_ELEMENTS.add("body");
            this.SECTIONING_ROOT_ELEMENTS.add("details");
            this.SECTIONING_ROOT_ELEMENTS.add("fieldset");
            this.SECTIONING_ROOT_ELEMENTS.add("figure");
            this.SECTIONING_ROOT_ELEMENTS.add("td");
        }
        wrappedReader.setContentHandler(this);
    }

    public Deque<Section> getOutline() {
        return this.outline;
    }

    protected void setOutline(Deque<Section> outline) {
        this.outline = outline;
    }

    private boolean inHiddenSubtree() {
        for (Element element : this.elementStack) {
            if (!element.isHidden()) continue;
            return true;
        }
        return false;
    }

    private int parseNonNegativeInteger(String value) {
        if (value == null || value.isEmpty()) {
            return -1;
        }
        try {
            int result = Integer.parseInt(value.trim());
            return result >= 0 ? result : -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int getComputedHeadingOffset() {
        int offset = 0;
        for (Element element : this.elementStack) {
            int nextOffset = element.getHeadingOffset();
            if (nextOffset > 0) {
                offset += nextOffset;
            }
            if (!element.hasHeadingReset()) continue;
            return offset;
        }
        return offset;
    }

    private int getComputedHeadingLevel(int baseLevel) {
        int level = baseLevel + this.getComputedHeadingOffset();
        return level > 9 ? 9 : level;
    }

    private String excerpt(String str, int maxLength) {
        return str.length() > maxLength ? excerptPattern.matcher(str.substring(0, maxLength)).replaceFirst("&hellip;") : str;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.isWalkOver) {
            this.contentHandler.characters(ch, start, length);
            return;
        }
        if (this.inHeadingContentOrHiddenElement && !this.inHiddenSubtree()) {
            this.currentSection.getHeadingTextBuilder().append(ch, start, length);
        }
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.elementStack.pop();
        if (this.isWalkOver) {
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        if ("hgroup".equals(localName)) {
            this.inHgroup = false;
            this.skipHeading = false;
        } else if (Arrays.binarySearch(H1_TO_H6_ELEMENTS, localName) > -1 && this.inHgroup) {
            if (this.skipHeading) {
                this.currentSection.setIsMasked();
                this.currentHgroupSection.subheadSections.add(this.currentSection);
            } else {
                this.skipHeading = true;
                this.currentHgroupSection = this.currentSection;
                this.currentHgroupSection.subheadSections = new LinkedList();
            }
        }
        int depth = this.currentWalkDepth--;
        if (this.inHeadingContentOrHiddenElement) {
            Element topElement = this.outlineStack.peek();
            assert (topElement != null);
            if (topElement.equals(depth, localName)) {
                this.outlineStack.pop();
                this.inHeadingContentOrHiddenElement = false;
                if (this.currentSection != null) {
                    StringBuilder headingTextBuilder = this.currentSection.getHeadingTextBuilder();
                    String heading = this.excerpt(whitespacePattern.matcher(headingTextBuilder).replaceAll(" ").trim(), 500);
                    headingTextBuilder.setLength(0);
                    if (heading.length() == 0) {
                        StringBuilder headingImgAltTextBuilder = this.currentSection.getHeadingImgAltTextBuilder();
                        heading = this.excerpt(whitespacePattern.matcher(headingImgAltTextBuilder).replaceAll(" ").trim(), 500);
                        headingImgAltTextBuilder.setLength(0);
                    }
                    if (heading.length() > 0) {
                        headingTextBuilder.append(heading);
                    } else {
                        this.currentSection.createEmptyHeading();
                    }
                }
            }
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        if (Arrays.binarySearch(SECTIONING_CONTENT_ELEMENTS, localName) > -1) {
            if (!this.outlineStack.isEmpty()) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                Element exitedSectioningContentElement = this.currentOutlinee;
                assert (exitedSectioningContentElement != null);
                this.currentOutlinee = this.outlineStack.pop();
                this.currentSection = this.currentOutlinee.getOutline().peekLast();
                assert (this.currentSection != null);
                for (Section section : exitedSectioningContentElement.outline) {
                    section.setParent(this.currentSection);
                    this.currentSection.sections.add(section);
                }
            }
        } else if (Arrays.binarySearch(this.SECTIONING_ROOT_ELEMENTS.toArray(), localName) > -1) {
            if (!this.outlineStack.isEmpty()) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                this.currentOutlinee = this.outlineStack.pop();
                this.currentSection = this.currentOutlinee.getOutline().peekLast();
                while (!this.currentSection.sections.isEmpty()) {
                    this.currentSection = this.currentSection.sections.peekLast();
                }
            }
        } else {
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        if (this.currentSection != null && !this.currentSection.hasHeading()) {
            this.currentSection.createImpliedHeading();
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int parsedOffset;
        if (this.contentHandler == null) {
            return;
        }
        if (this.isWalkOver) {
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if ("hgroup".equals(localName)) {
            this.inHgroup = true;
        }
        ++this.currentWalkDepth;
        boolean hidden = atts.getIndex("", "hidden") >= 0 || "template".equals(localName);
        int headingOffset = 0;
        String headingOffsetAttr = atts.getValue("", "headingoffset");
        if (headingOffsetAttr != null && (parsedOffset = this.parseNonNegativeInteger(headingOffsetAttr)) >= 0) {
            headingOffset = parsedOffset;
        }
        boolean headingReset = atts.getIndex("", "headingreset") >= 0;
        this.elementStack.push(new Element(this.currentWalkDepth, localName, hidden, headingOffset, headingReset));
        if (this.inHeadingContentOrHiddenElement) {
            if (!this.inHiddenSubtree() && "img".equals(localName) && atts.getIndex("", "alt") >= 0) {
                this.currentSection.getHeadingImgAltTextBuilder().append(atts.getValue("", "alt"));
            }
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (hidden) {
            this.outlineStack.push(new Element(this.currentWalkDepth, localName, hidden, headingOffset, headingReset));
            this.inHeadingContentOrHiddenElement = true;
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (Arrays.binarySearch(SECTIONING_CONTENT_ELEMENTS, localName) > -1 || Arrays.binarySearch(this.SECTIONING_ROOT_ELEMENTS.toArray(), localName) > -1) {
            if (this.currentOutlinee != null) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                this.outlineStack.push(this.currentOutlinee);
            }
            this.currentOutlinee = new Element(this.currentWalkDepth, localName, hidden, headingOffset, headingReset);
            this.currentSection = new Section(localName);
            this.currentOutlinee.getOutline().add(this.currentSection);
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (Arrays.binarySearch(H1_TO_H6_ELEMENTS, localName) > -1 && this.currentOutlinee != null) {
            int baseLevel = localName.charAt(1) - 48;
            int rank = this.getComputedHeadingLevel(baseLevel);
            if (this.currentSection != null && !this.currentSection.hasHeading()) {
                this.currentSection.setHeadingRank(rank);
            } else if (rank <= this.currentOutlinee.getLastSectionHeadingRank()) {
                this.currentSection = new Section(localName);
                this.currentOutlinee.getOutline().add(this.currentSection);
                this.currentSection.setHeadingRank(rank);
            } else {
                for (Section candidateSection = this.currentSection; candidateSection != null; candidateSection = candidateSection.getParent()) {
                    if (rank <= candidateSection.getHeadingRank()) continue;
                    this.currentSection = new Section(localName);
                    this.currentSection.setParent(candidateSection);
                    candidateSection.getSections().add(this.currentSection);
                    this.currentSection.setHeadingRank(rank);
                    break;
                }
            }
            this.outlineStack.push(new Element(this.currentWalkDepth, localName, hidden, headingOffset, headingReset));
            this.inHeadingContentOrHiddenElement = true;
            this.currentSection.setHeadingElementName(localName);
        }
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.currentOutlinee != null) {
            if (this.isHeadingOutline) {
                this.request.setAttribute("http://validator.nu/properties/document-outline", this.currentOutlinee.outline);
            }
            this.setOutline(this.currentOutlinee.outline);
        }
        this.contentHandler.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.wrappedReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.wrappedReader.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.wrappedReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.wrappedReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.wrappedReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.wrappedReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setProperty(name, value);
    }

    private class Element {
        private final int depth;
        private final String name;
        private final boolean hidden;
        private final int headingOffset;
        private final boolean headingReset;
        private final Deque<Section> outline = new LinkedList<Section>();

        public Element(int depth, String name, boolean hidden, int headingOffset, boolean headingReset) {
            this.depth = depth;
            this.name = name;
            this.hidden = hidden;
            this.headingOffset = headingOffset;
            this.headingReset = headingReset;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public int getHeadingOffset() {
            return this.headingOffset;
        }

        public boolean hasHeadingReset() {
            return this.headingReset;
        }

        public boolean equals(int depth, String name) {
            return this.depth == depth && this.name.equals(name);
        }

        public Deque<Section> getOutline() {
            return this.outline;
        }

        public int getLastSectionHeadingRank() {
            Section section = this.outline.peekLast();
            return section != null ? section.getHeadingRank() : -1;
        }
    }

    public class Section {
        private Section parent;
        final String elementName;
        private final StringBuilder headingTextBuilder = new StringBuilder();
        private LinkedList<Section> subheadSections;
        private final StringBuilder headingImgAltTextBuilder = new StringBuilder();
        private boolean hasImpliedHeading;
        private boolean hasEmptyHeading;
        private String headingElementName;
        private boolean isMasked;
        private int headingRank = Integer.MAX_VALUE;
        public final Deque<Section> sections = new LinkedList<Section>();

        public Section(String elementName) {
            this.elementName = elementName;
        }

        public Section getParent() {
            return this.parent;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setParent(Section parent) {
            this.parent = parent;
        }

        public StringBuilder getHeadingTextBuilder() {
            return this.headingTextBuilder;
        }

        public StringBuilder getHeadingImgAltTextBuilder() {
            return this.headingImgAltTextBuilder;
        }

        public String getHeadingElementName() {
            return this.headingElementName;
        }

        public int getHeadingRank() {
            return this.headingRank;
        }

        public Deque<Section> getSections() {
            return this.sections;
        }

        public void setHeadingElementName(String elementName) {
            this.headingElementName = elementName;
        }

        public void setIsMasked() {
            this.isMasked = true;
        }

        public boolean getIsMasked() {
            return this.isMasked;
        }

        public LinkedList<Section> getSubheadSections() {
            return this.subheadSections;
        }

        public void setHeadingRank(int headingRank) {
            this.headingRank = headingRank;
        }

        public boolean hasHeading() {
            return this.headingRank < 7 || this.hasImpliedHeading;
        }

        public void createImpliedHeading() {
            this.hasImpliedHeading = true;
        }

        public void createEmptyHeading() {
            this.hasEmptyHeading = true;
        }

        public boolean hasEmptyHeading() {
            return this.hasEmptyHeading;
        }
    }
}

