/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io.test;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import nu.validator.io.SystemIdIOException;

public class SystemIdIOExceptionTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        SystemIdIOExceptionTest.testConstructorWithSystemIdOnly();
        SystemIdIOExceptionTest.testConstructorWithSystemIdAndMessage();
        SystemIdIOExceptionTest.testConstructorWithSystemIdMessageAndCause();
        SystemIdIOExceptionTest.testDefaultConstructor();
        SystemIdIOExceptionTest.testIsInstanceOfIOException();
        SystemIdIOExceptionTest.testHttpRequestFailedPattern();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testConstructorWithSystemIdOnly() {
        String url = "https://example.com/test.html";
        SystemIdIOException ex = new SystemIdIOException(url);
        SystemIdIOExceptionTest.assertEquals("systemId-only constructor: getSystemId()", url, ex.getSystemId());
        SystemIdIOExceptionTest.assertNull("systemId-only constructor: getMessage()", ex.getMessage());
        SystemIdIOExceptionTest.assertNull("systemId-only constructor: getCause()", ex.getCause());
        SystemIdIOExceptionTest.pass("systemId-only constructor: created successfully");
    }

    private static void testConstructorWithSystemIdAndMessage() {
        String url = "https://example.com/test.html";
        String message = "Connection refused";
        SystemIdIOException ex = new SystemIdIOException(url, message);
        SystemIdIOExceptionTest.assertEquals("systemId+message constructor: getSystemId()", url, ex.getSystemId());
        SystemIdIOExceptionTest.assertEquals("systemId+message constructor: getMessage()", message, ex.getMessage());
        SystemIdIOExceptionTest.assertNull("systemId+message constructor: getCause()", ex.getCause());
        SystemIdIOExceptionTest.pass("systemId+message constructor: created successfully");
    }

    private static void testConstructorWithSystemIdMessageAndCause() {
        String url = "https://unregistered-domain-xyz.com/";
        String message = "HTTP request failed: Name or service not known";
        ExecutionException cause = new ExecutionException("Name or service not known", new UnknownHostException("unregistered-domain-xyz.com"));
        SystemIdIOException ex = new SystemIdIOException(url, message, cause);
        SystemIdIOExceptionTest.assertEquals("full constructor: getSystemId()", url, ex.getSystemId());
        SystemIdIOExceptionTest.assertEquals("full constructor: getMessage()", message, ex.getMessage());
        SystemIdIOExceptionTest.assertEquals("full constructor: getCause()", cause, ex.getCause());
        SystemIdIOExceptionTest.pass("full constructor: created successfully");
    }

    private static void testDefaultConstructor() {
        SystemIdIOException ex = new SystemIdIOException();
        SystemIdIOExceptionTest.assertNull("default constructor: getSystemId()", ex.getSystemId());
        SystemIdIOExceptionTest.assertNull("default constructor: getMessage()", ex.getMessage());
        SystemIdIOExceptionTest.pass("default constructor: created successfully");
    }

    private static void testIsInstanceOfIOException() {
        SystemIdIOException ex = new SystemIdIOException("https://example.com/");
        SystemIdIOExceptionTest.assertTrue("instanceof IOException", ex instanceof IOException);
        SystemIdIOExceptionTest.pass("instanceof IOException: verified");
    }

    private static void testHttpRequestFailedPattern() {
        String systemId = "https://nonexistent-domain-12345.example/page.html";
        ExecutionException httpClientException = new ExecutionException("java.net.UnknownHostException: nonexistent-domain-12345.example: Name or service not known", new UnknownHostException("nonexistent-domain-12345.example: Name or service not known"));
        SystemIdIOException ex = new SystemIdIOException(systemId, "HTTP request failed: " + httpClientException.getMessage(), httpClientException);
        SystemIdIOExceptionTest.assertEquals("HTTP pattern: getSystemId() preserves URL", systemId, ex.getSystemId());
        SystemIdIOExceptionTest.assertTrue("HTTP pattern: getMessage() contains 'HTTP request failed'", ex.getMessage().contains("HTTP request failed"));
        SystemIdIOExceptionTest.assertTrue("HTTP pattern: getMessage() contains DNS error", ex.getMessage().contains("Name or service not known"));
        SystemIdIOExceptionTest.pass("HTTP request failed pattern: works correctly");
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            SystemIdIOExceptionTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            ++failed;
        }
    }

    private static void assertNull(String testName, Object value) {
        if (value == null) {
            SystemIdIOExceptionTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: null");
            System.out.println("  Actual: " + String.valueOf(value));
            ++failed;
        }
    }

    private static void assertEquals(String testName, Object expected, Object actual) {
        if (expected == null ? actual == null : expected.equals(actual)) {
            SystemIdIOExceptionTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + String.valueOf(expected));
            System.out.println("  Actual: " + String.valueOf(actual));
            ++failed;
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }
}

