/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype.test;

import nu.validator.datatype.CustomElementName;
import nu.validator.datatype.Date;
import nu.validator.datatype.DateOrTime;
import nu.validator.datatype.Datetime;
import nu.validator.datatype.DatetimeLocal;
import nu.validator.datatype.DatetimeTz;
import nu.validator.datatype.FloatingPointExponent;
import nu.validator.datatype.HashName;
import nu.validator.datatype.Html5DatatypeLibrary;
import nu.validator.datatype.Id;
import nu.validator.datatype.Idref;
import nu.validator.datatype.Idrefs;
import nu.validator.datatype.IntNonNegative;
import nu.validator.datatype.IntPositive;
import nu.validator.datatype.Language;
import nu.validator.datatype.MetaCharset;
import nu.validator.datatype.MimeType;
import nu.validator.datatype.Month;
import nu.validator.datatype.NonEmptyString;
import nu.validator.datatype.SimpleColor;
import nu.validator.datatype.Time;
import nu.validator.datatype.TimeDatetime;
import nu.validator.datatype.Week;
import nu.validator.datatype.Zero;
import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public class DatatypeTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing SimpleColor...");
        DatatypeTest.testSimpleColorValid();
        DatatypeTest.testSimpleColorInvalid();
        System.out.println();
        System.out.println("Testing NonEmptyString...");
        DatatypeTest.testNonEmptyStringValid();
        DatatypeTest.testNonEmptyStringInvalid();
        System.out.println();
        System.out.println("Testing Time...");
        DatatypeTest.testTimeValid();
        DatatypeTest.testTimeInvalid();
        System.out.println();
        System.out.println("Testing Id...");
        DatatypeTest.testIdValid();
        DatatypeTest.testIdInvalid();
        System.out.println();
        System.out.println("Testing HashName...");
        DatatypeTest.testHashNameValid();
        DatatypeTest.testHashNameInvalid();
        System.out.println();
        System.out.println("Testing CustomElementName...");
        DatatypeTest.testCustomElementNameValid();
        DatatypeTest.testCustomElementNameInvalid();
        System.out.println();
        System.out.println("Testing MetaCharset...");
        DatatypeTest.testMetaCharsetValid();
        DatatypeTest.testMetaCharsetInvalid();
        DatatypeTest.testMetaCharsetLooping();
        System.out.println();
        System.out.println("Testing Date...");
        DatatypeTest.testDateValid();
        DatatypeTest.testDateInvalid();
        System.out.println();
        System.out.println("Testing Month...");
        DatatypeTest.testMonthValid();
        DatatypeTest.testMonthInvalid();
        System.out.println();
        System.out.println("Testing Week...");
        DatatypeTest.testWeekValid();
        DatatypeTest.testWeekInvalid();
        System.out.println();
        System.out.println("Testing MimeType...");
        DatatypeTest.testMimeTypeValid();
        DatatypeTest.testMimeTypeInvalid();
        System.out.println();
        System.out.println("Testing IriRef (URL)...");
        DatatypeTest.testIriRefValid();
        DatatypeTest.testIriRefInvalid();
        System.out.println();
        System.out.println("Testing Datetime (UTC)...");
        DatatypeTest.testDatetimeValid();
        DatatypeTest.testDatetimeInvalid();
        System.out.println();
        System.out.println("Testing DatetimeLocal...");
        DatatypeTest.testDatetimeLocalValid();
        DatatypeTest.testDatetimeLocalInvalid();
        System.out.println();
        System.out.println("Testing DatetimeTz...");
        DatatypeTest.testDatetimeTzValid();
        DatatypeTest.testDatetimeTzInvalid();
        System.out.println();
        System.out.println("Testing DateOrTime...");
        DatatypeTest.testDateOrTimeValid();
        DatatypeTest.testDateOrTimeInvalid();
        System.out.println();
        System.out.println("Testing TimeDatetime...");
        DatatypeTest.testTimeDatetimeValid();
        DatatypeTest.testTimeDatetimeInvalid();
        System.out.println();
        System.out.println("Testing IntNonNegative...");
        DatatypeTest.testIntNonNegativeValid();
        DatatypeTest.testIntNonNegativeInvalid();
        System.out.println();
        System.out.println("Testing IntPositive...");
        DatatypeTest.testIntPositiveValid();
        DatatypeTest.testIntPositiveInvalid();
        System.out.println();
        System.out.println("Testing Zero...");
        DatatypeTest.testZeroValid();
        DatatypeTest.testZeroInvalid();
        System.out.println();
        System.out.println("Testing FloatingPointExponent...");
        DatatypeTest.testFloatingPointExponentValid();
        DatatypeTest.testFloatingPointExponentInvalid();
        System.out.println();
        System.out.println("Testing Idref...");
        DatatypeTest.testIdrefValid();
        DatatypeTest.testIdrefInvalid();
        System.out.println();
        System.out.println("Testing Idrefs...");
        DatatypeTest.testIdrefsValid();
        DatatypeTest.testIdrefsInvalid();
        System.out.println();
        System.out.println("Testing Language...");
        DatatypeTest.testLanguageValid();
        DatatypeTest.testLanguageInvalid();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testSimpleColorValid() {
        SimpleColor validator = SimpleColor.THE_INSTANCE;
        DatatypeTest.assertValid("SimpleColor: lowercase hex", validator, "#abcdef");
        DatatypeTest.assertValid("SimpleColor: uppercase hex", validator, "#ABCDEF");
        DatatypeTest.assertValid("SimpleColor: mixed case hex", validator, "#AbCdEf");
        DatatypeTest.assertValid("SimpleColor: all digits", validator, "#123456");
        DatatypeTest.assertValid("SimpleColor: black", validator, "#000000");
        DatatypeTest.assertValid("SimpleColor: white", validator, "#ffffff");
        DatatypeTest.assertValid("SimpleColor: red", validator, "#ff0000");
        DatatypeTest.assertValid("SimpleColor: green", validator, "#00ff00");
        DatatypeTest.assertValid("SimpleColor: blue", validator, "#0000ff");
    }

    private static void testSimpleColorInvalid() {
        SimpleColor validator = SimpleColor.THE_INSTANCE;
        DatatypeTest.assertInvalid("SimpleColor: empty string", validator, "");
        DatatypeTest.assertInvalid("SimpleColor: missing hash", validator, "abcdef");
        DatatypeTest.assertInvalid("SimpleColor: too short (3 digits)", validator, "#fff");
        DatatypeTest.assertInvalid("SimpleColor: too short (5 digits)", validator, "#12345");
        DatatypeTest.assertInvalid("SimpleColor: too long (7 digits)", validator, "#1234567");
        DatatypeTest.assertInvalid("SimpleColor: too long (8 digits)", validator, "#12345678");
        DatatypeTest.assertInvalid("SimpleColor: invalid hex digit 'g'", validator, "#gggggg");
        DatatypeTest.assertInvalid("SimpleColor: invalid hex digit 'z'", validator, "#12345z");
        DatatypeTest.assertInvalid("SimpleColor: spaces not allowed", validator, "# abcde");
        DatatypeTest.assertInvalid("SimpleColor: leading space", validator, " #abcdef");
        DatatypeTest.assertInvalid("SimpleColor: trailing space", validator, "#abcdef ");
        DatatypeTest.assertInvalid("SimpleColor: wrong start char", validator, "@abcdef");
        DatatypeTest.assertInvalid("SimpleColor: named color not allowed", validator, "red");
        DatatypeTest.assertInvalid("SimpleColor: rgb() not allowed", validator, "rgb(255,0,0)");
    }

    private static void testNonEmptyStringValid() {
        NonEmptyString validator = NonEmptyString.THE_INSTANCE;
        DatatypeTest.assertValid("NonEmptyString: single char", validator, "a");
        DatatypeTest.assertValid("NonEmptyString: word", validator, "hello");
        DatatypeTest.assertValid("NonEmptyString: sentence", validator, "Hello, World!");
        DatatypeTest.assertValid("NonEmptyString: whitespace only", validator, " ");
        DatatypeTest.assertValid("NonEmptyString: tab only", validator, "\t");
        DatatypeTest.assertValid("NonEmptyString: newline only", validator, "\n");
        DatatypeTest.assertValid("NonEmptyString: multiple spaces", validator, "   ");
        DatatypeTest.assertValid("NonEmptyString: unicode", validator, "\u00e9");
        DatatypeTest.assertValid("NonEmptyString: emoji", validator, "\ud83d\ude00");
        DatatypeTest.assertValid("NonEmptyString: very long string", validator, "a".repeat(10000));
    }

    private static void testNonEmptyStringInvalid() {
        NonEmptyString validator = NonEmptyString.THE_INSTANCE;
        DatatypeTest.assertInvalid("NonEmptyString: empty string", validator, "");
    }

    private static void testTimeValid() {
        Time validator = Time.THE_INSTANCE;
        DatatypeTest.assertValid("Time: midnight", validator, "00:00");
        DatatypeTest.assertValid("Time: noon", validator, "12:00");
        DatatypeTest.assertValid("Time: end of day", validator, "23:59");
        DatatypeTest.assertValid("Time: early morning", validator, "06:30");
        DatatypeTest.assertValid("Time: evening", validator, "18:45");
        DatatypeTest.assertValid("Time: with seconds", validator, "12:30:45");
        DatatypeTest.assertValid("Time: midnight with seconds", validator, "00:00:00");
        DatatypeTest.assertValid("Time: max seconds", validator, "23:59:59");
        DatatypeTest.assertValid("Time: with 1 decimal", validator, "12:30:45.1");
        DatatypeTest.assertValid("Time: with 2 decimals", validator, "12:30:45.12");
        DatatypeTest.assertValid("Time: with 3 decimals", validator, "12:30:45.123");
    }

    private static void testTimeInvalid() {
        Time validator = Time.THE_INSTANCE;
        DatatypeTest.assertInvalid("Time: empty string", validator, "");
        DatatypeTest.assertInvalid("Time: invalid hour 24", validator, "24:00");
        DatatypeTest.assertInvalid("Time: invalid hour 25", validator, "25:00");
        DatatypeTest.assertInvalid("Time: invalid minute 60", validator, "12:60");
        DatatypeTest.assertInvalid("Time: invalid second 60", validator, "12:30:60");
        DatatypeTest.assertInvalid("Time: single digit hour", validator, "1:00");
        DatatypeTest.assertInvalid("Time: single digit minute", validator, "12:0");
        DatatypeTest.assertInvalid("Time: missing colon", validator, "1200");
        DatatypeTest.assertInvalid("Time: extra colon", validator, "12:00:");
        DatatypeTest.assertInvalid("Time: AM/PM not allowed", validator, "12:00 PM");
        DatatypeTest.assertInvalid("Time: text not allowed", validator, "noon");
        DatatypeTest.assertInvalid("Time: negative hour", validator, "-01:00");
    }

    private static void testIdValid() {
        Id validator = Id.THE_INSTANCE;
        DatatypeTest.assertValid("Id: single char", validator, "a");
        DatatypeTest.assertValid("Id: simple id", validator, "myId");
        DatatypeTest.assertValid("Id: with hyphen", validator, "my-id");
        DatatypeTest.assertValid("Id: with underscore", validator, "my_id");
        DatatypeTest.assertValid("Id: with numbers", validator, "id123");
        DatatypeTest.assertValid("Id: starting with number", validator, "123");
        DatatypeTest.assertValid("Id: special chars", validator, "id!@#$%");
        DatatypeTest.assertValid("Id: unicode", validator, "\u00e9l\u00e8ve");
        DatatypeTest.assertValid("Id: emoji", validator, "\ud83d\ude00");
        DatatypeTest.assertValid("Id: long id", validator, "a".repeat(1000));
    }

    private static void testIdInvalid() {
        Id validator = Id.THE_INSTANCE;
        DatatypeTest.assertInvalid("Id: empty string", validator, "");
        DatatypeTest.assertInvalid("Id: single space", validator, " ");
        DatatypeTest.assertInvalid("Id: leading space", validator, " id");
        DatatypeTest.assertInvalid("Id: trailing space", validator, "id ");
        DatatypeTest.assertInvalid("Id: space in middle", validator, "my id");
        DatatypeTest.assertInvalid("Id: tab", validator, "my\tid");
        DatatypeTest.assertInvalid("Id: newline", validator, "my\nid");
        DatatypeTest.assertInvalid("Id: carriage return", validator, "my\rid");
    }

    private static void testHashNameValid() {
        HashName validator = HashName.THE_INSTANCE;
        DatatypeTest.assertValid("HashName: simple", validator, "#foo");
        DatatypeTest.assertValid("HashName: single char after hash", validator, "#a");
        DatatypeTest.assertValid("HashName: with hyphen", validator, "#my-name");
        DatatypeTest.assertValid("HashName: with numbers", validator, "#id123");
        DatatypeTest.assertValid("HashName: only numbers", validator, "#123");
        DatatypeTest.assertValid("HashName: unicode", validator, "#caf\u00e9");
        DatatypeTest.assertValid("HashName: with spaces after hash", validator, "# space");
    }

    private static void testHashNameInvalid() {
        HashName validator = HashName.THE_INSTANCE;
        DatatypeTest.assertInvalid("HashName: empty string", validator, "");
        DatatypeTest.assertInvalid("HashName: just hash", validator, "#");
        DatatypeTest.assertInvalid("HashName: no hash", validator, "foo");
        DatatypeTest.assertInvalid("HashName: wrong prefix", validator, "@foo");
    }

    private static void testCustomElementNameValid() {
        CustomElementName validator = CustomElementName.THE_INSTANCE;
        DatatypeTest.assertValid("CustomElementName: simple", validator, "my-element");
        DatatypeTest.assertValid("CustomElementName: with numbers", validator, "my-element-123");
        DatatypeTest.assertValid("CustomElementName: multiple hyphens", validator, "my-custom-element");
        DatatypeTest.assertValid("CustomElementName: hyphen at end", validator, "element-");
        DatatypeTest.assertValid("CustomElementName: underscore", validator, "my_element-test");
        DatatypeTest.assertValid("CustomElementName: dot", validator, "my.element-test");
        DatatypeTest.assertValid("CustomElementName: unicode", validator, "my-\u00e9l\u00e8ment");
        DatatypeTest.assertValid("CustomElementName: single letter then hyphen", validator, "x-foo");
    }

    private static void testCustomElementNameInvalid() {
        CustomElementName validator = CustomElementName.THE_INSTANCE;
        DatatypeTest.assertInvalid("CustomElementName: empty string", validator, "");
        DatatypeTest.assertInvalid("CustomElementName: no hyphen", validator, "myelement");
        DatatypeTest.assertInvalid("CustomElementName: starts with number", validator, "1-element");
        DatatypeTest.assertInvalid("CustomElementName: starts with hyphen", validator, "-element");
        DatatypeTest.assertInvalid("CustomElementName: starts with uppercase", validator, "My-element");
        DatatypeTest.assertInvalid("CustomElementName: contains uppercase", validator, "my-Element");
        DatatypeTest.assertInvalid("CustomElementName: prohibited annotation-xml", validator, "annotation-xml");
        DatatypeTest.assertInvalid("CustomElementName: prohibited color-profile", validator, "color-profile");
        DatatypeTest.assertInvalid("CustomElementName: prohibited font-face", validator, "font-face");
        DatatypeTest.assertInvalid("CustomElementName: prohibited font-face-format", validator, "font-face-format");
        DatatypeTest.assertInvalid("CustomElementName: prohibited font-face-name", validator, "font-face-name");
        DatatypeTest.assertInvalid("CustomElementName: prohibited font-face-src", validator, "font-face-src");
        DatatypeTest.assertInvalid("CustomElementName: prohibited font-face-uri", validator, "font-face-uri");
        DatatypeTest.assertInvalid("CustomElementName: prohibited missing-glyph", validator, "missing-glyph");
    }

    private static void testMetaCharsetValid() {
        MetaCharset validator = MetaCharset.THE_INSTANCE;
        DatatypeTest.assertValid("MetaCharset: simple valid", validator, "text/html; charset=utf-8");
        DatatypeTest.assertValid("MetaCharset: no space after semicolon", validator, "text/html;charset=utf-8");
        DatatypeTest.assertValid("MetaCharset: multiple spaces", validator, "text/html;   charset=utf-8");
        DatatypeTest.assertValid("MetaCharset: tab after semicolon", validator, "text/html;\tcharset=utf-8");
        DatatypeTest.assertValid("MetaCharset: uppercase CHARSET", validator, "text/html; CHARSET=utf-8");
        DatatypeTest.assertValid("MetaCharset: mixed case", validator, "text/html; ChArSeT=utf-8");
    }

    private static void testMetaCharsetInvalid() {
        MetaCharset validator = MetaCharset.THE_INSTANCE;
        DatatypeTest.assertInvalid("MetaCharset: empty string", validator, "");
        DatatypeTest.assertInvalid("MetaCharset: missing text/html", validator, "charset=utf-8");
        DatatypeTest.assertInvalid("MetaCharset: wrong content type", validator, "text/plain; charset=utf-8");
        DatatypeTest.assertInvalid("MetaCharset: missing charset", validator, "text/html;");
        DatatypeTest.assertInvalid("MetaCharset: wrong encoding", validator, "text/html; charset=iso-8859-1");
        DatatypeTest.assertInvalid("MetaCharset: empty encoding", validator, "text/html; charset=");
    }

    private static void testMetaCharsetLooping() {
        MetaCharset validator = MetaCharset.THE_INSTANCE;
        DatatypeTest.assertValid("MetaCharset: charset space charset=", validator, "text/html; charset charset=utf-8");
        DatatypeTest.assertValid("MetaCharset: charsetxxxxxcharset=", validator, "text/html; charsetxxxxxcharset=utf-8");
        DatatypeTest.assertValid("MetaCharset: charsetcharset=", validator, "text/html; charsetcharset=utf-8");
        DatatypeTest.assertValid("MetaCharset: charset without = then valid charset=", validator, "text/html; charsetfoo charset=utf-8");
        DatatypeTest.assertValid("MetaCharset: multiple invalid charsets then valid", validator, "text/html; charset; charset; charset=utf-8");
    }

    private static void testDateValid() {
        Date validator = Date.THE_INSTANCE;
        DatatypeTest.assertValid("Date: basic date", validator, "2024-01-15");
        DatatypeTest.assertValid("Date: first day of year", validator, "2024-01-01");
        DatatypeTest.assertValid("Date: last day of year", validator, "2024-12-31");
        DatatypeTest.assertValid("Date: leap year Feb 29", validator, "2024-02-29");
        DatatypeTest.assertValid("Date: year 1", validator, "0001-01-01");
        DatatypeTest.assertValid("Date: 5-digit year", validator, "10000-06-15");
        DatatypeTest.assertValid("Date: end of February non-leap", validator, "2023-02-28");
        DatatypeTest.assertValid("Date: April 30", validator, "2024-04-30");
        DatatypeTest.assertValid("Date: June 30", validator, "2024-06-30");
    }

    private static void testDateInvalid() {
        Date validator = Date.THE_INSTANCE;
        DatatypeTest.assertInvalid("Date: empty string", validator, "");
        DatatypeTest.assertInvalid("Date: invalid month 00", validator, "2024-00-15");
        DatatypeTest.assertInvalid("Date: invalid month 13", validator, "2024-13-15");
        DatatypeTest.assertInvalid("Date: invalid day 00", validator, "2024-01-00");
        DatatypeTest.assertInvalid("Date: invalid day 32", validator, "2024-01-32");
        DatatypeTest.assertInvalid("Date: Feb 30", validator, "2024-02-30");
        DatatypeTest.assertInvalid("Date: Feb 29 non-leap", validator, "2023-02-29");
        DatatypeTest.assertInvalid("Date: April 31", validator, "2024-04-31");
        DatatypeTest.assertInvalid("Date: June 31", validator, "2024-06-31");
        DatatypeTest.assertInvalid("Date: year 0", validator, "0000-01-01");
        DatatypeTest.assertInvalid("Date: 2-digit year", validator, "24-01-15");
        DatatypeTest.assertInvalid("Date: 3-digit year", validator, "124-01-15");
        DatatypeTest.assertInvalid("Date: single digit month", validator, "2024-1-15");
        DatatypeTest.assertInvalid("Date: single digit day", validator, "2024-01-5");
        DatatypeTest.assertInvalid("Date: slashes instead of dashes", validator, "2024/01/15");
        DatatypeTest.assertInvalid("Date: no separators", validator, "20240115");
        DatatypeTest.assertInvalid("Date: with time", validator, "2024-01-15T12:00");
    }

    private static void testMonthValid() {
        Month validator = Month.THE_INSTANCE;
        DatatypeTest.assertValid("Month: basic month", validator, "2024-01");
        DatatypeTest.assertValid("Month: first month", validator, "2024-01");
        DatatypeTest.assertValid("Month: last month", validator, "2024-12");
        DatatypeTest.assertValid("Month: year 1", validator, "0001-06");
        DatatypeTest.assertValid("Month: 5-digit year", validator, "10000-06");
    }

    private static void testMonthInvalid() {
        Month validator = Month.THE_INSTANCE;
        DatatypeTest.assertInvalid("Month: empty string", validator, "");
        DatatypeTest.assertInvalid("Month: invalid month 00", validator, "2024-00");
        DatatypeTest.assertInvalid("Month: invalid month 13", validator, "2024-13");
        DatatypeTest.assertInvalid("Month: year 0", validator, "0000-01");
        DatatypeTest.assertInvalid("Month: 2-digit year", validator, "24-01");
        DatatypeTest.assertInvalid("Month: single digit month", validator, "2024-1");
        DatatypeTest.assertInvalid("Month: with day", validator, "2024-01-15");
        DatatypeTest.assertInvalid("Month: no separator", validator, "202401");
    }

    private static void testWeekValid() {
        Week validator = Week.THE_INSTANCE;
        DatatypeTest.assertValid("Week: basic week", validator, "2024-W01");
        DatatypeTest.assertValid("Week: first week", validator, "2024-W01");
        DatatypeTest.assertValid("Week: week 52", validator, "2024-W52");
        DatatypeTest.assertValid("Week: week 53 in year with 53 weeks", validator, "2004-W53");
        DatatypeTest.assertValid("Week: week 53 in 2020", validator, "2020-W53");
        DatatypeTest.assertValid("Week: year 1", validator, "0001-W01");
        DatatypeTest.assertValid("Week: 5-digit year", validator, "10000-W26");
    }

    private static void testWeekInvalid() {
        Week validator = Week.THE_INSTANCE;
        DatatypeTest.assertInvalid("Week: empty string", validator, "");
        DatatypeTest.assertInvalid("Week: invalid week 00", validator, "2024-W00");
        DatatypeTest.assertInvalid("Week: invalid week 54", validator, "2024-W54");
        DatatypeTest.assertInvalid("Week: week 53 in year without 53 weeks", validator, "2023-W53");
        DatatypeTest.assertInvalid("Week: year 0", validator, "0000-W01");
        DatatypeTest.assertInvalid("Week: missing W prefix", validator, "2024-01");
        DatatypeTest.assertInvalid("Week: lowercase w", validator, "2024-w01");
        DatatypeTest.assertInvalid("Week: single digit week", validator, "2024-W1");
    }

    private static void testMimeTypeValid() {
        MimeType validator = MimeType.THE_INSTANCE;
        DatatypeTest.assertValid("MimeType: text/html", validator, "text/html");
        DatatypeTest.assertValid("MimeType: text/plain", validator, "text/plain");
        DatatypeTest.assertValid("MimeType: application/json", validator, "application/json");
        DatatypeTest.assertValid("MimeType: image/png", validator, "image/png");
        DatatypeTest.assertValid("MimeType: with charset param", validator, "text/html; charset=utf-8");
        DatatypeTest.assertValid("MimeType: with quoted param", validator, "text/html; charset=\"utf-8\"");
        DatatypeTest.assertValid("MimeType: multiple params", validator, "text/html; charset=utf-8; boundary=something");
        DatatypeTest.assertValid("MimeType: param with spaces", validator, "text/html ; charset=utf-8");
        DatatypeTest.assertValid("MimeType: vendor type", validator, "application/vnd.ms-excel");
        DatatypeTest.assertValid("MimeType: x- prefix", validator, "application/x-custom");
        DatatypeTest.assertValid("MimeType: with + suffix", validator, "application/atom+xml");
        DatatypeTest.assertValid("MimeType: multipart/form-data", validator, "multipart/form-data");
    }

    private static void testMimeTypeInvalid() {
        MimeType validator = MimeType.THE_INSTANCE;
        DatatypeTest.assertInvalid("MimeType: empty string", validator, "");
        DatatypeTest.assertInvalid("MimeType: no subtype", validator, "text");
        DatatypeTest.assertInvalid("MimeType: no subtype with slash", validator, "text/");
        DatatypeTest.assertInvalid("MimeType: no supertype", validator, "/html");
        DatatypeTest.assertInvalid("MimeType: just slash", validator, "/");
        DatatypeTest.assertInvalid("MimeType: trailing semicolon", validator, "text/html;");
        DatatypeTest.assertInvalid("MimeType: param without value", validator, "text/html; charset");
        DatatypeTest.assertInvalid("MimeType: param with = but no value", validator, "text/html; charset=");
        DatatypeTest.assertInvalid("MimeType: unclosed quote", validator, "text/html; charset=\"utf-8");
        DatatypeTest.assertInvalid("MimeType: trailing whitespace", validator, "text/html ");
    }

    private static void testIriRefValid() {
        Datatype validator;
        Html5DatatypeLibrary library = new Html5DatatypeLibrary();
        try {
            validator = library.createDatatype("iri-ref");
        }
        catch (DatatypeException e) {
            System.out.println("FAIL: Could not create iri-ref datatype: " + e.getMessage());
            ++failed;
            return;
        }
        DatatypeTest.assertValid("IriRef: http URL", validator, "http://example.com/");
        DatatypeTest.assertValid("IriRef: https URL", validator, "https://example.com/");
        DatatypeTest.assertValid("IriRef: http with port", validator, "http://example.com:8080/");
        DatatypeTest.assertValid("IriRef: http with path", validator, "http://example.com/path/to/file");
        DatatypeTest.assertValid("IriRef: http with query", validator, "http://example.com/?foo=bar");
        DatatypeTest.assertValid("IriRef: http with fragment", validator, "http://example.com/#section");
        DatatypeTest.assertInvalid("IriRef: http with credentials", validator, "http://user:pass@example.com:8080/path?q=1#frag");
        DatatypeTest.assertValid("IriRef: http with all parts", validator, "http://example.com:8080/path?q=1#frag");
        DatatypeTest.assertValid("IriRef: ftp URL", validator, "ftp://ftp.example.com/file");
        DatatypeTest.assertValid("IriRef: mailto URL", validator, "mailto:user@example.com");
        DatatypeTest.assertValid("IriRef: file URL", validator, "file:///path/to/file");
        DatatypeTest.assertValid("IriRef: relative path", validator, "path/to/file");
        DatatypeTest.assertValid("IriRef: absolute path", validator, "/path/to/file");
        DatatypeTest.assertValid("IriRef: fragment only", validator, "#section");
        DatatypeTest.assertValid("IriRef: query only", validator, "?query=value");
        DatatypeTest.assertValid("IriRef: relative with query", validator, "file.html?q=1");
        DatatypeTest.assertValid("IriRef: parent directory", validator, "../file.html");
        DatatypeTest.assertValid("IriRef: current directory", validator, "./file.html");
        DatatypeTest.assertValid("IriRef: data URL text", validator, "data:text/plain,Hello");
        DatatypeTest.assertValid("IriRef: data URL base64", validator, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNk+M9QDwADhgGAWjR9awAAAABJRU5ErkJggg==");
        DatatypeTest.assertValid("IriRef: javascript (allowed)", validator, "javascript:void(0)");
        DatatypeTest.assertValid("IriRef: webcal (http alias)", validator, "webcal://example.com/cal");
        DatatypeTest.assertValid("IriRef: feed (http alias)", validator, "feed://example.com/rss");
        DatatypeTest.assertValid("IriRef: unicode in path", validator, "http://example.com/caf%C3%A9");
        DatatypeTest.assertValid("IriRef: IDN domain", validator, "http://xn--nxasmq5b.com/");
    }

    private static void testIriRefInvalid() {
        Datatype validator;
        Html5DatatypeLibrary library = new Html5DatatypeLibrary();
        try {
            validator = library.createDatatype("iri-ref");
        }
        catch (DatatypeException e) {
            System.out.println("FAIL: Could not create iri-ref datatype: " + e.getMessage());
            ++failed;
            return;
        }
        DatatypeTest.assertInvalid("IriRef: empty string", validator, "");
        DatatypeTest.assertInvalid("IriRef: whitespace only", validator, "   ");
        DatatypeTest.assertInvalid("IriRef: tabs only", validator, "\t\t");
    }

    private static void testDatetimeValid() {
        Datetime validator = Datetime.THE_INSTANCE;
        DatatypeTest.assertValid("Datetime: basic with T and Z", validator, "2024-01-15T12:30Z");
        DatatypeTest.assertValid("Datetime: with seconds", validator, "2024-01-15T12:30:45Z");
        DatatypeTest.assertValid("Datetime: with milliseconds", validator, "2024-01-15T12:30:45.123Z");
        DatatypeTest.assertValid("Datetime: with 1 decimal", validator, "2024-01-15T12:30:45.1Z");
        DatatypeTest.assertValid("Datetime: with 2 decimals", validator, "2024-01-15T12:30:45.12Z");
        DatatypeTest.assertValid("Datetime: space instead of T", validator, "2024-01-15 12:30Z");
        DatatypeTest.assertValid("Datetime: space with seconds", validator, "2024-01-15 12:30:45Z");
        DatatypeTest.assertValid("Datetime: midnight", validator, "2024-01-15T00:00Z");
        DatatypeTest.assertValid("Datetime: end of day", validator, "2024-01-15T23:59Z");
        DatatypeTest.assertValid("Datetime: max seconds", validator, "2024-01-15T23:59:59Z");
        DatatypeTest.assertValid("Datetime: year 1", validator, "0001-01-01T00:00Z");
        DatatypeTest.assertValid("Datetime: 5-digit year", validator, "10000-06-15T12:00Z");
        DatatypeTest.assertValid("Datetime: leap year Feb 29", validator, "2024-02-29T12:00Z");
    }

    private static void testDatetimeInvalid() {
        Datetime validator = Datetime.THE_INSTANCE;
        DatatypeTest.assertInvalid("Datetime: empty string", validator, "");
        DatatypeTest.assertInvalid("Datetime: missing Z", validator, "2024-01-15T12:30");
        DatatypeTest.assertInvalid("Datetime: lowercase z", validator, "2024-01-15T12:30z");
        DatatypeTest.assertInvalid("Datetime: with timezone offset", validator, "2024-01-15T12:30+05:00");
        DatatypeTest.assertInvalid("Datetime: missing time", validator, "2024-01-15Z");
        DatatypeTest.assertInvalid("Datetime: date only", validator, "2024-01-15");
        DatatypeTest.assertInvalid("Datetime: invalid month 13", validator, "2024-13-15T12:00Z");
        DatatypeTest.assertInvalid("Datetime: year 0", validator, "0000-01-15T12:00Z");
        DatatypeTest.assertInvalid("Datetime: invalid hour 24", validator, "2024-01-15T24:00Z");
        DatatypeTest.assertInvalid("Datetime: invalid minute 60", validator, "2024-01-15T12:60Z");
        DatatypeTest.assertInvalid("Datetime: invalid second 60", validator, "2024-01-15T12:30:60Z");
        DatatypeTest.assertInvalid("Datetime: Feb 29 non-leap year", validator, "2023-02-29T12:00Z");
        DatatypeTest.assertInvalid("Datetime: invalid day 32", validator, "2024-01-32T12:00Z");
    }

    private static void testDatetimeLocalValid() {
        DatetimeLocal validator = DatetimeLocal.THE_INSTANCE;
        DatatypeTest.assertValid("DatetimeLocal: basic with T", validator, "2024-01-15T12:30");
        DatatypeTest.assertValid("DatetimeLocal: with seconds", validator, "2024-01-15T12:30:45");
        DatatypeTest.assertValid("DatetimeLocal: with milliseconds", validator, "2024-01-15T12:30:45.123");
        DatatypeTest.assertValid("DatetimeLocal: with 1 decimal", validator, "2024-01-15T12:30:45.1");
        DatatypeTest.assertValid("DatetimeLocal: with 2 decimals", validator, "2024-01-15T12:30:45.12");
        DatatypeTest.assertValid("DatetimeLocal: space instead of T", validator, "2024-01-15 12:30");
        DatatypeTest.assertValid("DatetimeLocal: space with seconds", validator, "2024-01-15 12:30:45");
        DatatypeTest.assertValid("DatetimeLocal: midnight", validator, "2024-01-15T00:00");
        DatatypeTest.assertValid("DatetimeLocal: end of day", validator, "2024-01-15T23:59:59");
        DatatypeTest.assertValid("DatetimeLocal: year 1", validator, "0001-01-01T00:00");
        DatatypeTest.assertValid("DatetimeLocal: 5-digit year", validator, "10000-06-15T12:00");
    }

    private static void testDatetimeLocalInvalid() {
        DatetimeLocal validator = DatetimeLocal.THE_INSTANCE;
        DatatypeTest.assertInvalid("DatetimeLocal: empty string", validator, "");
        DatatypeTest.assertInvalid("DatetimeLocal: with Z", validator, "2024-01-15T12:30Z");
        DatatypeTest.assertInvalid("DatetimeLocal: with timezone", validator, "2024-01-15T12:30+05:00");
        DatatypeTest.assertInvalid("DatetimeLocal: date only", validator, "2024-01-15");
        DatatypeTest.assertInvalid("DatetimeLocal: time only", validator, "12:30:45");
        DatatypeTest.assertInvalid("DatetimeLocal: year 0", validator, "0000-01-15T12:00");
        DatatypeTest.assertInvalid("DatetimeLocal: invalid hour 24", validator, "2024-01-15T24:00");
        DatatypeTest.assertInvalid("DatetimeLocal: invalid minute 60", validator, "2024-01-15T12:60");
        DatatypeTest.assertInvalid("DatetimeLocal: invalid second 60", validator, "2024-01-15T12:30:60");
        DatatypeTest.assertInvalid("DatetimeLocal: Feb 29 non-leap", validator, "2023-02-29T12:00");
        DatatypeTest.assertInvalid("DatetimeLocal: invalid day 32", validator, "2024-01-32T12:00");
    }

    private static void testDatetimeTzValid() {
        DatetimeTz validator = DatetimeTz.THE_INSTANCE;
        DatatypeTest.assertValid("DatetimeTz: with Z", validator, "2024-01-15T12:30:00Z");
        DatatypeTest.assertValid("DatetimeTz: with Z and milliseconds", validator, "2024-01-15T12:30:45.123Z");
        DatatypeTest.assertValid("DatetimeTz: without seconds", validator, "2024-01-15T12:30Z");
        DatatypeTest.assertValid("DatetimeTz: +00:00", validator, "2024-01-15T12:30:00+00:00");
        DatatypeTest.assertValid("DatetimeTz: +05:30", validator, "2024-01-15T12:30:00+05:30");
        DatatypeTest.assertValid("DatetimeTz: +12:00", validator, "2024-01-15T12:30:00+12:00");
        DatatypeTest.assertValid("DatetimeTz: +14:00", validator, "2024-01-15T12:30:00+14:00");
        DatatypeTest.assertValid("DatetimeTz: -05:00", validator, "2024-01-15T12:30:00-05:00");
        DatatypeTest.assertValid("DatetimeTz: -12:00", validator, "2024-01-15T12:30:00-12:00");
        DatatypeTest.assertValid("DatetimeTz: space instead of T", validator, "2024-01-15 12:30:00Z");
        DatatypeTest.assertValid("DatetimeTz: space with offset", validator, "2024-01-15 12:30:00+05:00");
        DatatypeTest.assertValid("DatetimeTz: offset without colon", validator, "2024-01-15T12:30:00+0530");
    }

    private static void testDatetimeTzInvalid() {
        DatetimeTz validator = DatetimeTz.THE_INSTANCE;
        DatatypeTest.assertInvalid("DatetimeTz: empty string", validator, "");
        DatatypeTest.assertInvalid("DatetimeTz: no timezone", validator, "2024-01-15T12:30:00");
        DatatypeTest.assertInvalid("DatetimeTz: date only", validator, "2024-01-15");
        DatatypeTest.assertInvalid("DatetimeTz: lowercase z", validator, "2024-01-15T12:30:00z");
        DatatypeTest.assertInvalid("DatetimeTz: -00:00 not allowed", validator, "2024-01-15T12:30:00-00:00");
        DatatypeTest.assertInvalid("DatetimeTz: year 0", validator, "0000-01-15T12:00:00Z");
    }

    private static void testDateOrTimeValid() {
        DateOrTime validator = DateOrTime.THE_INSTANCE;
        DatatypeTest.assertValid("DateOrTime: date only", validator, "2024-01-15");
        DatatypeTest.assertValid("DateOrTime: leap year Feb 29", validator, "2024-02-29");
        DatatypeTest.assertValid("DateOrTime: year 1", validator, "0001-01-01");
        DatatypeTest.assertValid("DateOrTime: 5-digit year", validator, "10000-06-15");
        DatatypeTest.assertValid("DateOrTime: time HH:MM", validator, "12:30");
        DatatypeTest.assertValid("DateOrTime: time with seconds", validator, "12:30:45");
        DatatypeTest.assertValid("DateOrTime: time with ms", validator, "12:30:45.123");
        DatatypeTest.assertValid("DateOrTime: midnight", validator, "00:00");
        DatatypeTest.assertValid("DateOrTime: end of day", validator, "23:59:59");
    }

    private static void testDateOrTimeInvalid() {
        DateOrTime validator = DateOrTime.THE_INSTANCE;
        DatatypeTest.assertInvalid("DateOrTime: empty string", validator, "");
        DatatypeTest.assertInvalid("DateOrTime: text", validator, "today");
        DatatypeTest.assertInvalid("DateOrTime: invalid month 13", validator, "2024-13-15");
        DatatypeTest.assertInvalid("DateOrTime: invalid day 32", validator, "2024-01-32");
        DatatypeTest.assertInvalid("DateOrTime: Feb 29 non-leap", validator, "2023-02-29");
        DatatypeTest.assertInvalid("DateOrTime: year 0", validator, "0000-01-15");
        DatatypeTest.assertInvalid("DateOrTime: invalid hour 24", validator, "24:00");
        DatatypeTest.assertInvalid("DateOrTime: invalid minute 60", validator, "12:60");
        DatatypeTest.assertInvalid("DateOrTime: invalid second 60", validator, "12:30:60");
    }

    private static void testTimeDatetimeValid() {
        TimeDatetime validator = TimeDatetime.THE_INSTANCE;
        DatatypeTest.assertValid("TimeDatetime: month string", validator, "2024-06");
        DatatypeTest.assertValid("TimeDatetime: date string", validator, "2024-06-15");
        DatatypeTest.assertValid("TimeDatetime: yearless date", validator, "06-15");
        DatatypeTest.assertValid("TimeDatetime: time HH:MM", validator, "12:30");
        DatatypeTest.assertValid("TimeDatetime: time with seconds", validator, "12:30:45");
        DatatypeTest.assertValid("TimeDatetime: time with ms", validator, "12:30:45.123");
        DatatypeTest.assertValid("TimeDatetime: local datetime", validator, "2024-06-15T12:30");
        DatatypeTest.assertValid("TimeDatetime: local datetime space", validator, "2024-06-15 12:30");
        DatatypeTest.assertValid("TimeDatetime: timezone Z", validator, "Z");
        DatatypeTest.assertValid("TimeDatetime: timezone +05:30", validator, "+05:30");
        DatatypeTest.assertValid("TimeDatetime: timezone -08:00", validator, "-08:00");
        DatatypeTest.assertValid("TimeDatetime: global datetime Z", validator, "2024-06-15T12:30:00Z");
        DatatypeTest.assertValid("TimeDatetime: global datetime offset", validator, "2024-06-15T12:30:00+05:00");
        DatatypeTest.assertValid("TimeDatetime: week string", validator, "2024-W26");
        DatatypeTest.assertValid("TimeDatetime: year string", validator, "2024");
        DatatypeTest.assertValid("TimeDatetime: duration days", validator, "P5D");
        DatatypeTest.assertValid("TimeDatetime: duration hours", validator, "PT2H");
        DatatypeTest.assertValid("TimeDatetime: duration minutes", validator, "PT30M");
        DatatypeTest.assertValid("TimeDatetime: duration seconds", validator, "PT45S");
        DatatypeTest.assertValid("TimeDatetime: duration complex", validator, "P1DT2H30M45S");
        DatatypeTest.assertValid("TimeDatetime: duration with ms", validator, "PT45.5S");
        DatatypeTest.assertValid("TimeDatetime: duration 5d", validator, "5d");
        DatatypeTest.assertValid("TimeDatetime: duration 2h", validator, "2h");
        DatatypeTest.assertValid("TimeDatetime: duration 30m", validator, "30m");
        DatatypeTest.assertValid("TimeDatetime: duration 45s", validator, "45s");
        DatatypeTest.assertValid("TimeDatetime: duration 5w", validator, "5w");
        DatatypeTest.assertValid("TimeDatetime: leading space", validator, "  2024-06-15");
        DatatypeTest.assertValid("TimeDatetime: trailing space", validator, "2024-06-15  ");
        DatatypeTest.assertValid("TimeDatetime: both whitespace", validator, "  12:30  ");
    }

    private static void testTimeDatetimeInvalid() {
        TimeDatetime validator = TimeDatetime.THE_INSTANCE;
        DatatypeTest.assertInvalid("TimeDatetime: empty string", validator, "");
        DatatypeTest.assertInvalid("TimeDatetime: whitespace only", validator, "   ");
        DatatypeTest.assertInvalid("TimeDatetime: invalid month 13", validator, "2024-13");
        DatatypeTest.assertInvalid("TimeDatetime: invalid month 00", validator, "2024-00");
        DatatypeTest.assertInvalid("TimeDatetime: invalid day 32", validator, "2024-01-32");
        DatatypeTest.assertInvalid("TimeDatetime: invalid hour 24", validator, "24:00");
        DatatypeTest.assertInvalid("TimeDatetime: invalid minute 60", validator, "12:60");
        DatatypeTest.assertInvalid("TimeDatetime: invalid week 00", validator, "2024-W00");
        DatatypeTest.assertInvalid("TimeDatetime: invalid week 54", validator, "2024-W54");
        DatatypeTest.assertInvalid("TimeDatetime: text", validator, "yesterday");
        DatatypeTest.assertInvalid("TimeDatetime: invalid duration", validator, "P");
        DatatypeTest.assertInvalid("TimeDatetime: year 0", validator, "0000");
    }

    private static void testIntNonNegativeValid() {
        IntNonNegative validator = IntNonNegative.THE_INSTANCE;
        DatatypeTest.assertValid("IntNonNegative: zero", validator, "0");
        DatatypeTest.assertValid("IntNonNegative: single digit", validator, "5");
        DatatypeTest.assertValid("IntNonNegative: double digit", validator, "42");
        DatatypeTest.assertValid("IntNonNegative: large number", validator, "123456789");
        DatatypeTest.assertValid("IntNonNegative: leading zeros", validator, "007");
        DatatypeTest.assertValid("IntNonNegative: all zeros", validator, "000");
    }

    private static void testIntNonNegativeInvalid() {
        IntNonNegative validator = IntNonNegative.THE_INSTANCE;
        DatatypeTest.assertInvalid("IntNonNegative: empty string", validator, "");
        DatatypeTest.assertInvalid("IntNonNegative: negative", validator, "-1");
        DatatypeTest.assertInvalid("IntNonNegative: negative zero", validator, "-0");
        DatatypeTest.assertInvalid("IntNonNegative: decimal", validator, "1.5");
        DatatypeTest.assertInvalid("IntNonNegative: letter", validator, "a");
        DatatypeTest.assertInvalid("IntNonNegative: mixed", validator, "12a");
        DatatypeTest.assertInvalid("IntNonNegative: whitespace", validator, " 1");
        DatatypeTest.assertInvalid("IntNonNegative: plus sign", validator, "+1");
    }

    private static void testIntPositiveValid() {
        IntPositive validator = IntPositive.THE_INSTANCE;
        DatatypeTest.assertValid("IntPositive: single digit", validator, "1");
        DatatypeTest.assertValid("IntPositive: double digit", validator, "42");
        DatatypeTest.assertValid("IntPositive: large number", validator, "123456789");
        DatatypeTest.assertValid("IntPositive: leading zeros then digit", validator, "007");
        DatatypeTest.assertValid("IntPositive: leading zeros then non-zero", validator, "001");
    }

    private static void testIntPositiveInvalid() {
        IntPositive validator = IntPositive.THE_INSTANCE;
        DatatypeTest.assertInvalid("IntPositive: empty string", validator, "");
        DatatypeTest.assertInvalid("IntPositive: zero", validator, "0");
        DatatypeTest.assertInvalid("IntPositive: all zeros", validator, "000");
        DatatypeTest.assertInvalid("IntPositive: negative", validator, "-1");
        DatatypeTest.assertInvalid("IntPositive: decimal", validator, "1.5");
        DatatypeTest.assertInvalid("IntPositive: letter", validator, "a");
        DatatypeTest.assertInvalid("IntPositive: plus sign", validator, "+1");
    }

    private static void testZeroValid() {
        Zero validator = Zero.THE_INSTANCE;
        DatatypeTest.assertValid("Zero: just zero", validator, "0");
    }

    private static void testZeroInvalid() {
        Zero validator = Zero.THE_INSTANCE;
        DatatypeTest.assertInvalid("Zero: empty string", validator, "");
        DatatypeTest.assertInvalid("Zero: one", validator, "1");
        DatatypeTest.assertInvalid("Zero: double zero", validator, "00");
        DatatypeTest.assertInvalid("Zero: negative zero", validator, "-0");
        DatatypeTest.assertInvalid("Zero: zero with space", validator, " 0");
        DatatypeTest.assertInvalid("Zero: letter o", validator, "o");
        DatatypeTest.assertInvalid("Zero: O letter", validator, "O");
    }

    private static void testFloatingPointExponentValid() {
        FloatingPointExponent validator = FloatingPointExponent.THE_INSTANCE;
        DatatypeTest.assertValid("FloatingPoint: zero", validator, "0");
        DatatypeTest.assertValid("FloatingPoint: positive integer", validator, "123");
        DatatypeTest.assertValid("FloatingPoint: negative integer", validator, "-456");
        DatatypeTest.assertValid("FloatingPoint: decimal", validator, "3.14");
        DatatypeTest.assertValid("FloatingPoint: negative decimal", validator, "-3.14");
        DatatypeTest.assertValid("FloatingPoint: leading zero decimal", validator, "0.5");
        DatatypeTest.assertValid("FloatingPoint: small decimal", validator, ".5");
        DatatypeTest.assertValid("FloatingPoint: with e", validator, "1e10");
        DatatypeTest.assertValid("FloatingPoint: with E", validator, "1E10");
        DatatypeTest.assertValid("FloatingPoint: with positive exponent", validator, "1e+10");
        DatatypeTest.assertValid("FloatingPoint: with negative exponent", validator, "1e-10");
        DatatypeTest.assertValid("FloatingPoint: decimal with exponent", validator, "3.14e5");
        DatatypeTest.assertValid("FloatingPoint: negative with exponent", validator, "-2.5e3");
        DatatypeTest.assertValid("FloatingPoint: scientific notation", validator, "6.022e23");
        DatatypeTest.assertValid("FloatingPoint: very small", validator, "1e-100");
    }

    private static void testFloatingPointExponentInvalid() {
        FloatingPointExponent validator = FloatingPointExponent.THE_INSTANCE;
        DatatypeTest.assertInvalid("FloatingPoint: empty string", validator, "");
        DatatypeTest.assertInvalid("FloatingPoint: just minus", validator, "-");
        DatatypeTest.assertInvalid("FloatingPoint: just dot", validator, ".");
        DatatypeTest.assertInvalid("FloatingPoint: trailing dot", validator, "1.");
        DatatypeTest.assertInvalid("FloatingPoint: just e", validator, "e");
        DatatypeTest.assertInvalid("FloatingPoint: e at start", validator, "e5");
        DatatypeTest.assertInvalid("FloatingPoint: trailing e", validator, "1e");
        DatatypeTest.assertInvalid("FloatingPoint: e with just sign", validator, "1e+");
        DatatypeTest.assertInvalid("FloatingPoint: double dot", validator, "1..2");
        DatatypeTest.assertInvalid("FloatingPoint: double e", validator, "1e2e3");
        DatatypeTest.assertInvalid("FloatingPoint: letter", validator, "abc");
        DatatypeTest.assertInvalid("FloatingPoint: hex", validator, "0x1f");
        DatatypeTest.assertInvalid("FloatingPoint: comma decimal", validator, "1,5");
    }

    private static void testIdrefValid() {
        Idref validator = Idref.THE_INSTANCE;
        DatatypeTest.assertValid("Idref: single char", validator, "a");
        DatatypeTest.assertValid("Idref: simple id", validator, "myId");
        DatatypeTest.assertValid("Idref: with hyphen", validator, "my-id");
        DatatypeTest.assertValid("Idref: with numbers", validator, "id123");
        DatatypeTest.assertValid("Idref: starting with number", validator, "123");
        DatatypeTest.assertValid("Idref: unicode", validator, "\u00e9l\u00e8ve");
    }

    private static void testIdrefInvalid() {
        Idref validator = Idref.THE_INSTANCE;
        DatatypeTest.assertInvalid("Idref: empty string", validator, "");
        DatatypeTest.assertInvalid("Idref: single space", validator, " ");
        DatatypeTest.assertInvalid("Idref: leading space", validator, " id");
        DatatypeTest.assertInvalid("Idref: trailing space", validator, "id ");
        DatatypeTest.assertInvalid("Idref: space in middle", validator, "my id");
        DatatypeTest.assertInvalid("Idref: tab", validator, "my\tid");
        DatatypeTest.assertInvalid("Idref: newline", validator, "my\nid");
    }

    private static void testIdrefsValid() {
        Idrefs validator = Idrefs.THE_INSTANCE;
        DatatypeTest.assertValid("Idrefs: single id", validator, "myId");
        DatatypeTest.assertValid("Idrefs: multiple ids", validator, "id1 id2 id3");
        DatatypeTest.assertValid("Idrefs: single non-whitespace char", validator, "a");
        DatatypeTest.assertValid("Idrefs: with leading whitespace", validator, " id");
        DatatypeTest.assertValid("Idrefs: with trailing whitespace", validator, "id ");
        DatatypeTest.assertValid("Idrefs: mixed whitespace and ids", validator, "  id1  id2  ");
    }

    private static void testIdrefsInvalid() {
        Idrefs validator = Idrefs.THE_INSTANCE;
        DatatypeTest.assertInvalid("Idrefs: empty string", validator, "");
        DatatypeTest.assertInvalid("Idrefs: just space", validator, " ");
        DatatypeTest.assertInvalid("Idrefs: multiple spaces", validator, "   ");
        DatatypeTest.assertInvalid("Idrefs: just tab", validator, "\t");
        DatatypeTest.assertInvalid("Idrefs: just newline", validator, "\n");
        DatatypeTest.assertInvalid("Idrefs: mixed whitespace only", validator, " \t\n ");
    }

    private static void testLanguageValid() {
        Language validator = Language.THE_INSTANCE;
        DatatypeTest.assertValid("Language: English", validator, "en");
        DatatypeTest.assertValid("Language: French", validator, "fr");
        DatatypeTest.assertValid("Language: German", validator, "de");
        DatatypeTest.assertValid("Language: Japanese", validator, "ja");
        DatatypeTest.assertValid("Language: Chinese", validator, "zh");
        DatatypeTest.assertValid("Language: US English", validator, "en-US");
        DatatypeTest.assertValid("Language: British English", validator, "en-GB");
        DatatypeTest.assertValid("Language: Brazilian Portuguese", validator, "pt-BR");
        DatatypeTest.assertValid("Language: Swiss German", validator, "de-CH");
        DatatypeTest.assertValid("Language: Simplified Chinese", validator, "zh-Hans");
        DatatypeTest.assertValid("Language: Traditional Chinese", validator, "zh-Hant");
        DatatypeTest.assertValid("Language: Serbian Latin", validator, "sr-Latn");
        DatatypeTest.assertValid("Language: Chinese Taiwan Traditional", validator, "zh-Hant-TW");
        DatatypeTest.assertValid("Language: private use", validator, "x-private");
        DatatypeTest.assertValid("Language: with private extension", validator, "en-x-custom");
        DatatypeTest.assertValid("Language: uppercase", validator, "EN");
        DatatypeTest.assertValid("Language: mixed case", validator, "En-Us");
    }

    private static void testLanguageInvalid() {
        Language validator = Language.THE_INSTANCE;
        DatatypeTest.assertInvalid("Language: empty string", validator, "");
        DatatypeTest.assertInvalid("Language: leading hyphen", validator, "-en");
        DatatypeTest.assertInvalid("Language: trailing hyphen", validator, "en-");
        DatatypeTest.assertInvalid("Language: double hyphen", validator, "en--US");
        DatatypeTest.assertInvalid("Language: single letter", validator, "e");
        DatatypeTest.assertInvalid("Language: too long subtag", validator, "en-abcdefghi");
        DatatypeTest.assertInvalid("Language: invalid language", validator, "xx");
        DatatypeTest.assertInvalid("Language: reserved 4-letter", validator, "abcd");
        DatatypeTest.assertInvalid("Language: just x", validator, "x");
        DatatypeTest.assertInvalid("Language: x- too short", validator, "x-a");
    }

    private static void assertValid(String testName, Datatype validator, String value) {
        try {
            validator.checkValid(value, null);
            DatatypeTest.pass(testName);
        }
        catch (DatatypeException e) {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: valid");
            System.out.println("  Got exception: " + e.getMessage());
            ++failed;
        }
    }

    private static void assertInvalid(String testName, Datatype validator, String value) {
        try {
            validator.checkValid(value, null);
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: invalid (exception)");
            System.out.println("  Got: valid (no exception)");
            ++failed;
        }
        catch (DatatypeException e) {
            DatatypeTest.pass(testName);
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }
}

