/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public final class Week
extends AbstractDatatype {
    private static final int[] SPECIAL_YEARS = new int[]{4, 9, 15, 20, 26, 32, 37, 43, 48, 54, 60, 65, 71, 76, 82, 88, 93, 99, 105, 111, 116, 122, 128, 133, 139, 144, 150, 156, 161, 167, 172, 178, 184, 189, 195, 201, 207, 212, 218, 224, 229, 235, 240, 246, 252, 257, 263, 268, 274, 280, 285, 291, 296, 303, 308, 314, 320, 325, 331, 336, 342, 348, 353, 359, 364, 370, 376, 381, 387, 392, 398};
    public static final Week THE_INSTANCE = new Week();
    private static final Pattern THE_PATTERN = Pattern.compile("^([0-9]{4,})-W([0-9]{2})$");

    private Week() {
    }

    private void checkWeek(String year, String week) throws DatatypeException {
        this.checkWeek(Integer.parseInt(year), Integer.parseInt(week));
    }

    private void checkWeek(int year, int week) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (week < 1) {
            throw this.newDatatypeException("Week cannot be less than 1.");
        }
        if (week == 53 ? Arrays.binarySearch(SPECIAL_YEARS, year % 400) < 0 : week > 53) {
            throw this.newDatatypeException("Week out of range.");
        }
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        Matcher m = THE_PATTERN.matcher(literal);
        if (!m.matches()) {
            throw this.newDatatypeException("The literal did not satisfy the format for week.");
        }
        this.checkWeek(m.group(1), m.group(2));
    }

    @Override
    public String getName() {
        return "week";
    }
}

