/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.io.IOException;
import java.io.StringReader;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public class SvgPathData
extends AbstractDatatype {
    private static final int MAX_CONTEXT_LENGTH = 20;

    protected SvgPathData() {
    }

    private State appendToContext(State state) {
        if (state.current != -1) {
            if (state.context.length() == 20) {
                state.context.deleteCharAt(0);
            }
            state.context.append((char)state.current);
        }
        return state;
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state;
        block33: {
            StringReader reader = new StringReader(literal.toString());
            StringBuffer context = new StringBuffer(20);
            boolean skipped = false;
            try {
                int current = reader.read();
                state = this.appendToContext(new State(current, context, reader, skipped));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                while (true) {
                    switch (state.current) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            state.current = state.reader.read();
                            state = this.appendToContext(state);
                            break;
                        }
                        case 90: 
                        case 122: {
                            state.current = state.reader.read();
                            state = this.appendToContext(state);
                            break;
                        }
                        case 109: {
                            state = this.checkm(state);
                            break;
                        }
                        case 77: {
                            state = this.checkM(state);
                            break;
                        }
                        case 108: {
                            state = this.checkl(state);
                            break;
                        }
                        case 76: {
                            state = this.checkL(state);
                            break;
                        }
                        case 104: {
                            state = this.checkh(state);
                            break;
                        }
                        case 72: {
                            state = this.checkH(state);
                            break;
                        }
                        case 118: {
                            state = this.checkv(state);
                            break;
                        }
                        case 86: {
                            state = this.checkV(state);
                            break;
                        }
                        case 99: {
                            state = this.checkc(state);
                            break;
                        }
                        case 67: {
                            state = this.checkC(state);
                            break;
                        }
                        case 113: {
                            state = this.checkq(state);
                            break;
                        }
                        case 81: {
                            state = this.checkQ(state);
                            break;
                        }
                        case 115: {
                            state = this.checks(state);
                            break;
                        }
                        case 83: {
                            state = this.checkS(state);
                            break;
                        }
                        case 116: {
                            state = this.checkt(state);
                            break;
                        }
                        case 84: {
                            state = this.checkT(state);
                            break;
                        }
                        case 97: {
                            state = this.checka(state);
                            break;
                        }
                        case 65: {
                            state = this.checkA(state);
                            break;
                        }
                        case -1: {
                            break block33;
                        }
                        default: {
                            throw this.newDatatypeException("Expected command but found \u201c" + (char)state.current + "\u201d (context: \u201c" + state.context.toString() + "\u201d).");
                        }
                    }
                }
            }
            catch (IOException e) {
                try {
                    state = this.skipSubPath(state);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                throw new RuntimeException(e);
            }
        }
        try {
            state = this.skipSpaces(state);
            if (state.current != -1) {
                throw this.newDatatypeException("Found unexpected character \u201c" + (char)state.current + "\u201d.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private State checkm(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        state = this.checkArg('m', "x coordinate", state);
        state = this.skipCommaSpaces(state);
        state = this.checkArg('m', "y coordinate", state);
        state = this.skipCommaSpaces2(state);
        boolean expectNumber = state.skipped;
        this._checkl('m', expectNumber, state);
        return state;
    }

    private State checkM(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        state = this.checkArg('M', "x coordinate", state);
        state = this.skipCommaSpaces(state);
        state = this.checkArg('M', "y coordinate", state);
        state = this.skipCommaSpaces2(state);
        boolean expectNumber = state.skipped;
        this._checkL('M', expectNumber, state);
        return state;
    }

    private State checkl(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        this._checkl('l', true, state);
        return state;
    }

    private State _checkl(char command, boolean expectNumber, State state) throws IOException, DatatypeException {
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportUnexpected("coordinate pair for \u201c" + command + "\u201d command", state.current, state.context);
                        state = this.skipSubPath(state);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg(command, "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg(command, "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkL(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        this._checkL('L', true, state);
        return state;
    }

    private State _checkL(char command, boolean expectNumber, State state) throws IOException, DatatypeException {
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportUnexpected("coordinate pair for \u201c" + command + "\u201d command", state.current, state.context);
                        state = this.skipSubPath(state);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg(command, "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg(command, "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkh(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('h', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('h', "x coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkH(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('H', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('H', "x coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkv(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('v', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('v', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkV(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('V', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('V', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkc(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('c', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('c', "x1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('c', "y1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('c', "x2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('c', "y2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('c', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('c', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkC(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('C', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('C', "x1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('C', "y1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('C', "x2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('C', "y2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('C', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('C', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkq(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('q', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('q', "x1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('q', "y1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('q', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('q', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkQ(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('Q', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('Q', "x1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('Q', "y1 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('Q', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('Q', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checks(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('s', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('s', "x2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('s', "y2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('s', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('s', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkS(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('S', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('S', "x2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('S', "y2 coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('S', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('S', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkt(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('t', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('t', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('t', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkT(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('T', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('T', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('T', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checka(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('a', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('a', "rx radius", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('a', "ry radius", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('a', "x-axis-rotation", state);
            state = this.skipCommaSpaces(state);
            switch (state.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for large-arc-flag for \u201ca\u201d command", state.current, state.context);
                    state = this.skipSubPath(state);
                    return state;
                }
                case 48: 
                case 49: 
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
            state = this.skipCommaSpaces(state);
            switch (state.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for sweep-flag for \u201ca\u201d command", state.current, state.context);
                    state = this.skipSubPath(state);
                    return state;
                }
                case 48: 
                case 49: 
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('a', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('a', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkA(State state) throws DatatypeException, IOException {
        if (state.context.length() == 0) {
            state = this.appendToContext(state);
        }
        state.current = state.reader.read();
        state = this.appendToContext(state);
        state = this.skipSpaces(state);
        boolean expectNumber = true;
        while (true) {
            switch (state.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('A', state.current, state.context);
                    }
                    return state;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            state = this.checkArg('A', "rx radius", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('A', "ry radius", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('A', "x-axis-rotation", state);
            state = this.skipCommaSpaces(state);
            switch (state.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for large-arc-flag for \u201cA\u201d command", state.current, state.context);
                    state = this.skipSubPath(state);
                    return state;
                }
                case 48: 
                case 49: 
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
            state = this.skipCommaSpaces(state);
            switch (state.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for sweep-flag for \u201cA\u201d command", state.current, state.context);
                    state = this.skipSubPath(state);
                    return state;
                }
                case 48: 
                case 49: 
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('A', "x coordinate", state);
            state = this.skipCommaSpaces(state);
            state = this.checkArg('A', "y coordinate", state);
            state = this.skipCommaSpaces2(state);
            expectNumber = state.skipped;
        }
    }

    private State checkArg(char command, String arg, State state) throws DatatypeException, IOException {
        int mant = 0;
        int mantDig = 0;
        boolean mantPos = true;
        boolean mantRead = false;
        int exp = 0;
        int expDig = 0;
        int expAdj = 0;
        boolean expPos = true;
        switch (state.current) {
            case 45: {
                mantPos = false;
            }
            case 43: {
                state.current = state.reader.read();
                state = this.appendToContext(state);
            }
        }
        block4 : switch (state.current) {
            default: {
                this.reportUnexpected(arg + " for \u201c" + command + "\u201d command", state.current, state.context);
                state = this.skipSubPath(state);
                return state;
            }
            case 46: {
                break;
            }
            case 48: {
                mantRead = true;
                block50: while (true) {
                    state.current = state.reader.read();
                    state = this.appendToContext(state);
                    switch (state.current) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break block50;
                        }
                        case 46: 
                        case 69: 
                        case 101: {
                            break block4;
                        }
                        default: {
                            return state;
                        }
                        case 48: {
                            continue block50;
                        }
                    }
                    break;
                }
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                mantRead = true;
                while (true) {
                    if (mantDig < 9) {
                        ++mantDig;
                        mant = mant * 10 + (state.current - 48);
                    } else {
                        ++expAdj;
                    }
                    state.current = state.reader.read();
                    state = this.appendToContext(state);
                    switch (state.current) {
                        default: {
                            break block4;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                    }
                }
            }
        }
        if (state.current == 46) {
            state.current = state.reader.read();
            state = this.appendToContext(state);
            block17 : switch (state.current) {
                default: {
                    if (mantRead) break;
                    this.reportNonNumber(command, state.current, state.context);
                    return state;
                }
                case 48: {
                    if (mantDig == 0) {
                        block52: while (true) {
                            state.current = state.reader.read();
                            state = this.appendToContext(state);
                            --expAdj;
                            switch (state.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block52;
                                }
                                default: {
                                    if (mantRead) break block17;
                                    return state;
                                }
                                case 48: {
                                    continue block52;
                                }
                            }
                            break;
                        }
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (state.current - 48);
                            --expAdj;
                        }
                        state.current = state.reader.read();
                        state = this.appendToContext(state);
                        switch (state.current) {
                            default: {
                                break block17;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                }
            }
        }
        block28 : switch (state.current) {
            case 69: 
            case 101: {
                state.current = state.reader.read();
                state = this.appendToContext(state);
                switch (state.current) {
                    default: {
                        this.reportNonNumber(command, state.current, state.context);
                        return state;
                    }
                    case 45: {
                        expPos = false;
                    }
                    case 43: {
                        state.current = state.reader.read();
                        state = this.appendToContext(state);
                        switch (state.current) {
                            default: {
                                this.reportNonNumber(command, state.current, state.context);
                                return state;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                }
                switch (state.current) {
                    case 48: {
                        block54: while (true) {
                            state.current = state.reader.read();
                            state = this.appendToContext(state);
                            switch (state.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block54;
                                }
                                default: {
                                    break block28;
                                }
                                case 48: {
                                    continue block54;
                                }
                            }
                            break;
                        }
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        while (true) {
                            if (expDig < 3) {
                                ++expDig;
                                exp = exp * 10 + (state.current - 48);
                            }
                            state.current = state.reader.read();
                            state = this.appendToContext(state);
                            switch (state.current) {
                                default: {
                                    break block28;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                            }
                        }
                    }
                }
            }
        }
        if (!expPos) {
            exp = -exp;
        }
        exp += expAdj;
        if (!mantPos) {
            mant = -mant;
        }
        return state;
    }

    private State skipSubPath(State state) throws IOException {
        while (true) {
            switch (state.current) {
                case -1: 
                case 77: 
                case 109: {
                    return state;
                }
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
        }
    }

    private State skipSpaces(State state) throws IOException {
        while (true) {
            switch (state.current) {
                default: {
                    return state;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            state.current = state.reader.read();
            state = this.appendToContext(state);
        }
    }

    private State skipCommaSpaces(State state) throws IOException {
        block6: while (true) {
            switch (state.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    state.current = state.reader.read();
                    state = this.appendToContext(state);
                    continue block6;
                }
            }
            break;
        }
        if (state.current == 44) {
            block7: while (true) {
                state.current = state.reader.read();
                switch (state.current) {
                    default: {
                        state = this.appendToContext(state);
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        state = this.appendToContext(state);
                        continue block7;
                    }
                }
                break;
            }
        }
        return state;
    }

    private State skipCommaSpaces2(State state) throws IOException {
        block6: while (true) {
            switch (state.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    state.current = state.reader.read();
                    state = this.appendToContext(state);
                    continue block6;
                }
            }
            break;
        }
        if (state.current != 44) {
            state.skipped = false;
            return state;
        }
        block7: while (true) {
            state.current = state.reader.read();
            switch (state.current) {
                default: {
                    state = this.appendToContext(state);
                    break block7;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    state = this.appendToContext(state);
                    continue block7;
                }
            }
            break;
        }
        state.skipped = true;
        return state;
    }

    private void reportUnexpected(String expected, int ch, StringBuffer context) throws DatatypeException {
        if (ch != -1) {
            throw this.newDatatypeException("Expected " + expected + " but found \u201c" + (char)ch + "\u201d instead (context: \u201c" + context.toString() + "\u201d).");
        }
        throw this.newDatatypeException("Expected " + expected + " but value ended (context: \u201c" + context.toString() + "\u201d).");
    }

    private void reportNonNumber(char command, int ch, StringBuffer context) throws DatatypeException {
        if (ch != -1) {
            throw this.newDatatypeException("Expected number for \u201c" + command + "\u201d command but found \u201c" + (char)ch + "\u201d instead (context: \u201c" + context.toString() + "\u201d).");
        }
        throw this.newDatatypeException("Expected number for \u201c" + command + "\u201d command but value ended (context: \u201c" + context.toString() + "\u201d).");
    }

    @Override
    public String getName() {
        return "SVG path data";
    }

    private class State {
        int current;
        StringBuffer context;
        StringReader reader;
        boolean skipped;

        State(int current, StringBuffer context, StringReader reader, boolean skipped) {
            this.current = current;
            this.context = context;
            this.reader = reader;
            this.skipped = skipped;
        }
    }
}

