/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.io.StringReader;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.util.ApplContext;

public class MediaQuery
extends AbstractDatatype {
    public static final MediaQuery THE_INSTANCE = new MediaQuery();

    protected MediaQuery() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        ApplContext ac = new ApplContext("en");
        ac.setCssVersionAndProfile("css3svg");
        ac.setMedium("all");
        ac.setSuggestPropertyName(false);
        ac.setTreatVendorExtensionsAsWarnings(true);
        ac.setTreatCssHacksAsWarnings(true);
        ac.setWarningLevel(-1);
        ac.setFakeURL("file://localhost/StyleElement");
        String literalString = literal.toString();
        String style = this.isMediaCondition() ? String.format("@media all and %s %s", literalString, "{}") : String.format("@media %s %s", literalString, "{}");
        StyleSheetParser styleSheetParser = new StyleSheetParser(ac);
        styleSheetParser.parseStyleSheet(ac, new StringReader(style), null);
        styleSheetParser.getStyleSheet().findConflicts(ac);
        Errors errors = styleSheetParser.getStyleSheet().getErrors();
        for (int i = 0; i < errors.getErrorCount(); ++i) {
            Object message = "";
            String cssProperty = "";
            String cssMessage = "";
            CssError error = errors.getErrorAt(i);
            Throwable ex = error.getException();
            if (ex instanceof CssParseException) {
                CssParseException cpe = (CssParseException)ex;
                if ("generator.unrecognize".equals(cpe.getErrorType())) {
                    cssMessage = "Parse Error";
                }
                if (cpe.getProperty() != null) {
                    cssProperty = String.format("\u201c%s\u201d: ", cpe.getProperty());
                }
                if (cpe.getMessage() != null) {
                    cssMessage = cpe.getMessage();
                }
                if (!"".equals(cssMessage)) {
                    message = cssProperty + cssMessage + ".";
                }
            } else {
                message = ex.getMessage();
            }
            if ("".equals(message)) continue;
            throw this.newDatatypeException((String)message);
        }
    }

    protected boolean isMediaCondition() {
        return false;
    }

    @Override
    public String getName() {
        return "media query";
    }
}

