/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public final class FloatingPointExponentNonNegative
extends AbstractDatatype {
    public static final FloatingPointExponentNonNegative THE_INSTANCE = new FloatingPointExponentNonNegative();

    private FloatingPointExponentNonNegative() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        block21: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (c == '-') {
                        state = State.AT_START_MINUS_SEEN;
                        continue block21;
                    }
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block21;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign or a digit but saw ", c, " instead.");
                }
                case 1: {
                    if (c == '0') {
                        state = State.IN_INTEGER_PART_DIGITS_SEEN_ZERO;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a zero but saw ", c, " instead.");
                }
                case 2: {
                    if (c == '.') {
                        state = State.DOT_SEEN;
                        continue block21;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block21;
                    }
                    if (this.isAsciiDigit(c)) continue block21;
                    throw this.newDatatypeException(i, "Expected a decimal point, \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case 3: {
                    if (c == '.') {
                        state = State.DOT_SEEN_ZERO;
                        continue block21;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block21;
                    }
                    if (c == '0') continue block21;
                    throw this.newDatatypeException(i, "Expected a decimal point, \u201ce\u201d, \u201cE\u201d or a zero but saw ", c, " instead.");
                }
                case 4: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_DECIMAL_PART_DIGITS_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a digit after the decimal point but saw ", c, " instead.");
                }
                case 5: {
                    if (c == '0') {
                        state = State.IN_DECIMAL_PART_DIGITS_SEEN_ZERO;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a zero after the decimal point but saw ", c, " instead.");
                }
                case 7: {
                    if (this.isAsciiDigit(c)) continue block21;
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected \u201ce\u201d, \u201cE\u201d or a digit but saw ", c, " instead.");
                }
                case 8: {
                    if (c == '0') continue block21;
                    if (c == 'e' || c == 'E') {
                        state = State.E_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected \u201ce\u201d, \u201cE\u201d or a zero but saw ", c, " instead.");
                }
                case 6: {
                    if (c == '-' || c == '+') {
                        state = State.IN_EXPONENT_SIGN_SEEN;
                        continue block21;
                    }
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a minus sign, a plus sign or a digit but saw ", c, " instead.");
                }
                case 9: {
                    if (this.isAsciiDigit(c)) {
                        state = State.IN_EXPONENT_DIGITS_SEEN;
                        continue block21;
                    }
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
                case 10: {
                    if (this.isAsciiDigit(c)) continue block21;
                    throw this.newDatatypeException(i, "Expected a digit but saw ", c, " instead.");
                }
            }
        }
        switch (state.ordinal()) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
            case 0: {
                throw this.newDatatypeException("The empty string is not a valid non-negative floating point number.");
            }
            case 1: {
                throw this.newDatatypeException("The minus sign alone is not a valid non-negative floating point number.");
            }
            case 4: 
            case 5: {
                throw this.newDatatypeException("A non-negative floating point number must not end with the decimal point.");
            }
            case 6: {
                throw this.newDatatypeException("A non-negative floating point number must not end with the exponent \u201ce\u201d.");
            }
            case 9: {
                throw this.newDatatypeException("A non-negative floating point number must not end with only a sign in the exponent.");
            }
        }
    }

    @Override
    public String getName() {
        return "non-negative floating point number";
    }

    private static enum State {
        AT_START,
        AT_START_MINUS_SEEN,
        IN_INTEGER_PART_DIGITS_SEEN,
        IN_INTEGER_PART_DIGITS_SEEN_ZERO,
        DOT_SEEN,
        DOT_SEEN_ZERO,
        E_SEEN,
        IN_DECIMAL_PART_DIGITS_SEEN,
        IN_DECIMAL_PART_DIGITS_SEEN_ZERO,
        IN_EXPONENT_SIGN_SEEN,
        IN_EXPONENT_DIGITS_SEEN;

    }
}

