/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.collections.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import nu.validator.collections.HeadBiasedSortedSet;
import nu.validator.collections.TailBiasedSortedSet;

public class SortedSetTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing HeadBiasedSortedSet...");
        SortedSetTest.testHeadBiasedBasicOperations();
        SortedSetTest.testHeadBiasedSorting();
        SortedSetTest.testHeadBiasedDuplicates();
        SortedSetTest.testHeadBiasedEmptySet();
        SortedSetTest.testHeadBiasedWithComparator();
        SortedSetTest.testHeadBiasedFromCollection();
        SortedSetTest.testHeadBiasedFromSortedSet();
        SortedSetTest.testHeadBiasedClear();
        SortedSetTest.testHeadBiasedIterator();
        System.out.println();
        System.out.println("Testing TailBiasedSortedSet...");
        SortedSetTest.testTailBiasedBasicOperations();
        SortedSetTest.testTailBiasedSorting();
        SortedSetTest.testTailBiasedDuplicates();
        SortedSetTest.testTailBiasedEmptySet();
        SortedSetTest.testTailBiasedWithComparator();
        SortedSetTest.testTailBiasedFromCollection();
        SortedSetTest.testTailBiasedFromSortedSet();
        SortedSetTest.testTailBiasedClear();
        SortedSetTest.testTailBiasedIterator();
        System.out.println();
        System.out.println("Testing equivalence between implementations...");
        SortedSetTest.testEquivalentBehavior();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testHeadBiasedBasicOperations() {
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>();
        SortedSetTest.assertTrue("HeadBiased: empty set has size 0", set.size() == 0);
        SortedSetTest.assertTrue("HeadBiased: empty set isEmpty", set.isEmpty());
        set.add(5);
        SortedSetTest.assertTrue("HeadBiased: size after add is 1", set.size() == 1);
        SortedSetTest.assertFalse("HeadBiased: not empty after add", set.isEmpty());
        SortedSetTest.assertTrue("HeadBiased: contains added element", set.contains(5));
        set.add(3);
        set.add(7);
        SortedSetTest.assertTrue("HeadBiased: size after adding 3 elements is 3", set.size() == 3);
    }

    private static void testHeadBiasedSorting() {
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>();
        set.add(5);
        set.add(1);
        set.add(9);
        set.add(3);
        set.add(7);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer i : set) {
            result.add(i);
        }
        List<Integer> expected = Arrays.asList(1, 3, 5, 7, 9);
        SortedSetTest.assertTrue("HeadBiased: elements are sorted", result.equals(expected));
        SortedSetTest.assertTrue("HeadBiased: first() returns smallest", ((Integer)set.first()).equals(1));
        SortedSetTest.assertTrue("HeadBiased: last() returns largest", ((Integer)set.last()).equals(9));
    }

    private static void testHeadBiasedDuplicates() {
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>();
        SortedSetTest.assertTrue("HeadBiased: first add returns true", set.add(5));
        SortedSetTest.assertFalse("HeadBiased: duplicate add returns false", set.add(5));
        SortedSetTest.assertTrue("HeadBiased: size is still 1 after duplicate", set.size() == 1);
    }

    private static void testHeadBiasedEmptySet() {
        HeadBiasedSortedSet set = new HeadBiasedSortedSet();
        try {
            set.first();
            SortedSetTest.fail("HeadBiased: first() on empty set should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("HeadBiased: first() on empty set throws NoSuchElementException");
        }
        try {
            set.last();
            SortedSetTest.fail("HeadBiased: last() on empty set should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("HeadBiased: last() on empty set throws NoSuchElementException");
        }
    }

    private static void testHeadBiasedWithComparator() {
        Comparator lengthComparator = (a, b) -> Integer.compare(a.length(), b.length());
        HeadBiasedSortedSet<String> set = new HeadBiasedSortedSet<String>(lengthComparator);
        set.add("aaa");
        set.add("a");
        set.add("aa");
        ArrayList<String> result = new ArrayList<String>();
        for (String s : set) {
            result.add(s);
        }
        SortedSetTest.assertTrue("HeadBiased: custom comparator sorts by length", ((String)result.get(0)).equals("a") && ((String)result.get(1)).equals("aa") && ((String)result.get(2)).equals("aaa"));
        SortedSetTest.assertTrue("HeadBiased: comparator() returns the comparator", set.comparator() == lengthComparator);
    }

    private static void testHeadBiasedFromCollection() {
        List<Integer> list = Arrays.asList(5, 1, 9, 3, 7);
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>(list);
        SortedSetTest.assertTrue("HeadBiased: from collection has correct size", set.size() == 5);
        SortedSetTest.assertTrue("HeadBiased: from collection first is 1", set.first().equals(1));
        SortedSetTest.assertTrue("HeadBiased: from collection last is 9", set.last().equals(9));
    }

    private static void testHeadBiasedFromSortedSet() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(Arrays.asList(5, 1, 9, 3, 7));
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>((SortedSet<Integer>)treeSet);
        SortedSetTest.assertTrue("HeadBiased: from SortedSet has correct size", set.size() == 5);
        SortedSetTest.assertTrue("HeadBiased: from SortedSet maintains order", set.first().equals(1));
    }

    private static void testHeadBiasedClear() {
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>();
        set.add(1);
        set.add(2);
        set.add(3);
        set.clear();
        SortedSetTest.assertTrue("HeadBiased: size is 0 after clear", set.size() == 0);
        SortedSetTest.assertTrue("HeadBiased: isEmpty after clear", set.isEmpty());
    }

    private static void testHeadBiasedIterator() {
        HeadBiasedSortedSet<Integer> set = new HeadBiasedSortedSet<Integer>();
        set.add(1);
        set.add(2);
        Iterator iter = set.iterator();
        SortedSetTest.assertTrue("HeadBiased: iterator hasNext on non-empty", iter.hasNext());
        iter.next();
        iter.next();
        SortedSetTest.assertFalse("HeadBiased: iterator hasNext is false at end", iter.hasNext());
        try {
            iter.next();
            SortedSetTest.fail("HeadBiased: iterator next() at end should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("HeadBiased: iterator next() at end throws NoSuchElementException");
        }
        try {
            iter.remove();
            SortedSetTest.fail("HeadBiased: iterator remove() should throw");
        }
        catch (UnsupportedOperationException e) {
            SortedSetTest.pass("HeadBiased: iterator remove() throws UnsupportedOperationException");
        }
    }

    private static void testTailBiasedBasicOperations() {
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>();
        SortedSetTest.assertTrue("TailBiased: empty set has size 0", set.size() == 0);
        SortedSetTest.assertTrue("TailBiased: empty set isEmpty", set.isEmpty());
        set.add(5);
        SortedSetTest.assertTrue("TailBiased: size after add is 1", set.size() == 1);
        SortedSetTest.assertFalse("TailBiased: not empty after add", set.isEmpty());
        SortedSetTest.assertTrue("TailBiased: contains added element", set.contains(5));
        set.add(3);
        set.add(7);
        SortedSetTest.assertTrue("TailBiased: size after adding 3 elements is 3", set.size() == 3);
    }

    private static void testTailBiasedSorting() {
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>();
        set.add(5);
        set.add(1);
        set.add(9);
        set.add(3);
        set.add(7);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer i : set) {
            result.add(i);
        }
        List<Integer> expected = Arrays.asList(1, 3, 5, 7, 9);
        SortedSetTest.assertTrue("TailBiased: elements are sorted", result.equals(expected));
        SortedSetTest.assertTrue("TailBiased: first() returns smallest", ((Integer)set.first()).equals(1));
        SortedSetTest.assertTrue("TailBiased: last() returns largest", ((Integer)set.last()).equals(9));
    }

    private static void testTailBiasedDuplicates() {
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>();
        SortedSetTest.assertTrue("TailBiased: first add returns true", set.add(5));
        SortedSetTest.assertFalse("TailBiased: duplicate add returns false", set.add(5));
        SortedSetTest.assertTrue("TailBiased: size is still 1 after duplicate", set.size() == 1);
    }

    private static void testTailBiasedEmptySet() {
        TailBiasedSortedSet set = new TailBiasedSortedSet();
        try {
            set.first();
            SortedSetTest.fail("TailBiased: first() on empty set should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("TailBiased: first() on empty set throws NoSuchElementException");
        }
        try {
            set.last();
            SortedSetTest.fail("TailBiased: last() on empty set should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("TailBiased: last() on empty set throws NoSuchElementException");
        }
    }

    private static void testTailBiasedWithComparator() {
        Comparator lengthComparator = (a, b) -> Integer.compare(a.length(), b.length());
        TailBiasedSortedSet<String> set = new TailBiasedSortedSet<String>(lengthComparator);
        set.add("aaa");
        set.add("a");
        set.add("aa");
        ArrayList<String> result = new ArrayList<String>();
        for (String s : set) {
            result.add(s);
        }
        SortedSetTest.assertTrue("TailBiased: custom comparator sorts by length", ((String)result.get(0)).equals("a") && ((String)result.get(1)).equals("aa") && ((String)result.get(2)).equals("aaa"));
        SortedSetTest.assertTrue("TailBiased: comparator() returns the comparator", set.comparator() == lengthComparator);
    }

    private static void testTailBiasedFromCollection() {
        List<Integer> list = Arrays.asList(5, 1, 9, 3, 7);
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>(list);
        SortedSetTest.assertTrue("TailBiased: from collection has correct size", set.size() == 5);
        SortedSetTest.assertTrue("TailBiased: from collection first is 1", set.first().equals(1));
        SortedSetTest.assertTrue("TailBiased: from collection last is 9", set.last().equals(9));
    }

    private static void testTailBiasedFromSortedSet() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(Arrays.asList(5, 1, 9, 3, 7));
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>((SortedSet<Integer>)treeSet);
        SortedSetTest.assertTrue("TailBiased: from SortedSet has correct size", set.size() == 5);
        SortedSetTest.assertTrue("TailBiased: from SortedSet maintains order", set.first().equals(1));
    }

    private static void testTailBiasedClear() {
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>();
        set.add(1);
        set.add(2);
        set.add(3);
        set.clear();
        SortedSetTest.assertTrue("TailBiased: size is 0 after clear", set.size() == 0);
        SortedSetTest.assertTrue("TailBiased: isEmpty after clear", set.isEmpty());
    }

    private static void testTailBiasedIterator() {
        TailBiasedSortedSet<Integer> set = new TailBiasedSortedSet<Integer>();
        set.add(1);
        set.add(2);
        Iterator iter = set.iterator();
        SortedSetTest.assertTrue("TailBiased: iterator hasNext on non-empty", iter.hasNext());
        iter.next();
        iter.next();
        SortedSetTest.assertFalse("TailBiased: iterator hasNext is false at end", iter.hasNext());
        try {
            iter.next();
            SortedSetTest.fail("TailBiased: iterator next() at end should throw");
        }
        catch (NoSuchElementException e) {
            SortedSetTest.pass("TailBiased: iterator next() at end throws NoSuchElementException");
        }
        try {
            iter.remove();
            SortedSetTest.fail("TailBiased: iterator remove() should throw");
        }
        catch (UnsupportedOperationException e) {
            SortedSetTest.pass("TailBiased: iterator remove() throws UnsupportedOperationException");
        }
    }

    private static void testEquivalentBehavior() {
        int[] elements;
        HeadBiasedSortedSet<Integer> headSet = new HeadBiasedSortedSet<Integer>();
        TailBiasedSortedSet<Integer> tailSet = new TailBiasedSortedSet<Integer>();
        for (int e : elements = new int[]{50, 10, 90, 30, 70, 20, 80, 40, 60}) {
            headSet.add(e);
            tailSet.add(e);
        }
        ArrayList<Integer> headResult = new ArrayList<Integer>();
        ArrayList<Integer> tailResult = new ArrayList<Integer>();
        for (Integer i : headSet) {
            headResult.add(i);
        }
        for (Integer i : tailSet) {
            tailResult.add(i);
        }
        SortedSetTest.assertTrue("Equivalence: both sets produce same sorted order", headResult.equals(tailResult));
        SortedSetTest.assertTrue("Equivalence: same size", headSet.size() == tailSet.size());
        SortedSetTest.assertTrue("Equivalence: same first", ((Integer)headSet.first()).equals(tailSet.first()));
        SortedSetTest.assertTrue("Equivalence: same last", ((Integer)headSet.last()).equals(tailSet.last()));
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            SortedSetTest.pass(testName);
        } else {
            SortedSetTest.fail(testName);
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        SortedSetTest.assertTrue(testName, !condition);
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }
}

