/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.test;

import java.util.ArrayList;
import java.util.List;
import nu.validator.checker.CspEnforcementChecker;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class CspEnforcementCheckerTest {
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) throws Exception {
        System.out.println("Testing CSP meta tag detection...");
        CspEnforcementCheckerTest.testCspMetaTagDetection();
        CspEnforcementCheckerTest.testNoCspMetaTag();
        System.out.println();
        System.out.println("Testing inline script violations...");
        CspEnforcementCheckerTest.testInlineScriptViolation();
        CspEnforcementCheckerTest.testInlineScriptWithUnsafeInline();
        CspEnforcementCheckerTest.testInlineScriptWithNonce();
        System.out.println();
        System.out.println("Testing event handler violations...");
        CspEnforcementCheckerTest.testEventHandlerViolation();
        CspEnforcementCheckerTest.testEventHandlerWithUnsafeInline();
        System.out.println();
        System.out.println("Testing inline style violations...");
        CspEnforcementCheckerTest.testInlineStyleViolation();
        CspEnforcementCheckerTest.testInlineStyleWithUnsafeInline();
        System.out.println();
        System.out.println("Testing style attribute violations...");
        CspEnforcementCheckerTest.testStyleAttributeViolation();
        CspEnforcementCheckerTest.testStyleAttributeWithUnsafeInline();
        System.out.println();
        System.out.println("Testing external resource violations...");
        CspEnforcementCheckerTest.testExternalScriptViolation();
        CspEnforcementCheckerTest.testExternalScriptAllowed();
        CspEnforcementCheckerTest.testExternalStylesheetViolation();
        CspEnforcementCheckerTest.testExternalStylesheetAllowed();
        System.out.println();
        System.out.println("Testing default-src fallback...");
        CspEnforcementCheckerTest.testDefaultSrcFallback();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testCspMetaTagDetection() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self'", "<script>alert('test');</script>");
        CspEnforcementCheckerTest.assertContains("CSP meta tag detected, inline script blocked", warnings, "Inline script violates");
    }

    private static void testNoCspMetaTag() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithoutCsp("<script>alert('test');</script>");
        CspEnforcementCheckerTest.assertTrue("No CSP meta tag: no warnings", warnings.isEmpty());
    }

    private static void testInlineScriptViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self'", "<script>alert('test');</script>");
        CspEnforcementCheckerTest.assertContains("Inline script without unsafe-inline blocked", warnings, "Inline script violates");
    }

    private static void testInlineScriptWithUnsafeInline() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self' 'unsafe-inline'", "<script>alert('test');</script>");
        CspEnforcementCheckerTest.assertTrue("Inline script with unsafe-inline allowed", warnings.isEmpty());
    }

    private static void testInlineScriptWithNonce() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self' 'nonce-abc123'", "<script nonce=\"abc123\">alert('test');</script>");
        CspEnforcementCheckerTest.assertTrue("Inline script with matching nonce allowed", warnings.isEmpty());
    }

    private static void testEventHandlerViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self'", "<button onclick=\"alert('click')\">Click</button>");
        CspEnforcementCheckerTest.assertContains("Event handler without unsafe-inline blocked", warnings, "onclick");
    }

    private static void testEventHandlerWithUnsafeInline() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self' 'unsafe-inline'", "<button onclick=\"alert('click')\">Click</button>");
        CspEnforcementCheckerTest.assertTrue("Event handler with unsafe-inline allowed", warnings.isEmpty());
    }

    private static void testInlineStyleViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self'", "<style>body { color: red; }</style>");
        CspEnforcementCheckerTest.assertContains("Inline style without unsafe-inline blocked", warnings, "Inline style violates");
    }

    private static void testInlineStyleWithUnsafeInline() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self' 'unsafe-inline'", "<style>body { color: red; }</style>");
        CspEnforcementCheckerTest.assertTrue("Inline style with unsafe-inline allowed", warnings.isEmpty());
    }

    private static void testStyleAttributeViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self'", "<p style=\"color: red;\">Text</p>");
        CspEnforcementCheckerTest.assertContains("Style attribute without unsafe-inline blocked", warnings, "style");
    }

    private static void testStyleAttributeWithUnsafeInline() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self' 'unsafe-inline'", "<p style=\"color: red;\">Text</p>");
        CspEnforcementCheckerTest.assertTrue("Style attribute with unsafe-inline allowed", warnings.isEmpty());
    }

    private static void testExternalScriptViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self'", "<script src=\"https://evil.com/script.js\"></script>");
        CspEnforcementCheckerTest.assertContains("External script from disallowed origin blocked", warnings, "script");
    }

    private static void testExternalScriptAllowed() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("script-src 'self' https://cdn.example.com", "<script src=\"https://cdn.example.com/script.js\"></script>");
        CspEnforcementCheckerTest.assertTrue("External script from allowed origin passes", warnings.isEmpty());
    }

    private static void testExternalStylesheetViolation() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self'", "<link rel=\"stylesheet\" href=\"https://evil.com/style.css\">");
        CspEnforcementCheckerTest.assertContains("External stylesheet from disallowed origin blocked", warnings, "stylesheet");
    }

    private static void testExternalStylesheetAllowed() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("style-src 'self' https://cdn.example.com", "<link rel=\"stylesheet\" href=\"https://cdn.example.com/style.css\">");
        CspEnforcementCheckerTest.assertTrue("External stylesheet from allowed origin passes", warnings.isEmpty());
    }

    private static void testDefaultSrcFallback() throws Exception {
        List<String> warnings = CspEnforcementCheckerTest.validateWithCsp("default-src 'self'", "<script>alert('test');</script>");
        CspEnforcementCheckerTest.assertContains("default-src fallback for script-src", warnings, "Inline script violates");
    }

    private static List<String> validateWithCsp(String cspPolicy, String bodyContent) throws SAXException {
        CspEnforcementChecker checker = new CspEnforcementChecker();
        TestErrorHandler errorHandler = new TestErrorHandler();
        checker.setErrorHandler(errorHandler);
        checker.setDocumentLocator(new TestLocator());
        checker.startDocument();
        AttributesImpl htmlAtts = new AttributesImpl();
        htmlAtts.addAttribute("", "lang", "lang", "CDATA", "en");
        checker.startElement(XHTML_NS, "html", "html", htmlAtts);
        checker.startElement(XHTML_NS, "head", "head", new AttributesImpl());
        AttributesImpl metaAtts = new AttributesImpl();
        metaAtts.addAttribute("", "http-equiv", "http-equiv", "CDATA", "Content-Security-Policy");
        metaAtts.addAttribute("", "content", "content", "CDATA", cspPolicy);
        checker.startElement(XHTML_NS, "meta", "meta", metaAtts);
        checker.endElement(XHTML_NS, "meta", "meta");
        checker.endElement(XHTML_NS, "head", "head");
        checker.startElement(XHTML_NS, "body", "body", new AttributesImpl());
        CspEnforcementCheckerTest.parseBodyContent(checker, bodyContent);
        checker.endElement(XHTML_NS, "body", "body");
        checker.endElement(XHTML_NS, "html", "html");
        checker.endDocument();
        return errorHandler.getWarnings();
    }

    private static List<String> validateWithoutCsp(String bodyContent) throws SAXException {
        CspEnforcementChecker checker = new CspEnforcementChecker();
        TestErrorHandler errorHandler = new TestErrorHandler();
        checker.setErrorHandler(errorHandler);
        checker.setDocumentLocator(new TestLocator());
        checker.startDocument();
        AttributesImpl htmlAtts = new AttributesImpl();
        htmlAtts.addAttribute("", "lang", "lang", "CDATA", "en");
        checker.startElement(XHTML_NS, "html", "html", htmlAtts);
        checker.startElement(XHTML_NS, "head", "head", new AttributesImpl());
        checker.endElement(XHTML_NS, "head", "head");
        checker.startElement(XHTML_NS, "body", "body", new AttributesImpl());
        CspEnforcementCheckerTest.parseBodyContent(checker, bodyContent);
        checker.endElement(XHTML_NS, "body", "body");
        checker.endElement(XHTML_NS, "html", "html");
        checker.endDocument();
        return errorHandler.getWarnings();
    }

    private static void parseBodyContent(CspEnforcementChecker checker, String content) throws SAXException {
        int pos = 0;
        while (pos < content.length()) {
            int tagEnd;
            int tagStart = content.indexOf(60, pos);
            if (tagStart == -1) {
                String text = content.substring(pos);
                checker.characters(text.toCharArray(), 0, text.length());
                break;
            }
            if (tagStart > pos) {
                String text = content.substring(pos, tagStart);
                checker.characters(text.toCharArray(), 0, text.length());
            }
            if ((tagEnd = content.indexOf(62, tagStart)) == -1) break;
            String tagContent = content.substring(tagStart + 1, tagEnd);
            boolean isClosing = tagContent.startsWith("/");
            boolean isSelfClosing = tagContent.endsWith("/");
            if (isClosing) {
                String tagName = tagContent.substring(1).trim();
                checker.endElement(XHTML_NS, tagName, tagName);
            } else {
                int closeTag;
                String[] parts = tagContent.split("\\s+", 2);
                String tagName = parts[0];
                if (tagName.endsWith("/")) {
                    tagName = tagName.substring(0, tagName.length() - 1);
                }
                AttributesImpl atts = new AttributesImpl();
                if (parts.length > 1) {
                    String attrsStr = parts[1];
                    if (attrsStr.endsWith("/")) {
                        attrsStr = attrsStr.substring(0, attrsStr.length() - 1);
                    }
                    CspEnforcementCheckerTest.parseAttributes(attrsStr, atts);
                }
                checker.startElement(XHTML_NS, tagName, tagName, atts);
                if (("script".equals(tagName) || "style".equals(tagName)) && (closeTag = content.indexOf("</" + tagName + ">", tagEnd)) > tagEnd + 1) {
                    String innerContent = content.substring(tagEnd + 1, closeTag);
                    checker.characters(innerContent.toCharArray(), 0, innerContent.length());
                    checker.endElement(XHTML_NS, tagName, tagName);
                    pos = closeTag + tagName.length() + 3;
                    continue;
                }
                if (isSelfClosing || CspEnforcementCheckerTest.isVoidElement(tagName)) {
                    checker.endElement(XHTML_NS, tagName, tagName);
                }
            }
            pos = tagEnd + 1;
        }
    }

    private static void parseAttributes(String attrsStr, AttributesImpl atts) {
        int pos = 0;
        while (pos < attrsStr.length()) {
            String value;
            int eqPos;
            while (pos < attrsStr.length() && Character.isWhitespace(attrsStr.charAt(pos))) {
                ++pos;
            }
            if (pos >= attrsStr.length() || (eqPos = attrsStr.indexOf(61, pos)) == -1) break;
            String name = attrsStr.substring(pos, eqPos).trim();
            for (pos = eqPos + 1; pos < attrsStr.length() && Character.isWhitespace(attrsStr.charAt(pos)); ++pos) {
            }
            if (pos < attrsStr.length() && attrsStr.charAt(pos) == '\"') {
                int endQuote;
                if ((endQuote = attrsStr.indexOf(34, ++pos)) == -1) break;
                value = attrsStr.substring(pos, endQuote);
                pos = endQuote + 1;
            } else {
                int space = attrsStr.indexOf(32, pos);
                if (space == -1) {
                    space = attrsStr.length();
                }
                value = attrsStr.substring(pos, space);
                pos = space;
            }
            atts.addAttribute("", name, name, "CDATA", value);
        }
    }

    private static boolean isVoidElement(String tagName) {
        return "meta".equals(tagName) || "link".equals(tagName) || "br".equals(tagName) || "hr".equals(tagName) || "img".equals(tagName) || "input".equals(tagName);
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            CspEnforcementCheckerTest.pass(testName);
        } else {
            CspEnforcementCheckerTest.fail(testName);
        }
    }

    private static void assertContains(String testName, List<String> warnings, String substring) {
        boolean found = false;
        for (String warning : warnings) {
            if (!warning.toLowerCase().contains(substring.toLowerCase())) continue;
            found = true;
            break;
        }
        if (found) {
            CspEnforcementCheckerTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected warning containing: " + substring);
            System.out.println("  Actual warnings: " + String.valueOf(warnings));
            ++failed;
        }
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }

    private static class TestErrorHandler
    implements ErrorHandler {
        private final List<String> warnings = new ArrayList<String>();

        private TestErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) {
            this.warnings.add(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) {
        }

        public List<String> getWarnings() {
            return this.warnings;
        }
    }

    private static class TestLocator
    implements Locator {
        private int line = 1;
        private int column = 1;

        private TestLocator() {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return "test.html";
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return this.column;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public void setColumn(int column) {
            this.column = column;
        }
    }
}

