/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.Checker;
import nu.validator.checker.DatatypeMismatchException;
import nu.validator.datatype.Charset;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.datatype.Html5DatatypeLibrary;
import nu.validator.datatype.IriRef;
import nu.validator.datatype.MediaQuery;
import nu.validator.datatype.MimeType;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XmlPiChecker
extends Checker
implements LexicalHandler {
    private static final char[][] NAMES = new char[][]{"amp;".toCharArray(), "lt;".toCharArray(), "gt;".toCharArray(), "quot;".toCharArray(), "apos;".toCharArray()};
    private static final char[][] VALUES = new char[][]{{'&'}, {'<'}, {'>'}, {'\"'}, {'\''}};
    private static final int DATA_AND_RCDATA_MASK = -2;
    private static final int BEFORE_ATTRIBUTE_NAME = 0;
    private static final int ATTRIBUTE_NAME = 1;
    private static final int AFTER_ATTRIBUTE_NAME = 2;
    private static final int BEFORE_ATTRIBUTE_VALUE = 3;
    private static final int ATTRIBUTE_VALUE_DOUBLE_QUOTED = 4;
    private static final int ATTRIBUTE_VALUE_SINGLE_QUOTED = 5;
    private static final int ATTRIBUTE_VALUE_UNQUOTED = 6;
    private static final int AFTER_ATTRIBUTE_VALUE_QUOTED = 7;
    private static final int CONSUME_CHARACTER_REFERENCE = 8;
    private static final int CONSUME_NCR = 9;
    private static final int CHARACTER_REFERENCE_LOOP = 10;
    private static final int HEX_NCR_LOOP = 11;
    private static final int DECIMAL_NRC_LOOP = 12;
    private static final int HANDLE_NCR_VALUE = 13;
    private static final int BUFFER_GROW_BY = 1024;
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    private static final int LEAD_OFFSET = 55232;
    private char[] strBuf = new char[64];
    private int strBufLen;
    private char[] longStrBuf = new char[1024];
    private int longStrBufLen;
    private final char[] bmpChar = new char[1];
    private final char[] astralChar = new char[2];
    private int entCol;
    private int lo;
    private int hi;
    private int candidate;
    private int strBufMark;
    private int prevValue;
    private int value;
    private boolean seenDigits;
    private char additional;
    private boolean alreadyWarnedAboutPrivateUseCharacters;
    private AttributesImpl attributes;
    private String attributeName;
    private boolean inDoctype = false;
    private boolean alreadyHasElement = false;
    private String piTarget = null;
    private boolean hasXsltPi = false;

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDoctype = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDoctype = false;
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.inDoctype = false;
        this.hasXsltPi = false;
        this.alreadyHasElement = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.alreadyHasElement = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.piTarget = target;
        if ("xml-stylesheet".equals(this.piTarget)) {
            this.checkXmlStylesheetPiData(data);
        }
    }

    private void errBadPseudoAttrDatatype(DatatypeException e, Class<?> datatypeClass, String attrName, String attrValue) throws SAXException, ClassNotFoundException {
        if (this.getErrorHandler() != null) {
            Html5DatatypeException ex5 = (Html5DatatypeException)e;
            DatatypeMismatchException bpe = new DatatypeMismatchException("Bad value \u201c" + attrValue + "\u201d for \u201c" + this.piTarget + "\u201d pseudo-attribute \u201c" + attrName + "\u201d. " + e.getMessage(), this.getDocumentLocator(), datatypeClass, ex5.isWarning());
            this.getErrorHandler().error(bpe);
        }
    }

    private void errAttributeWithNoValue() throws SAXException {
        this.err("Found \u201c" + this.piTarget + "\u201d pseudo-attribute \u201c" + this.attributeName + "\u201d without a value. All pseudo-attributes in \u201c" + this.piTarget + "\u201d instructions must have values.");
    }

    private void errAttributeValueContainsLt() throws SAXException {
        this.err("Found \u201c" + this.piTarget + "\u201d pseudo-attribute \u201c" + this.attributeName + "\u201d with the character \u201c<\u201d in its value. All pseudo-attribute values in \u201c" + this.piTarget + "\u201d instructions must not contain the character \u201c<\u201d.");
    }

    private void errUpperCaseXinHexNcr() throws SAXException {
        this.err("In XML documents, a hexadecimal character reference must begin with \u201c&#x\u201d (lowercase \u201cx\u201d), not \u201c&#X\u201d (uppercase \u201cX\u201d).");
    }

    private void checkXmlStylesheetPiData(String data) throws SAXException {
        boolean hasHref = false;
        boolean hasTitle = false;
        boolean hasMedia = false;
        boolean hasCharset = false;
        boolean hasAlternate = false;
        boolean hasNonEmptyTitle = false;
        boolean alternateIsYes = false;
        boolean badDatatype = false;
        if (this.inDoctype) {
            this.warn("An \u201cxml-stylesheet\u201d instruction should not be used within a \u201cDOCTYPE\u201d declaration.");
        }
        if (this.alreadyHasElement) {
            this.err("Any \u201cxml-stylesheet\u201d instruction in a document must occur before any elements in the document. Suppressing any further errors for this \u201cxml-stylesheet\u201d instruction.");
            return;
        }
        if (!"".equals(data)) {
            Html5DatatypeLibrary dl = new Html5DatatypeLibrary();
            AttributesImpl patts = this.getPseudoAttributesFromPiData(data);
            block24: for (int i = 0; i < patts.getLength(); ++i) {
                String attrName = patts.getQName(i);
                String attrValue = patts.getValue(i);
                switch (PseudoAttrName.toCaps(attrName).ordinal()) {
                    case 0: {
                        hasHref = true;
                        if (attrValue == null) continue block24;
                        try {
                            IriRef ir = (IriRef)dl.createDatatype("iri-ref");
                            ir.checkValid(attrValue);
                        }
                        catch (DatatypeException e) {
                            try {
                                this.errBadPseudoAttrDatatype(e, IriRef.class, "href", attrValue);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        continue block24;
                    }
                    case 1: {
                        if (attrValue == null) continue block24;
                        try {
                            MimeType mt = (MimeType)dl.createDatatype("mime-type");
                            mt.checkValid(attrValue);
                            attrValue = XmlPiChecker.newAsciiLowerCaseStringFromString(attrValue);
                        }
                        catch (DatatypeException e) {
                            badDatatype = true;
                            try {
                                this.errBadPseudoAttrDatatype(e, MimeType.class, "type", attrValue);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (badDatatype) continue block24;
                        if (attrValue.matches("application/xml(;.*)?") || attrValue.matches("text/xml(;.*)?") || attrValue.matches("application/xslt+xml(;.*)?") || attrValue.matches("text/xsl(;.*)?") || attrValue.matches("text/xslt(;.*)?")) {
                            if (!attrValue.matches("text/xsl(;.*)?")) {
                                this.warn("For indicating XSLT, \u201ctext/xsl\u201d is the only MIME type for the \u201cxml-stylesheet\u201d pseudo-attribute \u201ctype\u201d that is supported across browsers.");
                            }
                            if (this.hasXsltPi) {
                                this.warn("Browsers do not support multiple \u201cxml-stylesheet\u201d instructions with a \u201ctype\u201d value that indicates XSLT.");
                            }
                            this.hasXsltPi = true;
                            continue block24;
                        }
                        if (attrValue.matches("^text/css(;.*)?$")) continue block24;
                        this.warn("\u201ctext/css\u201d and \u201ctext/xsl\u201d are the only MIME types for the \u201cxml-stylesheet\u201d pseudo-attribute \u201ctype\u201d that are supported across browsers.");
                        continue block24;
                    }
                    case 2: {
                        hasTitle = true;
                        if (attrValue == null || "".equals(attrValue)) continue block24;
                        hasNonEmptyTitle = true;
                        continue block24;
                    }
                    case 3: {
                        hasMedia = true;
                        if (attrValue == null) continue block24;
                        try {
                            MediaQuery mq = (MediaQuery)dl.createDatatype("media-query");
                            mq.checkValid(attrValue);
                        }
                        catch (DatatypeException e) {
                            try {
                                this.errBadPseudoAttrDatatype(e, MediaQuery.class, "media", attrValue);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        continue block24;
                    }
                    case 4: {
                        hasCharset = true;
                        if (attrValue == null) continue block24;
                        try {
                            Charset c = (Charset)dl.createDatatype("charset");
                            c.checkValid(attrValue);
                        }
                        catch (DatatypeException e) {
                            try {
                                this.errBadPseudoAttrDatatype(e, Charset.class, "charset", attrValue);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        continue block24;
                    }
                    case 5: {
                        hasAlternate = true;
                        if (attrValue == null) continue block24;
                        if ("yes".equals(attrValue)) {
                            alternateIsYes = true;
                            continue block24;
                        }
                        if ("no".equals(attrValue)) continue block24;
                        this.err("The value of the \u201cxml-stylesheet\u201d pseudo-attribute \u201calternate\u201d must be either \u201cyes\u201d or \u201cno\u201d.");
                        continue block24;
                    }
                    default: {
                        this.err("Pseudo-attribute \u201c" + attrName + "\u201d not allowed in \u201cxml-stylesheet\u201d instruction.");
                    }
                }
            }
            if (alternateIsYes && !hasNonEmptyTitle) {
                this.err("An \u201cxml-stylesheet\u201d instruction with an \u201calternate\u201d pseudo-attribute whose value is \u201cyes\u201d must also have a \u201ctitle\u201d pseudo-attribute with a non-empty value.");
            }
        }
        if (!hasHref) {
            this.err("\u201cxml-stylesheet\u201d instruction lacks \u201chref\u201d pseudo-attribute. The \u201chref\u201d pseudo-attribute is required in all \u201cxml-stylesheet\u201d instructions.");
        }
        if (this.hasXsltPi && (hasTitle || hasMedia || hasCharset || hasAlternate)) {
            this.warn("When processing \u201cxml-stylesheet\u201d instructions, browsers ignore the pseudo-attributes \u201ctitle\u201d, \u201cmedia\u201d, \u201ccharset\u201d, and \u201calternate\u201d.");
        } else if (hasCharset) {
            this.warn("Some browsers ignore the value of the \u201cxml-stylesheet\u201d pseudo-attribute \u201ccharset\u201d.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private AttributesImpl getPseudoAttributesFromPiData(String buf) throws SAXException {
        state = 0;
        returnState = 0;
        c = '\u0000';
        pos = -1;
        endPos = buf.length();
        reconsume = false;
        this.attributes = null;
        this.attributeName = null;
        block62: while (true) {
            switch (state) {
                case 0: {
                    block63: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) break block62;
                            c = buf.charAt(pos);
                        }
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                continue block63;
                            }
                            case '\"': 
                            case '\'': 
                            case '/': 
                            case '<': 
                            case '=': 
                            case '>': {
                                this.errBadCharBeforeAttributeNameOrNull(c);
                            }
                        }
                        break;
                    }
                    this.clearStrBufAndAppendCurrentC(c);
                    state = 1;
                }
                case 1: {
                    block64: while (true) {
                        if (++pos == endPos) {
                            this.attributeNameComplete();
                            this.addAttributeWithoutValue();
                            break block62;
                        }
                        c = buf.charAt(pos);
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                this.attributeNameComplete();
                                state = 2;
                                continue block62;
                            }
                            case '=': {
                                this.attributeNameComplete();
                                state = 3;
                                break block64;
                            }
                            case '\"': 
                            case '\'': 
                            case '<': {
                                this.errQuoteOrLtInAttributeNameOrNull(c);
                            }
                            default: {
                                this.appendStrBuf(c);
                                continue block64;
                            }
                        }
                        break;
                    }
                }
                case 3: {
                    block65: while (true) {
                        if (++pos == endPos) {
                            this.addAttributeWithoutValue();
                            break block62;
                        }
                        c = buf.charAt(pos);
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                continue block65;
                            }
                            case '\"': {
                                this.clearLongStrBufForNextState();
                                state = 4;
                                break block65;
                            }
                            case '&': {
                                this.clearLongStrBuf();
                                state = 6;
                                reconsume = true;
                                continue block62;
                            }
                            case '\'': {
                                this.clearLongStrBufForNextState();
                                state = 5;
                                continue block62;
                            }
                            case '<': 
                            case '=': 
                            case '`': {
                                this.errLtOrEqualsOrGraveInUnquotedAttributeOrNull(c);
                            }
                            default: {
                                this.clearLongStrBufAndAppendCurrentC(c);
                                state = 6;
                                continue block62;
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    block66: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) {
                                this.addAttributeWithoutValue();
                                break block62;
                            }
                            c = buf.charAt(pos);
                        }
                        switch (c) {
                            case '\"': {
                                this.addAttributeWithValue();
                                state = 7;
                                break block66;
                            }
                            case '&': {
                                this.clearStrBufAndAppendCurrentC(c);
                                returnState = state;
                                state = 8;
                                continue block62;
                            }
                            case '\n': {
                                this.appendLongStrBufLineFeed();
                                continue block66;
                            }
                            default: {
                                this.appendLongStrBuf(c);
                                continue block66;
                            }
                        }
                        break;
                    }
                }
                case 7: {
                    if (++pos == endPos) break block62;
                    c = buf.charAt(pos);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            state = 0;
                            continue block62;
                        }
                    }
                    this.errNoSpaceBetweenAttributes();
                    state = 0;
                    reconsume = true;
                    continue block62;
                }
                case 6: {
                    this.errUnquotedAttributeValOrNull();
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) {
                                this.addAttributeWithValue();
                                break block62;
                            }
                            c = buf.charAt(pos);
                        }
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                this.addAttributeWithValue();
                                state = 0;
                                continue block62;
                            }
                            case '&': {
                                this.clearStrBufAndAppendCurrentC(c);
                                returnState = state;
                                state = 8;
                                continue block62;
                            }
                            case '>': {
                                continue block62;
                            }
                        }
                        this.appendLongStrBuf(c);
                    }
                }
                case 2: {
                    block68: while (true) {
                        if (++pos == endPos) {
                            this.addAttributeWithoutValue();
                            break block62;
                        }
                        c = buf.charAt(pos);
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                continue block68;
                            }
                            case '=': {
                                state = 3;
                                continue block62;
                            }
                            case '\"': 
                            case '\'': 
                            case '<': {
                                this.errQuoteOrLtInAttributeNameOrNull(c);
                            }
                        }
                        break;
                    }
                    this.addAttributeWithoutValue();
                    this.clearStrBufAndAppendCurrentC(c);
                    state = 1;
                    continue block62;
                }
                case 5: {
                    block69: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) {
                                this.addAttributeWithoutValue();
                                break block62;
                            }
                            c = buf.charAt(pos);
                        }
                        switch (c) {
                            case '\'': {
                                this.addAttributeWithValue();
                                state = 7;
                                continue block62;
                            }
                            case '&': {
                                this.clearStrBufAndAppendCurrentC(c);
                                returnState = state;
                                state = 8;
                                break block69;
                            }
                            case '\n': {
                                this.appendLongStrBufLineFeed();
                                continue block69;
                            }
                            default: {
                                this.appendLongStrBuf(c);
                                continue block69;
                            }
                        }
                        break;
                    }
                }
                case 8: {
                    if (++pos == endPos) break block62;
                    c = buf.charAt(pos);
                    switch (c) {
                        case '#': {
                            this.appendStrBuf('#');
                            state = 9;
                            continue block62;
                        }
                    }
                    if (c == this.additional) {
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        reconsume = true;
                        continue block62;
                    }
                    this.entCol = -1;
                    this.lo = 0;
                    this.hi = XmlPiChecker.NAMES.length - 1;
                    this.candidate = -1;
                    this.strBufMark = 0;
                    state = 10;
                    reconsume = true;
                }
                case 10: {
                    block70: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) break block62;
                            c = buf.charAt(pos);
                        }
                        ++this.entCol;
                        while (this.hi != -1 && this.entCol != XmlPiChecker.NAMES[this.hi].length) {
                            if (this.entCol > XmlPiChecker.NAMES[this.hi].length) break block70;
                            if (c >= XmlPiChecker.NAMES[this.hi][this.entCol]) break;
                            --this.hi;
                        }
                        while (this.hi >= this.lo) {
                            if (this.entCol == XmlPiChecker.NAMES[this.lo].length) {
                                this.candidate = this.lo++;
                                this.strBufMark = this.strBufLen;
                                continue;
                            }
                            if (this.entCol > XmlPiChecker.NAMES[this.lo].length) break block70;
                            if (c > XmlPiChecker.NAMES[this.lo][this.entCol]) {
                                ++this.lo;
                                continue;
                            }
                            if (this.hi < this.lo) break block70;
                            this.appendStrBuf(c);
                            continue block70;
                        }
                        break;
                    }
                    if (this.candidate == -1) {
                        this.errNoNamedCharacterMatch();
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        reconsume = true;
                        continue block62;
                    }
                    candidateArr = XmlPiChecker.NAMES[this.candidate];
                    if (candidateArr[candidateArr.length - 1] != ';') {
                        if ((returnState & -2) != 0 && ((ch = this.strBufMark == this.strBufLen ? c : this.strBuf[this.strBufMark]) >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                            this.errNoNamedCharacterMatch();
                            this.appendStrBufToLongStrBuf();
                            state = returnState;
                            reconsume = true;
                            continue block62;
                        }
                        if ((returnState & -2) != 0) {
                            this.errUnescapedAmpersandInterpretedAsCharacterReference();
                        }
                    }
                    val = XmlPiChecker.VALUES[this.candidate];
                    this.emitOrAppend(val, returnState);
                    if (this.strBufMark < this.strBufLen && (returnState & -2) != 0) {
                        for (i = this.strBufMark; i < this.strBufLen; ++i) {
                            this.appendLongStrBuf(this.strBuf[i]);
                        }
                    }
                    state = returnState;
                    reconsume = true;
                    continue block62;
                }
                case 9: {
                    if (++pos == endPos) break block62;
                    c = buf.charAt(pos);
                    this.prevValue = -1;
                    this.value = 0;
                    this.seenDigits = false;
                    switch (c) {
                        case 'x': {
                            this.appendStrBuf(c);
                            state = 11;
                            continue block62;
                        }
                        case 'X': {
                            this.errUpperCaseXinHexNcr();
                            this.appendStrBuf(c);
                            state = 11;
                            continue block62;
                        }
                    }
                    state = 12;
                    reconsume = true;
                }
                case 12: {
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            if (++pos == endPos) break block62;
                            c = buf.charAt(pos);
                        }
                        if (this.value < this.prevValue) {
                            this.value = 0x110000;
                        }
                        this.prevValue = this.value;
                        if (c < '0' || c > '9') break;
                        this.seenDigits = true;
                        this.value *= 10;
                        this.value += c - 48;
                    }
                    if (c != ';') ** GOTO lbl290
                    if (this.seenDigits) {
                        state = 13;
                    } else {
                        this.errNoDigitsInNCR();
                        this.appendStrBuf(';');
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        continue block62;
lbl290:
                        // 1 sources

                        if (!this.seenDigits) {
                            this.errNoDigitsInNCR();
                            this.emitOrAppendStrBuf(returnState);
                            state = returnState;
                            reconsume = true;
                            continue block62;
                        }
                        this.errCharRefLacksSemicolon();
                        state = 13;
                        reconsume = true;
                    }
                }
                case 13: {
                    this.handleNcrValue(returnState);
                    state = returnState;
                    continue block62;
                }
                case 11: {
                    while (++pos != endPos) {
                        c = buf.charAt(pos);
                        if (this.value < this.prevValue) {
                            this.value = 0x110000;
                        }
                        this.prevValue = this.value;
                        if (c >= '0' && c <= '9') {
                            this.seenDigits = true;
                            this.value *= 16;
                            this.value += c - 48;
                            continue;
                        }
                        if (c >= 'A' && c <= 'F') {
                            this.seenDigits = true;
                            this.value *= 16;
                            this.value += c - 65 + 10;
                            continue;
                        }
                        if (c >= 'a' && c <= 'f') {
                            this.seenDigits = true;
                            this.value *= 16;
                            this.value += c - 97 + 10;
                            continue;
                        }
                        if (c == ';') {
                            if (this.seenDigits) {
                                state = 13;
                                continue block62;
                            }
                            this.errNoDigitsInNCR();
                            this.appendStrBuf(';');
                            this.emitOrAppendStrBuf(returnState);
                            state = returnState;
                            continue block62;
                        }
                        if (!this.seenDigits) {
                            this.errNoDigitsInNCR();
                            this.emitOrAppendStrBuf(returnState);
                            state = returnState;
                            reconsume = true;
                            continue block62;
                        }
                        this.errCharRefLacksSemicolon();
                        state = 13;
                        reconsume = true;
                        continue block62;
                    }
                    break block62;
                }
                default: {
                    continue block62;
                }
            }
            break;
        }
        return this.attributes;
    }

    private void appendStrBufToLongStrBuf() {
        this.appendLongStrBuf(this.strBuf, 0, this.strBufLen);
    }

    private void appendLongStrBuf(char[] buffer, int offset, int length) {
        int reqLen = this.longStrBufLen + length;
        if (this.longStrBuf.length < reqLen) {
            char[] newBuf = new char[reqLen + (reqLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            this.longStrBuf = newBuf;
        }
        System.arraycopy(buffer, offset, this.longStrBuf, this.longStrBufLen, length);
        this.longStrBufLen = reqLen;
    }

    private void appendLongStrBuf(char[] arr) {
        this.appendLongStrBuf(arr, 0, arr.length);
    }

    private void appendLongStrBuf(char c) {
        if (this.longStrBufLen == this.longStrBuf.length) {
            char[] newBuf = new char[this.longStrBufLen + (this.longStrBufLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            this.longStrBuf = newBuf;
        }
        this.longStrBuf[this.longStrBufLen++] = c;
    }

    private void appendLongStrBufLineFeed() {
        this.appendLongStrBuf('\n');
    }

    private void appendStrBuf(char c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + 1024];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = c;
    }

    private void clearLongStrBufForNextState() {
        this.longStrBufLen = 0;
    }

    private void clearLongStrBuf() {
        this.longStrBufLen = 0;
    }

    private void clearLongStrBufAndAppendCurrentC(char c) {
        this.longStrBuf[0] = c;
        this.longStrBufLen = 1;
    }

    private void clearStrBufAndAppendCurrentC(char c) {
        this.strBuf[0] = c;
        this.strBufLen = 1;
    }

    private void emitOrAppend(char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val);
        }
    }

    private void emitOrAppendOne(char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val[0]);
        }
    }

    private void emitOrAppendTwo(char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val[0]);
            this.appendLongStrBuf(val[1]);
        }
    }

    private void emitOrAppendStrBuf(int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendStrBufToLongStrBuf();
        }
    }

    private String longStrBufToString() {
        return new String(this.longStrBuf, 0, this.longStrBufLen);
    }

    private void attributeNameComplete() throws SAXException {
        this.attributeName = new String(this.strBuf, 0, this.strBufLen).intern();
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!this.attributes.getQName(i).equals(this.attributeName)) continue;
            this.errDuplicateAttribute();
            this.attributeName = null;
            return;
        }
    }

    private void addAttributeWithValue() throws SAXException {
        if (this.attributeName != null) {
            String value = this.longStrBufToString();
            if (value.indexOf(60) != -1) {
                this.errAttributeValueContainsLt();
                return;
            }
            if (this.badCharInCandidateAttributeName()) {
                return;
            }
            this.attributes.addAttribute("", "", this.attributeName, "", value);
            this.attributeName = null;
        }
    }

    private void addAttributeWithoutValue() throws SAXException {
        if (this.attributeName != null) {
            if (this.badCharInCandidateAttributeName()) {
                return;
            }
            this.attributes.addAttribute("", "", this.attributeName, "", null);
            this.errAttributeWithNoValue();
            this.attributeName = null;
        }
    }

    private boolean badCharInCandidateAttributeName() {
        return this.attributeName.indexOf(47) != -1 || this.attributeName.indexOf(62) != -1 || this.attributeName.indexOf(34) != -1 || this.attributeName.indexOf(39) != -1 || this.attributeName.indexOf(60) != -1 || this.attributeName.indexOf(61) != -1;
    }

    private void handleNcrValue(int returnState) throws SAXException {
        if (!this.isLegalXmlCharValue(this.value)) {
            this.errNcrIllegalValueForXml();
        } else {
            char ch;
            if (this.value <= 65535) {
                if ((this.value & 0xF800) == 55296) {
                    this.errNcrSurrogate();
                    this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
                } else {
                    ch = (char)this.value;
                    if (this.value >= 64976 && this.value <= 65007) {
                        this.errNcrUnassigned();
                    } else if ((this.value & 0xFFFE) == 65534) {
                        ch = this.errNcrNonCharacter(ch);
                    } else if (this.value >= 127 && this.value <= 159) {
                        this.errNcrControlChar();
                    } else {
                        this.maybeWarnPrivateUse(ch);
                    }
                    this.bmpChar[0] = ch;
                    this.emitOrAppendOne(this.bmpChar, returnState);
                }
            } else if (this.value <= 0x10FFFF) {
                this.maybeWarnPrivateUseAstral();
                if ((this.value & 0xFFFE) == 65534) {
                    this.errAstralNonCharacter(this.value);
                }
                this.astralChar[0] = (char)(55232 + (this.value >> 10));
                this.astralChar[1] = (char)(56320 + (this.value & 0x3FF));
                this.emitOrAppendTwo(this.astralChar, returnState);
            } else {
                this.errNcrOutOfRange();
                this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
            }
            if ((this.value & 0xF800) == 55296) {
                this.errNcrSurrogate();
                this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
            } else if (this.value <= 65535) {
                ch = (char)this.value;
                if (this.value >= 64976 && this.value <= 65007) {
                    this.errNcrUnassigned();
                } else if ((this.value & 0xFFFE) == 65534) {
                    ch = this.errNcrNonCharacter(ch);
                } else if (this.value >= 127 && this.value <= 159) {
                    this.errNcrControlChar();
                } else {
                    this.maybeWarnPrivateUse(ch);
                }
                this.bmpChar[0] = ch;
                this.emitOrAppendOne(this.bmpChar, returnState);
            } else if (this.value <= 0x10FFFF) {
                this.maybeWarnPrivateUseAstral();
                this.astralChar[0] = (char)(55232 + (this.value >> 10));
                this.astralChar[1] = (char)(56320 + (this.value & 0x3FF));
                this.emitOrAppend(this.astralChar, returnState);
            } else {
                this.errNcrOutOfRange();
                this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
            }
        }
    }

    private String toUPlusString(char c) {
        String hexString = Integer.toHexString(c);
        switch (hexString.length()) {
            case 1: {
                return "U+000" + hexString;
            }
            case 2: {
                return "U+00" + hexString;
            }
            case 3: {
                return "U+0" + hexString;
            }
            case 4: {
                return "U+" + hexString;
            }
        }
        throw new RuntimeException("Unreachable.");
    }

    private boolean isLegalXmlCharValue(int charval) {
        return charval == 9 || charval == 10 || charval == 13 || charval >= 32 && charval <= 55295 || charval >= 57344 && charval <= 65533 || charval >= 65536 && charval <= 0x10FFFF;
    }

    private boolean isPrivateUse(char c) {
        return c >= '\ue000' && c <= '\uf8ff';
    }

    private boolean isAstralPrivateUse(int c) {
        return c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    private void warnAboutPrivateUseChar() throws SAXException {
        if (!this.alreadyWarnedAboutPrivateUseCharacters) {
            this.warn("Document uses the Unicode Private Use Area(s), which should not be used in publicly exchanged documents. (Charmod C073)");
            this.alreadyWarnedAboutPrivateUseCharacters = true;
        }
    }

    private void errBadCharBeforeAttributeNameOrNull(char c) throws SAXException {
        if (c == '=') {
            this.errEqualsSignBeforeAttributeName();
        } else if (c != '\ufffd') {
            this.errQuoteBeforeAttributeName(c);
        } else {
            this.err("The character \u201c" + c + "\u201d is not allowed in \u201c" + this.piTarget + "\u201d pseudo-attribute names.");
        }
    }

    private void errCharRefLacksSemicolon() throws SAXException {
        this.err("Character reference was not terminated by a semicolon.");
    }

    private void errDuplicateAttribute() throws SAXException {
        this.err("Duplicate \u201c" + this.piTarget + "\u201d pseudo-attribute \u201c" + this.attributeName + "\u201d.");
    }

    private void errEqualsSignBeforeAttributeName() throws SAXException {
        this.err("Saw \u201c=\u201d when expecting \u201c" + this.piTarget + "\u201d pseudo-attribute name. Probable cause: Pseudo-attribute name missing.");
    }

    private void errLtOrEqualsOrGraveInUnquotedAttributeOrNull(char c) throws SAXException {
        switch (c) {
            case '=': {
                this.err("\u201c=\u201d at the start of an unquoted \u201c" + this.piTarget + "\u201d pseudo-attribute value. Probable cause: Stray duplicate equals sign.");
                return;
            }
            case '<': {
                return;
            }
            case '`': {
                this.err("\u201c`\u201d at the start of an unquoted \u201c" + this.piTarget + "\u201d pseudo-attribute value. Probable cause: Using the wrong character as a quote.");
                return;
            }
        }
    }

    private void errNoSpaceBetweenAttributes() throws SAXException {
        this.err("Space is required between \u201c" + this.piTarget + "\u201d pseudo-attributes.");
    }

    private void errQuoteBeforeAttributeName(char c) throws SAXException {
        this.err("Saw \u201c" + c + "\u201d when expecting a pseudo-attribute name. Probable cause: \u201c=\u201d missing immediately before.");
    }

    private void errQuoteOrLtInAttributeNameOrNull(char c) throws SAXException {
        if (c != '\ufffd') {
            this.err("Quote \u201c" + c + "\u201d in pseudo-attribute name. Probable cause: Matching quote missing somewhere earlier.");
        }
    }

    private void errUnquotedAttributeValOrNull() throws SAXException {
        this.err("Found unquoted value for \u201c" + this.piTarget + "\u201d pseudo-attribute \u201c" + this.attributeName + "\u201d. The value of all pseudo-attributes in \u201c" + this.piTarget + "\u201d instructions must be quoted.");
    }

    private void errNoNamedCharacterMatch() throws SAXException {
        if (this.getErrorHandler() == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("\u201c&\u201d did not start a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.getDocumentLocator());
        this.getErrorHandler().error(spe);
    }

    private void errNcrControlChar() throws SAXException {
        this.warn("Character reference expands to a control character (" + this.toUPlusString((char)this.value) + ").");
    }

    private void errNcrIllegalValueForXml() throws SAXException {
        this.err("Character reference expands to a character that is not legal in XML (" + this.toUPlusString((char)this.value) + ").");
    }

    private void errNcrSurrogate() throws SAXException {
        this.err("Character reference expands to a surrogate.");
    }

    private void errNcrUnassigned() throws SAXException {
        this.err("Character reference expands to a permanently unassigned code point.");
    }

    private char errNcrNonCharacter(char ch) throws SAXException {
        this.err("Character reference expands to a non-character (" + this.toUPlusString((char)this.value) + ").");
        return ch;
    }

    private void errNcrOutOfRange() throws SAXException {
        this.err("Character reference outside the permissible Unicode range.");
    }

    private void errNoDigitsInNCR() throws SAXException {
        this.err("No digits after \u201c" + new String(this.strBuf, 0, this.strBufLen) + "\u201d.");
    }

    private void errUnescapedAmpersandInterpretedAsCharacterReference() throws SAXException {
        if (this.getErrorHandler() == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("The string following \u201c&\u201d was interpreted as a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.getDocumentLocator());
        this.getErrorHandler().error(spe);
    }

    private void maybeWarnPrivateUse(char ch) throws SAXException {
        if (this.getErrorHandler() != null && this.isPrivateUse(ch)) {
            this.warnAboutPrivateUseChar();
        }
    }

    private void maybeWarnPrivateUseAstral() throws SAXException {
        if (this.getErrorHandler() != null && this.isAstralPrivateUse(this.value)) {
            this.warnAboutPrivateUseChar();
        }
    }

    private void errAstralNonCharacter(int ch) throws SAXException {
        this.err("Character reference expands to an astral non-character (" + this.toUPlusString((char)this.value) + ").");
    }

    private static String newAsciiLowerCaseStringFromString(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    private static String newAsciiUpperCaseStringFromString(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    private static enum PseudoAttrName {
        HREF,
        TYPE,
        TITLE,
        MEDIA,
        CHARSET,
        ALTERNATE,
        INVALID;


        private static PseudoAttrName toCaps(String str) {
            try {
                if (!str.toLowerCase().equals(str)) {
                    return INVALID;
                }
                return PseudoAttrName.valueOf(XmlPiChecker.newAsciiUpperCaseStringFromString(str));
            }
            catch (Exception ex) {
                return INVALID;
            }
        }
    }
}

