/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.LinkedList;
import nu.validator.checker.Checker;
import nu.validator.checker.DatatypeMismatchException;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.datatype.ScriptDocumentation;
import nu.validator.datatype.TimeDatetime;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import nu.validator.vendor.relaxng.datatype.DatatypeStreamingValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class TextContentChecker
extends Checker {
    private static final String XHTML_URL = "http://www.w3.org/1999/xhtml";
    private final LinkedList<DatatypeStreamingValidator> stack = new LinkedList();
    private final LinkedList<String[]> openElements = new LinkedList();
    private String[] parent = null;
    private boolean inEmptyTitleOrOption = false;

    private DatatypeStreamingValidator streamingValidatorFor(String uri, String localName, Attributes atts) {
        if (XHTML_URL.equals(uri)) {
            if ("time".equals(localName) && atts.getIndex("", "datetime") < 0) {
                return TimeDatetime.THE_INSTANCE.createStreamingValidator(null);
            }
            if ("script".equals(localName) && atts.getIndex("", "src") >= 0) {
                return ScriptDocumentation.THE_INSTANCE.createStreamingValidator(null);
            }
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        block3: for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.inEmptyTitleOrOption = false;
                }
            }
        }
        for (DatatypeStreamingValidator dsv : this.stack) {
            if (dsv == null) continue;
            dsv.addCharacters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inEmptyTitleOrOption && XHTML_URL.equals(uri) && "title".equals(localName)) {
            this.err("Element \u201ctitle\u201d must not be empty.");
            this.inEmptyTitleOrOption = false;
        } else if (this.inEmptyTitleOrOption && XHTML_URL.equals(uri) && "option".equals(localName) && (this.parent == null || !XHTML_URL.equals(this.parent[0]) || !"datalist".equals(this.parent[1]))) {
            this.err("Element \u201coption\u201d without attribute \u201clabel\u201d must not be empty.");
            this.inEmptyTitleOrOption = false;
        }
        this.openElements.pop();
        DatatypeStreamingValidator dsv = this.stack.removeLast();
        if (dsv != null) {
            try {
                dsv.checkValid();
            }
            catch (DatatypeException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    this.err("The text content of element \u201c" + localName + "\u201d from namespace \u201c" + uri + "\u201d was not in the required format.");
                }
                if ("time".equals(localName)) {
                    try {
                        this.errBadTextContent(e, TimeDatetime.class, localName, uri);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if ("script".equals(localName)) {
                    try {
                        this.errBadTextContent(e, ScriptDocumentation.class, localName, uri);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                this.err("The text content of element \u201c" + localName + "\u201d was not in the required format: " + msg.split(": ")[1]);
            }
        }
    }

    private void errBadTextContent(DatatypeException e, Class<?> datatypeClass, String localName, String uri) throws SAXException, ClassNotFoundException {
        if (this.getErrorHandler() != null) {
            Html5DatatypeException ex5 = (Html5DatatypeException)e;
            String exceptionMessage = e.getMessage().split(": ")[1];
            Object message = "The text content of element \u201c" + localName + "\u201d was not in the required format: ";
            if (ex5.isWarning()) {
                message = exceptionMessage.contains("Typo for") ? "" : "Double-check the text content of element \u201c" + localName + "\u201d: ";
            }
            DatatypeMismatchException dme = new DatatypeMismatchException((String)message + exceptionMessage, this.getDocumentLocator(), datatypeClass, ex5.isWarning());
            this.getErrorHandler().error(dme);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stack.addLast(this.streamingValidatorFor(uri, localName, atts));
        String[] uriAndName = new String[]{uri, localName};
        this.parent = this.openElements.peek();
        this.openElements.push(uriAndName);
        if (XHTML_URL.equals(uri) && "title".equals(localName) || "option".equals(localName) && atts.getIndex("", "label") < 0) {
            this.inEmptyTitleOrOption = true;
        }
    }

    @Override
    public void reset() {
        this.stack.clear();
        this.openElements.clear();
    }
}

